/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.IOException;
import java.io.Reader;

@Api
public class BufferedReader
extends Reader {
    private static final int _DEFAULT_SIZE = 128;
    private final Reader _in;
    private char[] _buf;
    private int _limit;
    private int _rp;
    private int _wp;
    private StringBuilder _sBuffer;

    @Api
    public BufferedReader(Reader __r, int __bs) throws IllegalArgumentException, NullPointerException {
        if (__r == null) {
            throw new NullPointerException("NARG");
        }
        if (__bs <= 0) {
            throw new IllegalArgumentException("ZZ0g");
        }
        this._in = __r;
        this._buf = new char[__bs + 1];
        this._limit = __bs;
    }

    @Api
    public BufferedReader(Reader __r) throws NullPointerException {
        this(__r, 128);
    }

    @Override
    public void close() throws IOException {
        char[] buf = this._buf;
        if (buf != null) {
            this._buf = null;
        }
        this._in.close();
    }

    @Override
    @Api
    public void mark(int __l) throws IOException {
        char[] buf = this._buf;
        if (buf == null) {
            throw new IOException("CLSD");
        }
        throw Debugging.todo();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        char[] buf = this._buf;
        if (buf == null) {
            throw new IOException("CLSD");
        }
        int rp = this._rp;
        if (rp == this._wp) {
            int rc = this._in.read(buf, 0, this._limit);
            if (rc < 0) {
                return -1;
            }
            rp = 0;
            this._wp = rc;
        }
        char rv = buf[rp++];
        this._rp = rp;
        return rv;
    }

    @Override
    public int read(char[] __c) throws IOException, NullPointerException {
        return this.read(__c, 0, __c.length);
    }

    @Override
    public int read(char[] __c, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        int rv;
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __c.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        char[] buf = this._buf;
        if (buf == null) {
            throw new IOException("CLOS");
        }
        int wp = this._wp;
        int rp = this._rp;
        int left = wp - rp;
        if (left > 0) {
            int lim = Math.min(left, __l);
            for (rv = 0; rv < lim; ++rv) {
                __c[__o++] = buf[rp++];
            }
            if (rp == wp) {
                this._rp = 0;
                this._wp = 0;
            }
        }
        Reader in = this._in;
        while (rv < __l) {
            int rc = in.read();
            if (rc < 0) {
                return rv == 0 ? -1 : rv;
            }
            __c[__o++] = (char)rc;
            ++rv;
        }
        return rv;
    }

    @Api
    public String readLine() throws IOException {
        boolean readEof;
        char[] buf = this._buf;
        if (buf == null) {
            throw new IOException("CLSD");
        }
        int rp = this._rp;
        int wp = this._wp;
        int limit = this._limit;
        int diff = wp - rp;
        StringBuilder sb = this._sBuffer;
        if (sb == null) {
            this._sBuffer = sb = new StringBuilder(64);
        }
        sb.setLength(0);
        sb.ensureCapacity(Math.max(diff, 64));
        Reader in = this._in;
        boolean wasinbuf = false;
        do {
            boolean readNl = false;
            boolean stoppedOnCr = false;
            readEof = false;
            int ln = rp;
            if (ln < wp) {
                wasinbuf = true;
                while (ln < wp) {
                    char c2 = buf[ln];
                    stoppedOnCr = c2 == '\r';
                    if (stoppedOnCr || c2 == '\n') {
                        readNl = true;
                        break;
                    }
                    ++ln;
                }
                sb.append(buf, rp, ln - rp);
                this._rp = rp = ln;
            }
            if (rp == wp) {
                int rc = in.read(buf, 0, limit);
                if (rc < 0) {
                    if (!wasinbuf && sb.length() == 0) {
                        this._rp = 0;
                        this._wp = 0;
                        return null;
                    }
                    readEof = true;
                }
                ln = 0;
                rp = 0;
                this._rp = 0;
                this._wp = wp = Math.max(rc, 0);
            }
            if (!readNl) continue;
            if (stoppedOnCr) {
                int gap = ln + 1;
                if (gap < wp) {
                    rp = buf[gap] == '\n' ? ln + 2 : ln + 1;
                } else {
                    int rx = in.read();
                    if (rx >= 0 && rx != 10) {
                        buf[wp++] = (char)rx;
                        this._rp = rp;
                        this._wp = wp;
                        break;
                    }
                    rp = ln + 1;
                }
            } else {
                rp = ln + 1;
            }
            this._rp = rp;
            break;
        } while (!readEof);
        return sb.toString();
    }

    @Override
    public boolean ready() throws IOException {
        char[] buf = this._buf;
        if (buf == null) {
            throw new IOException("CLSD");
        }
        return this._rp < this._wp || this._in.ready();
    }

    @Override
    public void reset() throws IOException {
        char[] buf = this._buf;
        if (buf == null) {
            throw new IOException("CLOS");
        }
        throw Debugging.todo();
    }
}

