/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.Api;
import java.io.IOException;
import java.io.InputStream;

@Api
public class ByteArrayInputStream
extends InputStream {
    @Api
    protected byte[] buf;
    @Api
    protected int count;
    @Api
    protected int mark;
    @Api
    protected int pos;

    @Api
    public ByteArrayInputStream(byte[] __b) throws NullPointerException {
        this(__b, 0, __b.length);
    }

    @Api
    public ByteArrayInputStream(byte[] __b, int __o, int __l) throws NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        this.buf = __b;
        this.pos = __o;
        this.mark = __o;
        this.count = Math.min(__o + __l, __b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        ByteArrayInputStream byteArrayInputStream = this;
        synchronized (byteArrayInputStream) {
            return Math.max(0, this.count - Math.max(0, this.pos));
        }
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int __p) {
        ByteArrayInputStream byteArrayInputStream = this;
        synchronized (byteArrayInputStream) {
            this.mark = this.pos;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() {
        ByteArrayInputStream byteArrayInputStream = this;
        synchronized (byteArrayInputStream) {
            int pos = this.pos;
            int count = this.count;
            if (pos >= count) {
                return -1;
            }
            int rv = this.buf[pos] & 0xFF;
            this.pos = pos + 1;
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] __b) throws NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int len = __b.length;
        ByteArrayInputStream byteArrayInputStream = this;
        synchronized (byteArrayInputStream) {
            byte[] buf = this.buf;
            int pos = this.pos;
            int count = this.count;
            int read = count - pos;
            if (len < read) {
                read = len;
            }
            ObjectShelf.arrayCopy(buf, pos, __b, 0, read);
            this.pos = pos += read;
            if (read == 0) {
                return pos >= count ? -1 : 0;
            }
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        ByteArrayInputStream byteArrayInputStream = this;
        synchronized (byteArrayInputStream) {
            byte[] buf = this.buf;
            int pos = this.pos;
            int count = this.count;
            int read = count - pos;
            if (__l < read) {
                read = __l;
            }
            ObjectShelf.arrayCopy(buf, pos, __b, __o, read);
            this.pos = pos += read;
            if (read == 0) {
                return pos >= count ? -1 : 0;
            }
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ByteArrayInputStream byteArrayInputStream = this;
        synchronized (byteArrayInputStream) {
            this.pos = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long __n) {
        if (__n <= 0L) {
            return 0L;
        }
        ByteArrayInputStream byteArrayInputStream = this;
        synchronized (byteArrayInputStream) {
            int newpos;
            int pos = this.pos;
            int count = this.count;
            int read = count - pos;
            this.pos = __n < (long)read ? (newpos = (int)((long)pos + __n)) : (newpos = count);
            return newpos - pos;
        }
    }
}

