/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import cc.squirreljme.runtime.cldc.annotation.Api;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

@Api
public class DataInputStream
extends InputStream
implements DataInput {
    @Api
    protected final InputStream in;

    @Api
    public DataInputStream(InputStream __in) throws NullPointerException {
        if (__in == null) {
            throw new NullPointerException();
        }
        this.in = __in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int __rl) {
        this.in.mark(__rl);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public final int read() throws IOException {
        return this.in.read();
    }

    @Override
    public final int read(byte[] __b) throws IOException {
        return this.in.read(__b);
    }

    @Override
    public final int read(byte[] __b, int __o, int __l) throws IOException {
        return this.in.read(__b, __o, __l);
    }

    @Override
    public final boolean readBoolean() throws EOFException, IOException {
        int rv = this.in.read();
        if (rv < 0) {
            throw new EOFException("EOFF");
        }
        return rv != 0;
    }

    @Override
    public final byte readByte() throws EOFException, IOException {
        int rv = this.in.read();
        if (rv < 0) {
            throw new EOFException("EOFF");
        }
        return (byte)rv;
    }

    @Override
    public final char readChar() throws EOFException, IOException {
        int b2;
        InputStream in = this.in;
        int a2 = in.read();
        if ((a2 | (b2 = in.read())) < 0) {
            throw new EOFException("EOFF");
        }
        return (char)((a2 & 0xFF) << 8 | b2 & 0xFF);
    }

    @Override
    public final double readDouble() throws EOFException, IOException {
        int h2;
        int g2;
        int f2;
        int e2;
        int d2;
        int c2;
        int b2;
        InputStream in = this.in;
        int a2 = in.read();
        if ((a2 | (b2 = in.read()) | (c2 = in.read()) | (d2 = in.read()) | (e2 = in.read()) | (f2 = in.read()) | (g2 = in.read()) | (h2 = in.read())) < 0) {
            throw new EOFException("EOFF");
        }
        return Double.longBitsToDouble((long)((a2 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (c2 & 0xFF) << 8 | d2 & 0xFF) << 32 | (long)((e2 & 0xFF) << 24 | (f2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | h2 & 0xFF) & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws EOFException, IOException {
        int d2;
        int c2;
        int b2;
        InputStream in = this.in;
        int a2 = in.read();
        if ((a2 | (b2 = in.read()) | (c2 = in.read()) | (d2 = in.read())) < 0) {
            throw new EOFException("EOFF");
        }
        return Float.intBitsToFloat((a2 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (c2 & 0xFF) << 8 | d2 & 0xFF);
    }

    @Override
    public final void readFully(byte[] __b) throws EOFException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        this.__readFully(__b, 0, __b.length);
    }

    @Override
    public final void readFully(byte[] __b, int __o, int __l) throws EOFException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        this.__readFully(__b, __o, __l);
    }

    @Override
    public final int readInt() throws EOFException, IOException {
        int d2;
        int c2;
        int b2;
        InputStream in = this.in;
        int a2 = in.read();
        if ((a2 | (b2 = in.read()) | (c2 = in.read()) | (d2 = in.read())) < 0) {
            throw new EOFException("EOFF");
        }
        return (a2 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (c2 & 0xFF) << 8 | d2 & 0xFF;
    }

    @Override
    public final long readLong() throws EOFException, IOException {
        int h2;
        int g2;
        int f2;
        int e2;
        int d2;
        int c2;
        int b2;
        InputStream in = this.in;
        int a2 = in.read();
        if ((a2 | (b2 = in.read()) | (c2 = in.read()) | (d2 = in.read()) | (e2 = in.read()) | (f2 = in.read()) | (g2 = in.read()) | (h2 = in.read())) < 0) {
            throw new EOFException("EOFF");
        }
        return (long)((a2 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (c2 & 0xFF) << 8 | d2 & 0xFF) << 32 | (long)((e2 & 0xFF) << 24 | (f2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | h2 & 0xFF) & 0xFFFFFFFFL;
    }

    @Override
    public final short readShort() throws EOFException, IOException {
        int b2;
        InputStream in = this.in;
        int a2 = in.read();
        if ((a2 | (b2 = in.read())) < 0) {
            throw new EOFException("EOFF");
        }
        return (short)((a2 & 0xFF) << 8 | b2 & 0xFF);
    }

    @Override
    public final int readUnsignedByte() throws EOFException, IOException {
        int rv = this.in.read();
        if (rv < 0) {
            throw new EOFException("EOFF");
        }
        return rv & 0xFF;
    }

    @Override
    public final int readUnsignedShort() throws EOFException, IOException {
        int b2;
        InputStream in = this.in;
        int a2 = in.read();
        if ((a2 | (b2 = in.read())) < 0) {
            throw new EOFException("EOFF");
        }
        return (a2 & 0xFF) << 8 | b2 & 0xFF;
    }

    @Override
    public final String readUTF() throws EOFException, IOException, UTFDataFormatException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long __n) throws IOException {
        if (__n < 0L) {
            return 0L;
        }
        return this.in.skip(__n);
    }

    @Override
    public final int skipBytes(int __n) throws IOException {
        InputStream in = this.in;
        for (int i2 = 0; i2 < __n; ++i2) {
            if (in.read() >= 0) continue;
            return i2;
        }
        return __n;
    }

    private void __readFully(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        int rc;
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        InputStream in = this.in;
        for (int rv = 0; rv < __l; rv += rc) {
            rc = in.read(__b, __o + rv, __l - rv);
            if (rc >= 0) continue;
            throw new EOFException("EOFF");
        }
    }

    @Api
    public static final String readUTF(DataInput __in) throws EOFException, IOException, NullPointerException, UTFDataFormatException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        int numBytes = __in.readUnsignedShort();
        if (numBytes == 0) {
            return "";
        }
        int queueAt = 0;
        byte[] queue = new byte[numBytes];
        __in.readFully(queue);
        int charAt = 0;
        char[] result = new char[numBytes];
        try {
            while (queueAt < numBytes) {
                byte b2;
                byte a2;
                if (((a2 = queue[queueAt++]) & 0x80) == 0) {
                    if (a2 == 0) {
                        throw new UTFDataFormatException("ZZ0j");
                    }
                    result[charAt++] = (char)(a2 & 0xFF);
                    continue;
                }
                if ((a2 & 0xE0) == 192) {
                    if (((b2 = queue[queueAt++]) & 0xC0) != 128) {
                        throw new UTFDataFormatException(String.format("ZZ0k %02x%02x", a2, b2));
                    }
                    result[charAt++] = (char)((a2 & 0x1F) << 6 | b2 & 0x3F);
                    continue;
                }
                if ((a2 & 0xF0) == 224) {
                    b2 = queue[queueAt++];
                    byte c2 = queue[queueAt++];
                    if ((b2 & 0xC0) != 128 || (c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException(String.format("ZZ0l %02x%02x%02x", a2, b2, c2));
                    }
                    result[charAt++] = (char)((a2 & 0xF) << 12 | (b2 & 0x3F) << 6 | c2 & 0x3F);
                    continue;
                }
                throw new UTFDataFormatException(String.format("ZZ0m %02x", a2));
            }
        }
        catch (IndexOutOfBoundsException __e) {
            EOFException t2 = new EOFException("EOFF");
            t2.initCause(__e);
            throw t2;
        }
        return new String(result, 0, charAt);
    }
}

