/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

@Api
public class DataOutputStream
extends OutputStream
implements DataOutput {
    @Api
    protected OutputStream out;
    @Api
    protected int written;

    @Api
    public DataOutputStream(OutputStream __o) throws NullPointerException {
        if (__o == null) {
            throw new NullPointerException("NARG");
        }
        this.out = __o;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Api
    public final int size() {
        return this.written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int __b) throws IOException {
        DataOutputStream dataOutputStream = this;
        synchronized (dataOutputStream) {
            this.out.write(__b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] __b) throws IOException {
        DataOutputStream dataOutputStream = this;
        synchronized (dataOutputStream) {
            this.out.write(__b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] __b, int __o, int __l) throws IOException {
        DataOutputStream dataOutputStream = this;
        synchronized (dataOutputStream) {
            this.out.write(__b, __o, __l);
        }
    }

    @Override
    public final void writeBoolean(boolean __v) throws IOException {
        this.out.write(__v ? 1 : 0);
        ++this.written;
    }

    @Override
    public final void writeByte(int __v) throws IOException {
        this.out.write(__v);
        ++this.written;
    }

    @Override
    public final void writeBytes(String __v) throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final void writeChar(int __v) throws IOException {
        this.write(__v >> 8 & 0xFF);
        this.write(__v & 0xFF);
        this.written += 2;
    }

    @Override
    public final void writeChars(String __v) throws IOException, NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __v.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = __v.charAt(i2);
            this.write(c2 >> 8 & 0xFF);
            this.write(c2 & 0xFF);
            this.written += 2;
        }
    }

    @Override
    public final void writeDouble(double __v) throws IOException {
        long v2 = Double.doubleToRawLongBits(__v);
        OutputStream out = this.out;
        out.write((int)(v2 >> 56) & 0xFF);
        out.write((int)(v2 >> 48) & 0xFF);
        out.write((int)(v2 >> 40) & 0xFF);
        out.write((int)(v2 >> 32) & 0xFF);
        out.write((int)(v2 >> 24) & 0xFF);
        out.write((int)(v2 >> 16) & 0xFF);
        out.write((int)(v2 >> 8) & 0xFF);
        out.write((int)v2 & 0xFF);
        this.written += 8;
    }

    @Override
    public final void writeFloat(float __v) throws IOException {
        int v2 = Float.floatToRawIntBits(__v);
        OutputStream out = this.out;
        out.write(v2 >> 24 & 0xFF);
        out.write(v2 >> 16 & 0xFF);
        out.write(v2 >> 8 & 0xFF);
        out.write(v2 & 0xFF);
        this.written += 4;
    }

    @Override
    public final void writeInt(int __v) throws IOException {
        OutputStream out = this.out;
        out.write(__v >> 24 & 0xFF);
        out.write(__v >> 16 & 0xFF);
        out.write(__v >> 8 & 0xFF);
        out.write(__v & 0xFF);
        this.written += 4;
    }

    @Override
    public final void writeLong(long __v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(__v >> 56) & 0xFF);
        out.write((int)(__v >> 48) & 0xFF);
        out.write((int)(__v >> 40) & 0xFF);
        out.write((int)(__v >> 32) & 0xFF);
        out.write((int)(__v >> 24) & 0xFF);
        out.write((int)(__v >> 16) & 0xFF);
        out.write((int)(__v >> 8) & 0xFF);
        out.write((int)__v & 0xFF);
        this.written += 8;
    }

    @Override
    public final void writeShort(int __v) throws IOException {
        OutputStream out = this.out;
        out.write(__v >> 8 & 0xFF);
        out.write(__v & 0xFF);
        this.written += 2;
    }

    @Override
    public final void writeUTF(String __v) throws IOException, NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        OutputStream out = this.out;
        int n2 = __v.length();
        out.write(n2 >> 8 & 0xFF);
        out.write(n2 & 0xFF);
        char[] chars = __v.toCharArray();
        int written = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = chars[i2];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                char d2;
                int end;
                for (end = i2 + 1; end < n2 && (d2 = chars[end]) != '\u0000' && c2 <= '\u007f'; ++end) {
                }
                if (end == i2) {
                    out.write((byte)c2);
                    ++written;
                    continue;
                }
                int xl = end - i2;
                byte[] chunk = new byte[xl];
                int o2 = 0;
                while (o2 < xl) {
                    chunk[o2] = (byte)chars[i2];
                    ++o2;
                    ++i2;
                }
                out.write(chunk, 0, xl);
                written += xl;
                continue;
            }
            if (c2 == '\u0000' || c2 >= '\u0080' && c2 <= '\u07ff') {
                out.write(0xC0 | c2 >>> 6 & 0x1F);
                out.write(0x80 | c2 & 0x3F);
                written += 2;
                continue;
            }
            out.write(0xE0 | c2 >>> 12 & 0xF);
            out.write(0x80 | c2 >>> 6 & 0x3F);
            out.write(0x80 | c2 & 0x3F);
            written += 3;
        }
        this.written += written;
    }
}

