/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.io.CodecFactory;
import cc.squirreljme.runtime.cldc.io.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

@Api
public class InputStreamReader
extends Reader {
    private final InputStream _in;
    private final Decoder _decoder;
    private final byte[] _store;

    @Api
    public InputStreamReader(InputStream __in) throws NullPointerException {
        Decoder d2;
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        this._in = __in;
        this._decoder = d2 = CodecFactory.defaultDecoder();
        this._store = new byte[d2.maximumSequenceLength()];
    }

    @Api
    public InputStreamReader(InputStream __in, String __enc) throws NullPointerException, UnsupportedEncodingException {
        Decoder d2;
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        this._in = __in;
        this._decoder = d2 = CodecFactory.decoder(__enc);
        this._store = new byte[d2.maximumSequenceLength()];
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }

    @Api
    public String getEncoding() {
        return this._decoder.encodingName();
    }

    @Override
    public int read() throws IOException {
        int cha;
        InputStream in = this._in;
        Decoder decoder = this._decoder;
        byte[] store = this._store;
        int storelen = 0;
        int declimit = store.length;
        do {
            if (storelen >= declimit) {
                throw new IOException("ZZ0o " + storelen);
            }
            int brc = in.read(store, storelen, 1);
            if (brc >= 0) continue;
            if (storelen <= 0) {
                return -1;
            }
            cha = decoder.decode(store, 0, storelen);
            if (cha >= 0) {
                return (char)cha;
            }
            return 65533;
        } while ((cha = decoder.decode(store, 0, ++storelen)) < 0);
        return (char)cha;
    }

    @Override
    public int read(char[] __c, int __o, int __l) throws IOException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __c.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        InputStream in = this._in;
        Decoder decoder = this._decoder;
        byte[] store = this._store;
        int storelen = 0;
        int declimit = store.length;
        int rv = 0;
        int baseo = __o;
        int o2 = __o;
        while (rv < __l) {
            int cha;
            if (storelen >= declimit) {
                throw new IOException("ZZ0p " + storelen);
            }
            int brc = in.read(store, storelen, 1);
            if (brc < 0) {
                if (storelen <= 0) {
                    return rv > 0 ? rv : brc;
                }
                cha = decoder.decode(store, 0, storelen);
                __c[o2++] = cha >= 0 ? (int)cha : 65533;
                return ++rv;
            }
            if ((cha = decoder.decode(store, 0, ++storelen)) < 0) continue;
            __c[o2++] = (char)cha;
            storelen = 0;
            ++rv;
        }
        return rv;
    }

    @Override
    public boolean ready() throws IOException {
        return this._in.available() >= this._store.length;
    }
}

