/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.io.CodecFactory;
import cc.squirreljme.runtime.cldc.io.Encoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

@Api
public class OutputStreamWriter
extends Writer {
    private final Encoder _encoder;
    private final OutputStream _out;
    private final byte[] _workBuf;

    @Api
    public OutputStreamWriter(OutputStream __out) throws NullPointerException {
        this(__out, CodecFactory.defaultEncoder());
    }

    @Api
    public OutputStreamWriter(OutputStream __out, String __charset) throws NullPointerException, UnsupportedEncodingException {
        this(__out, CodecFactory.encoder(__charset));
    }

    @Api
    private OutputStreamWriter(OutputStream __out, Encoder __encoder) throws NullPointerException {
        if (__out == null || __encoder == null) {
            throw new NullPointerException("NARG");
        }
        this._out = __out;
        this._encoder = __encoder;
        this._workBuf = new byte[__encoder.maximumSequenceLength()];
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Api
    public String getEncoding() {
        return this._encoder.encodingName();
    }

    @Override
    public void write(int __c) throws IOException {
        this.__write((char)__c);
    }

    @Override
    public void write(char[] __c, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __c.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        for (int i2 = 0; i2 < __l; ++i2) {
            this.__write(__c[__o + i2]);
        }
    }

    @Override
    public void write(String __str, int __off, int __len) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__str == null) {
            throw new NullPointerException("NARG");
        }
        if (__off < 0 || __len < 0 || __off + __len < 0 || __off + __len > __str.length()) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        for (int i2 = 0; i2 < __len; ++i2) {
            this.__write(__str.charAt(__off + i2));
        }
    }

    private void __write(char __c) throws IOException {
        byte[] workBuf = this._workBuf;
        int len = this._encoder.encode(__c, workBuf, 0, workBuf.length);
        if (len < 0) {
            throw Debugging.oops();
        }
        this._out.write(workBuf, 0, len);
    }
}

