/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.io.CodecFactory;
import cc.squirreljme.runtime.cldc.io.Encoder;
import cc.squirreljme.runtime.cldc.lang.LineEndingUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;

@Api
public class PrintStream
extends OutputStream
implements Appendable,
Closeable {
    private static final int _BUFFER_SIZE = 96;
    private static final int _EMERGENCY_HALT = 95;
    private static final int _MAX_ENCODE_BYTES = 8;
    private static final int _THRESHOLD = 88;
    private final OutputStream _out;
    private final boolean _autoflush;
    private final Encoder _encoder;
    private final byte[] _minienc = new byte[8];
    private final byte[] _buf = new byte[96];
    private int _bat;
    private boolean _inerror;

    @Api
    public PrintStream(OutputStream __out) throws NullPointerException {
        this(__out, false, CodecFactory.defaultEncoder());
    }

    @Api
    public PrintStream(OutputStream __out, boolean __autoflush) throws NullPointerException {
        this(__out, __autoflush, CodecFactory.defaultEncoder());
    }

    @Api
    public PrintStream(OutputStream __out, boolean __autoflush, String __enc) throws NullPointerException, UnsupportedEncodingException {
        this(__out, __autoflush, CodecFactory.encoder(__enc));
    }

    private PrintStream(OutputStream __out, boolean __autoflush, Encoder __enc) throws NullPointerException {
        if (__out == null || __enc == null) {
            throw new NullPointerException("NARG");
        }
        this._out = __out;
        this._autoflush = __autoflush;
        this._encoder = __enc;
    }

    @Override
    public PrintStream append(CharSequence __c) {
        this.print(__c == null ? "null" : __c.toString());
        return this;
    }

    @Override
    public PrintStream append(CharSequence __c, int __s, int __e) {
        this.print(__c == null ? "null" : __c.subSequence(__s, __e).toString());
        return this;
    }

    @Override
    public PrintStream append(char __c) {
        this.print(__c);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public boolean checkError() {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__flush();
            return this._inerror;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    protected void clearError() {
        PrintStream printStream = this;
        synchronized (printStream) {
            this._inerror = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Api
    public void close() {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__flush();
            try {
                this._out.close();
            }
            catch (IOException e2) {
                this._inerror = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Api
    public void flush() {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__flush();
        }
    }

    @Api
    public PrintStream format(String __fmt, Object ... __args) throws IllegalArgumentException, NullPointerException {
        return this.__printf(__fmt, __args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(boolean __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(__v ? "true" : "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(char __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__writeChar(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(int __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Integer.toString(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(long __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Long.toString(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(float __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Float.toString(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(double __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Double.toString(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(char[] __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        PrintStream printStream = this;
        synchronized (printStream) {
            int n2 = __v.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.__writeChar(__v[i2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(String __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void print(Object __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(__v == null ? "null" : __v.toString());
        }
    }

    @Api
    public PrintStream printf(String __fmt, Object ... __args) {
        return this.__printf(__fmt, __args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println() {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(boolean __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(__v ? "true" : "false");
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(char __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__writeChar(__v);
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(int __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Integer.toString(__v));
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(long __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Long.toString(__v));
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(float __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Float.toString(__v));
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(double __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(Double.toString(__v));
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(char[] __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        PrintStream printStream = this;
        synchronized (printStream) {
            int n2 = __v.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.__writeChar(__v[i2]);
            }
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(String __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(__v);
            this.__println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void println(Object __v) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__print(__v == null ? "null" : __v.toString());
            this.__println();
        }
    }

    @Api
    protected void setError() {
        this._inerror = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Api
    public void write(int __c) {
        byte[] b2 = new byte[]{(byte)__c};
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__writeBytes(b2, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Api
    public void write(byte[] __b) throws NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__writeBytes(__b, 0, __b.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Api
    public void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        PrintStream printStream = this;
        synchronized (printStream) {
            this.__writeBytes(__b, __o, __l);
        }
    }

    private void __flush() {
        int bop;
        int bat = this._bat;
        if (bat <= 0) {
            return;
        }
        OutputStream out = this._out;
        boolean oopsie = false;
        byte[] buf = this._buf;
        for (bop = 0; bop < bat; ++bop) {
            try {
                out.write(buf[bop]);
                continue;
            }
            catch (InterruptedIOException e2) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (IOException e3) {
                oopsie = true;
                break;
            }
        }
        if (oopsie) {
            int i2 = bop;
            int o2 = 0;
            while (i2 < bat) {
                buf[o2] = buf[i2];
                ++i2;
                ++o2;
            }
            this._bat = bat - bop;
            this._inerror = true;
        } else {
            this._bat = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __print(String __s) {
        PrintStream printStream = this;
        synchronized (printStream) {
            if (__s == null) {
                __s = "null";
            }
            int n2 = __s.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.__writeChar(__s.charAt(i2));
            }
        }
    }

    private PrintStream __printf(String __fmt, Object ... __args) throws IllegalArgumentException, NullPointerException {
        if (__fmt == null) {
            throw new NullPointerException("NARG");
        }
        new Formatter(this).format(__fmt, __args);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __println() {
        PrintStream printStream = this;
        synchronized (printStream) {
            char c2;
            int lineType = RuntimeShelf.lineEnding();
            int i2 = 0;
            while ((c2 = LineEndingUtils.toChar(lineType, i2)) != '\u0000') {
                this.__writeChar(c2);
                ++i2;
            }
            if (this._autoflush) {
                this.flush();
            }
        }
    }

    private void __writeBytes(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        byte[] buf = this._buf;
        int bat = this._bat;
        boolean autoflush = this._autoflush;
        boolean flush = false;
        for (int i2 = 0; i2 < __l; ++i2) {
            byte b2 = __b[__o + i2];
            if (bat < 95) {
                buf[bat++] = b2;
            }
            if (autoflush && b2 == 10) {
                flush = true;
            }
            if (bat < 88) continue;
            this._bat = bat;
            this.__flush();
            bat = this._bat;
            flush = false;
        }
        this._bat = bat;
        if (flush || bat >= 88) {
            this.__flush();
        }
    }

    private void __writeChar(char __c) {
        byte[] encBytes = this._minienc;
        int wc = this._encoder.encode(__c, encBytes, 0, encBytes.length);
        if (wc < 0 || wc > encBytes.length) {
            throw new Error("ZZ0q");
        }
        this.__writeBytes(encBytes, 0, wc);
    }
}

