/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import cc.squirreljme.jvm.mle.StringShelf;
import cc.squirreljme.jvm.mle.TypeShelf;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.i18n.DefaultLocale;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

@Api
public final class Character
implements Comparable<Character> {
    @Api
    public static final int MAX_RADIX = 36;
    @Api
    public static final char MAX_VALUE = '\uffff';
    @Api
    public static final int MIN_RADIX = 2;
    @Api
    public static final char MIN_VALUE = '\u0000';
    @Api
    public static final int SIZE = 16;
    @Api
    public static final Class<Character> TYPE = TypeShelf.typeOfCharacter();
    private static final char _MAX_CACHE = '\u0080';
    private static volatile Character[] _CACHE;
    private final char _value;
    private Reference<String> _string;

    @Api
    public Character(char __v) {
        this._value = __v;
    }

    @Api
    public char charValue() {
        return this._value;
    }

    @Override
    public int compareTo(Character __o) throws NullPointerException {
        char a2 = this._value;
        char b2 = __o._value;
        return a2 - b2;
    }

    public boolean equals(Object __o) {
        if (__o == this) {
            return true;
        }
        if (!(__o instanceof Character)) {
            return false;
        }
        return this._value == ((Character)__o)._value;
    }

    public int hashCode() {
        return this._value;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            char c2 = this._value;
            rv = StringShelf.stringValueOf(c2 < '\u0080', new char[]{c2}, 0, 1);
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    @Api
    public static int digit(char __c, int __r) {
        int rv;
        if (__r < 2 || __r > 36) {
            return -1;
        }
        if (__c >= 'a' && __c <= 'z') {
            rv = 10 + (__c - 97);
        } else if (__c >= 'A' && __c <= 'Z') {
            rv = 10 + (__c - 65);
        } else if (__c >= '0' && __c <= '9') {
            rv = __c - 48;
        } else {
            return -1;
        }
        if (rv >= __r) {
            return -1;
        }
        return rv;
    }

    @Api
    public static char forDigit(int __dig, int __r) {
        if (__dig < 0 || __dig >= __r || __r < 2 || __r > 36) {
            return '\u0000';
        }
        if (__dig < 10) {
            return (char)(48 + __dig);
        }
        return (char)(97 + (__dig - 10));
    }

    @Api
    public static boolean isDigit(char __c) {
        return __c >= '0' && __c <= '9';
    }

    @Api
    public static boolean isISOControl(char __c) {
        return __c >= '\u0000' && __c <= '\u001f' || __c >= '\u007f' && __c <= '\u009f';
    }

    @Api
    public static boolean isLowerCase(char __c) {
        return __c >= 'a' && __c <= 'z' || __c != '\u00f7' && __c >= '\u00df' && __c <= '\u00ff';
    }

    @Api
    public static boolean isSpaceChar(char __c) {
        return __c == '\t' || __c == '\n' || __c == '\f' || __c == '\r' || __c == ' ';
    }

    @Api
    public static boolean isUpperCase(char __c) {
        return __c >= 'A' && __c <= 'Z' || __c != '\u00d7' && __c >= '\u00c0' && __c <= '\u00de';
    }

    @Api
    public static boolean isWhitespace(char __c) {
        switch (__c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case '\u00a0': 
            case '\u2007': 
            case '\u202f': {
                return true;
            }
        }
        return false;
    }

    @Api
    public static char toLowerCase(char __c) {
        return DefaultLocale.noLocale().toLowerCase(__c);
    }

    @Api
    public static String toString(char __c) {
        return Character.valueOf(__c).toString();
    }

    @Api
    public static char toUpperCase(char __c) {
        return DefaultLocale.noLocale().toUpperCase(__c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Api
    public static Character valueOf(char __v) {
        Character result;
        if (__v >= '\u0080') return new Character(__v);
        Character[] cache = _CACHE;
        if (cache == null) {
            Class<Character> clazz = Character.class;
            // MONITORENTER : java.lang.Character.class
            cache = _CACHE;
            if (cache == null) {
                _CACHE = cache = new Character[128];
            }
            // MONITOREXIT : clazz
        }
        if ((result = cache[__v]) != null) {
            return result;
        }
        cache[__v] = result = new Character(__v);
        return result;
    }
}

