/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.TypeShelf;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

@Api
public final class Integer
extends Number
implements Comparable<Integer> {
    @Api
    public static final int MAX_VALUE = 0x7FFFFFFF;
    @Api
    public static final int MIN_VALUE = -2147483648;
    @Api
    public static final int SIZE = 32;
    @Api
    public static final Class<Integer> TYPE = TypeShelf.typeOfInteger();
    private final int _value;
    private Reference<String> _string;

    @Api
    public Integer(int __v) {
        this._value = __v;
    }

    @Api
    public Integer(String __v) throws NullPointerException, NumberFormatException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this._value = Integer.parseInt(__v, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this._value;
    }

    @Override
    public int compareTo(Integer __b) {
        int a2 = this._value;
        int b2 = __b;
        if (a2 == b2) {
            return 0;
        }
        if (a2 < b2) {
            return -1;
        }
        return 1;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof Integer)) {
            return false;
        }
        return this._value == ((Integer)__o)._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    public int hashCode() {
        return this._value;
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        return (short)this._value;
    }

    public String toString() {
        String rv;
        if (RuntimeShelf.memoryProfile() >= 0) {
            return Integer.toString(this._value, 10);
        }
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = Integer.toString(this._value);
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    @Api
    public static int bitCount(int __v) {
        __v -= __v >>> 1 & 0x55555555;
        __v = (__v & 0x33333333) + (__v >>> 2 & 0x33333333);
        return (__v + (__v >>> 4) & 0xF0F0F0F) * 0x1010101 >>> 24;
    }

    @Api
    public static Integer decode(String __s) throws NullPointerException, NumberFormatException {
        int radix;
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        if (__s.isEmpty()) {
            throw new NumberFormatException("ZZ16");
        }
        String orig = __s;
        char sign = __s.charAt(0);
        if (sign != '-' && sign != '+') {
            sign = '+';
        } else {
            __s = __s.substring(1);
        }
        if (__s.startsWith("0x") || __s.startsWith("0X")) {
            radix = 16;
            __s = __s.substring(2);
        } else if (__s.startsWith("#")) {
            radix = 16;
            __s = __s.substring(1);
        } else if (__s.startsWith("0")) {
            radix = 8;
            __s = __s.substring(1);
        } else {
            radix = 10;
        }
        if (__s.startsWith("-") || __s.startsWith("+")) {
            throw new NumberFormatException("ZZ2p " + orig);
        }
        try {
            return Integer.parseInt(sign + __s, radix);
        }
        catch (NumberFormatException e2) {
            NumberFormatException t2 = new NumberFormatException("ZZ18 " + orig);
            t2.initCause(e2);
            throw t2;
        }
    }

    @Api
    public static Integer getInteger(String __key) throws NumberFormatException, SecurityException {
        return Integer.getInteger(__key, null);
    }

    @Api
    public static Integer getInteger(String __key, int __def) throws NumberFormatException, SecurityException {
        Integer rv = Integer.getInteger(__key, null);
        if (rv == null) {
            return __def;
        }
        return rv;
    }

    @Api
    public static Integer getInteger(String __key, Integer __def) throws NumberFormatException, SecurityException {
        String prop = System.getProperty(__key);
        if (prop == null) {
            return __def;
        }
        return Integer.decode(prop);
    }

    @Api
    public static int highestOneBit(int __v) {
        __v |= __v >>> 1;
        __v |= __v >>> 2;
        __v |= __v >>> 4;
        __v |= __v >>> 8;
        __v |= __v >>> 16;
        return __v - (__v >>> 1);
    }

    @Api
    public static int lowestOneBit(int __v) {
        __v |= __v << 1;
        __v |= __v << 2;
        __v |= __v << 4;
        __v |= __v << 8;
        __v |= __v << 16;
        return __v - (__v << 1);
    }

    @Api
    public static int numberOfLeadingZeros(int __v) {
        __v |= __v >>> 1;
        __v |= __v >>> 2;
        __v |= __v >>> 4;
        __v |= __v >>> 8;
        __v |= __v >>> 16;
        return Integer.bitCount(~__v);
    }

    @Api
    public static int numberOfTrailingZeros(int __v) {
        int c2 = 32;
        if ((__v &= -__v) != 0) {
            --c2;
        }
        if ((__v & 0xFFFF) != 0) {
            c2 -= 16;
        }
        if ((__v & 0xFF00FF) != 0) {
            c2 -= 8;
        }
        if ((__v & 0xF0F0F0F) != 0) {
            c2 -= 4;
        }
        if ((__v & 0x33333333) != 0) {
            c2 -= 2;
        }
        if ((__v & 0x55555555) != 0) {
            --c2;
        }
        return c2;
    }

    @Api
    public static int parseInt(String __v, int __r) throws NumberFormatException {
        int i2;
        if (__r < 2 || __r > 36) {
            throw new NumberFormatException("ZZ19 " + __r);
        }
        if (__v == null) {
            throw new NumberFormatException("ZZ1a");
        }
        int n2 = __v.length();
        if (n2 <= 0) {
            throw new NumberFormatException("ZZ1a");
        }
        boolean signed = false;
        char c2 = __v.charAt(0);
        boolean neg = c2 == '-';
        if (neg || c2 == '+') {
            signed = true;
        }
        int rv = 0;
        int n3 = i2 = signed ? 1 : 0;
        while (i2 < n2) {
            c2 = __v.charAt(i2);
            int dig = Character.digit(c2, __r);
            if (dig < 0) {
                throw new NumberFormatException("ZZ1b " + __v + " " + c2);
            }
            int prod = rv * __r;
            if (rv != 0 && (neg ? prod > rv : prod < rv)) {
                throw new NumberFormatException("ZZ1c " + __v);
            }
            rv = neg ? prod - dig : prod + dig;
            ++i2;
        }
        return rv;
    }

    @Api
    public static int parseInt(String __v) throws NumberFormatException {
        return Integer.parseInt(__v, 10);
    }

    @Api
    public static int reverse(int __i) {
        __i = (__i & 0xAAAAAAAA) >>> 1 | (__i & 0x55555555) << 1;
        __i = (__i & 0xCCCCCCCC) >>> 2 | (__i & 0x33333333) << 2;
        __i = (__i & 0xF0F0F0F0) >>> 4 | (__i & 0xF0F0F0F) << 4;
        __i = (__i & 0xFF00FF00) >>> 8 | (__i & 0xFF00FF) << 8;
        return __i >>> 16 | __i << 16;
    }

    @Api
    public static int reverseBytes(int __i) {
        __i = (__i & 0xFF00FF00) >>> 8 | (__i & 0xFF00FF) << 8;
        return __i >>> 16 | __i << 16;
    }

    @Api
    public static int rotateLeft(int __i, int __d) {
        throw Debugging.todo();
    }

    @Api
    public static int rotateRight(int __i, int __d) {
        throw Debugging.todo();
    }

    @Api
    public static int signum(int __v) {
        if (__v < 0) {
            return -1;
        }
        if (__v > 1) {
            return 1;
        }
        return 0;
    }

    @Api
    public static String toBinaryString(int __a) {
        throw Debugging.todo();
    }

    @Api
    public static String toHexString(int __a) {
        throw Debugging.todo();
    }

    @Api
    public static String toOctalString(int __a) {
        throw Debugging.todo();
    }

    @Api
    public static String toString(int __v, int __r) {
        return Long.toString(__v, __r);
    }

    @Api
    public static String toString(int __v) {
        return Integer.toString(__v, 10);
    }

    @Api
    public static Integer valueOf(String __v, int __r) throws NumberFormatException {
        return Integer.parseInt(__v, __r);
    }

    @Api
    public static Integer valueOf(String __v) throws NumberFormatException {
        return Integer.parseInt(__v, 10);
    }

    @Api
    public static Integer valueOf(int __v) {
        return new Integer(__v);
    }
}

