/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import cc.squirreljme.jvm.mle.DebugShelf;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.brackets.TracePointBracket;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.CallTraceUtils;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.io.NonClosedOutputStream;
import cc.squirreljme.runtime.cldc.io.PipeOutputStream;
import java.io.PrintStream;
import org.jetbrains.annotations.Contract;

@Api
public class Runtime {
    private static final Runtime _INSTANCE = new Runtime();
    private static final long _GC_TIMEOUT = 60000000000L;
    private static volatile long _lastGc = Long.MIN_VALUE;

    private Runtime() {
    }

    @Api
    @Contract(value="_ -> fail")
    public void exit(int __v) throws SecurityException {
        System.getSecurityManager().checkExit(__v);
        try {
            Debugging.debugNote("Exiting VM with %d...", __v);
            if (__v != 0) {
                TracePointBracket[] trace = DebugShelf.traceStack();
                CallTraceUtils.printStackTrace((Appendable)new PrintStream(new NonClosedOutputStream(PipeOutputStream.stdErr())), "EXIT", trace, null, null, 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RuntimeShelf.exit(__v);
    }

    @Api
    public long freeMemory() {
        return RuntimeShelf.vmStatistic(1);
    }

    @Api
    public void gc() {
        long last = _lastGc;
        long now = System.nanoTime();
        if (now - last >= 60000000000L || last == Long.MIN_VALUE) {
            _lastGc = now;
            RuntimeShelf.garbageCollect();
        }
    }

    @Api
    public long maxMemory() {
        return RuntimeShelf.vmStatistic(2);
    }

    @Api
    public long totalMemory() {
        return RuntimeShelf.vmStatistic(3);
    }

    @Api
    public static Runtime getRuntime() {
        return _INSTANCE;
    }
}

