/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.jvm.mle.StringShelf;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.CharArrayCharSequence;
import cc.squirreljme.runtime.cldc.util.CharSequenceUtils;
import java.util.Arrays;

@Api
public final class StringBuilder
implements Appendable,
CharSequence {
    private static final int _DEFAULT_CAPACITY = 16;
    private char[] _buffer;
    private int _at;

    @Api
    public StringBuilder() {
        this(16);
    }

    @Api
    public StringBuilder(int __c) throws NegativeArraySizeException {
        if (__c < 0) {
            throw new NegativeArraySizeException(String.format("ZZ1n %d", __c));
        }
        this._buffer = new char[__c];
    }

    @Api
    public StringBuilder(String __s) throws NullPointerException {
        this((CharSequence)__s);
    }

    @Api
    public StringBuilder(CharSequence __cs) {
        if (__cs == null) {
            throw new NullPointerException("NARG");
        }
        this._buffer = new char[16 + __cs.length()];
        this.append(__cs);
    }

    @Api
    public StringBuilder append(Object __v) {
        return this.insert(this._at, __v);
    }

    @Api
    public StringBuilder append(String __v) {
        if (__v == null) {
            __v = "null";
        }
        return this.append(__v, 0, __v.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public StringBuilder append(StringBuffer __v) {
        if (__v == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer = __v;
        synchronized (stringBuffer) {
            return this.append(__v, 0, __v.length());
        }
    }

    @Override
    public StringBuilder append(CharSequence __v) {
        if (__v == null) {
            __v = "null";
        }
        return this.append(__v, 0, __v.length());
    }

    @Override
    public StringBuilder append(CharSequence __v, int __s, int __e) throws IndexOutOfBoundsException {
        char[] buffer;
        if (__v == null) {
            __v = "null";
        }
        int vn = __v.length();
        if (__s < 0 || __e < 0 || __e > vn || __s > __e) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int at2 = this._at;
        int len = __e - __s;
        int limit = this._buffer.length;
        char[] cArray = buffer = at2 + len > limit ? this.__buffer(len) : this._buffer;
        if (__v instanceof String) {
            StringShelf.stringToChar((String)__v, __s, buffer, at2, len);
            at2 += len;
        } else if (__v instanceof StringBuilder) {
            ObjectShelf.arrayCopy(((StringBuilder)__v)._buffer, __s, buffer, at2, len);
            at2 += len;
        } else {
            while (__s < __e) {
                buffer[at2++] = __v.charAt(__s++);
            }
        }
        this._at = at2;
        return this;
    }

    @Api
    public StringBuilder append(char[] __c) throws NullPointerException {
        return this.append(__c, 0, __c.length);
    }

    @Api
    public StringBuilder append(char[] __c, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        return this.insert(this._at, __c, __o, __l);
    }

    @Api
    public StringBuilder append(boolean __v) {
        return this.insert(this._at, __v);
    }

    @Override
    public StringBuilder append(char __v) {
        int at2 = this._at;
        int limit = this._buffer.length;
        char[] buffer = at2 + 1 > limit ? this.__buffer(1) : this._buffer;
        buffer[at2] = __v;
        this._at = at2 + 1;
        return this;
    }

    @Api
    public StringBuilder append(int __v) {
        return this.insert(this._at, __v);
    }

    @Api
    public StringBuilder append(long __v) {
        return this.insert(this._at, __v);
    }

    @Api
    public StringBuilder append(float __v) {
        return this.insert(this._at, __v);
    }

    @Api
    public StringBuilder append(double __v) {
        return this.insert(this._at, __v);
    }

    @Api
    public int capacity() {
        return this._buffer.length;
    }

    @Override
    public char charAt(int __dx) throws IndexOutOfBoundsException {
        if (__dx < 0 || __dx >= this._at) {
            throw new IndexOutOfBoundsException("ZZ1o " + __dx);
        }
        return this._buffer[__dx];
    }

    @Api
    public StringBuilder delete(int __fromInclusive, int __toExclusive) throws StringIndexOutOfBoundsException {
        int at2 = this._at;
        if (__fromInclusive < 0 || __fromInclusive > __toExclusive || __fromInclusive > at2) {
            throw new StringIndexOutOfBoundsException("IOOB");
        }
        int realEnd = Math.min(at2, __toExclusive);
        int deleteLen = realEnd - __fromInclusive;
        if (__fromInclusive == __toExclusive || deleteLen == 0) {
            return this;
        }
        char[] buffer = this._buffer;
        ObjectShelf.arrayCopy(buffer, realEnd, buffer, __fromInclusive, at2 - deleteLen);
        ObjectShelf.arrayFill(buffer, at2 -= deleteLen, buffer.length - at2, '\u0000');
        this._at = at2;
        return this;
    }

    @Api
    public StringBuilder deleteCharAt(int __dx) throws StringIndexOutOfBoundsException {
        if (__dx < 0 || __dx >= this._at) {
            throw new StringIndexOutOfBoundsException("IOOB");
        }
        this.delete(__dx, __dx + 1);
        return this;
    }

    @Api
    public void ensureCapacity(int __minCapacity) {
        if (__minCapacity <= 0) {
            return;
        }
        int limit = this._buffer.length;
        if (limit < __minCapacity) {
            this.__buffer(Math.max(__minCapacity, (limit << 1) + 2));
        }
    }

    @Api
    public void getChars(int __a, int __b, char[] __c, int __d) {
        throw Debugging.todo();
    }

    @Api
    public int indexOf(String __s) throws NullPointerException {
        return this.indexOf(__s, 0);
    }

    @Api
    public int indexOf(String __s, int __index) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        return CharSequenceUtils.indexOf((CharSequence)this, __s, __index);
    }

    @Api
    public StringBuilder insert(int __dx, char[] __c, int __o, int __l) {
        return this.insert(__dx, new CharArrayCharSequence(__c, __o, __l));
    }

    @Api
    public StringBuilder insert(int __dx, Object __v) {
        return this.insert(__dx, __v == null ? "null" : __v.toString());
    }

    @Api
    public StringBuilder insert(int __dx, String __v) throws StringIndexOutOfBoundsException {
        return this.insert(__dx, (CharSequence)__v);
    }

    @Api
    public StringBuilder insert(int __dx, char[] __chars) throws StringIndexOutOfBoundsException, NullPointerException {
        if (__chars == null) {
            throw new NullPointerException("NARG");
        }
        return this.insert(__dx, new CharArrayCharSequence(__chars));
    }

    @Api
    public StringBuilder insert(int __dx, CharSequence __v) throws IndexOutOfBoundsException {
        if (__v == null) {
            __v = "null";
        }
        return this.insert(__dx, __v, 0, __v.length());
    }

    @Api
    public StringBuilder insert(int __dx, CharSequence __v, int __s, int __e) throws IndexOutOfBoundsException {
        char[] buffer;
        if (__dx < 0) {
            throw new IndexOutOfBoundsException("ZZ1p");
        }
        int vn = __v.length();
        if (__s < 0 || __e < 0 || __e > vn || __s > __e) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int at2 = this._at;
        int len = __e - __s;
        int limit = this._buffer.length;
        char[] cArray = buffer = at2 + len > limit ? this.__buffer(len) : this._buffer;
        if (__dx > at2) {
            throw new IndexOutOfBoundsException(String.format("ZZ1q %d %d", __dx, at2));
        }
        ObjectShelf.arrayCopy(buffer, __dx, buffer, __dx + len, at2 - __dx);
        if (__v instanceof String) {
            StringShelf.stringToChar((String)__v, __s, buffer, __dx, len);
        } else if (__v instanceof StringBuilder) {
            ObjectShelf.arrayCopy(((StringBuilder)__v)._buffer, __s, buffer, __dx, len);
        } else {
            while (__s < __e) {
                buffer[__dx++] = __v.charAt(__s++);
            }
        }
        this._at = at2 + len;
        return this;
    }

    @Api
    public StringBuilder insert(int __dx, boolean __v) {
        return this.insert(__dx, Boolean.valueOf(__v).toString());
    }

    @Api
    public StringBuilder insert(int __dx, char __v) throws IndexOutOfBoundsException {
        char[] buffer;
        if (__dx < 0) {
            throw new IndexOutOfBoundsException("ZZ1r");
        }
        int at2 = this._at;
        int limit = this._buffer.length;
        char[] cArray = buffer = at2 + 1 > limit ? this.__buffer(1) : this._buffer;
        if (__dx > at2) {
            throw new IndexOutOfBoundsException(String.format("ZZ1s %d %d", __dx, at2));
        }
        ObjectShelf.arrayCopy(buffer, __dx, buffer, __dx + 1, at2 - __dx);
        buffer[__dx] = __v;
        this._at = at2 + 1;
        return this;
    }

    @Api
    public StringBuilder insert(int __dx, int __v) {
        return this.insert(__dx, Long.valueOf(__v).toString());
    }

    @Api
    public StringBuilder insert(int __dx, long __v) {
        return this.insert(__dx, Long.valueOf(__v).toString());
    }

    @Api
    public StringBuilder insert(int __dx, float __v) {
        return this.insert(__dx, Float.valueOf(__v).toString());
    }

    @Api
    public StringBuilder insert(int __dx, double __v) {
        return this.insert(__dx, Double.valueOf(__v).toString());
    }

    @Api
    public int lastIndexOf(String __s) {
        return this.lastIndexOf(__s, Integer.MAX_VALUE);
    }

    @Api
    public int lastIndexOf(String __s, int __fromDx) {
        throw Debugging.todo();
    }

    @Override
    public int length() {
        return this._at;
    }

    @Api
    public StringBuilder replace(int __a, int __b, String __c) {
        throw Debugging.todo();
    }

    @Api
    public StringBuilder reverse() {
        char[] buffer = this._buffer;
        int at2 = this._at;
        int a2 = 0;
        for (int b2 = at2 - 1; a2 < b2; ++a2, --b2) {
            char x2 = buffer[a2];
            buffer[a2] = buffer[b2];
            buffer[b2] = x2;
        }
        return this;
    }

    @Api
    public void setCharAt(int __dx, char __c) throws IndexOutOfBoundsException {
        int at2 = this._at;
        if (__dx < 0 || __dx >= at2) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        this._buffer[__dx] = __c;
    }

    @Api
    public void setLength(int __nl) throws IndexOutOfBoundsException {
        if (__nl < 0) {
            throw new IndexOutOfBoundsException("ZZ1t");
        }
        int at2 = this._at;
        if (__nl > at2) {
            this.__buffer(__nl);
        }
        this._at = __nl;
        char[] buffer = this._buffer;
        ObjectShelf.arrayFill(buffer, __nl, buffer.length - __nl, '\u0000');
    }

    @Override
    public CharSequence subSequence(int __s, int __e) throws IndexOutOfBoundsException {
        return this.substring(__s, __e);
    }

    @Api
    public String substring(int __s) throws StringIndexOutOfBoundsException {
        return this.substring(__s, this.length());
    }

    @Api
    public String substring(int __s, int __e) throws StringIndexOutOfBoundsException {
        int len = this._at;
        if (__s < 0 || __e < 0 || __s > __e || __s > len || __e > len) {
            throw new StringIndexOutOfBoundsException("ZZ1u");
        }
        if (__s == __e) {
            return "";
        }
        return new String(this._buffer, __s, __e - __s);
    }

    @Override
    public String toString() {
        return new String(this._buffer, 0, this._at);
    }

    @Api
    public void trimToSize() {
        char[] buffer = this._buffer;
        int limit = buffer.length;
        int at2 = this._at;
        if (limit > at2) {
            this._buffer = Arrays.copyOf(buffer, at2);
        }
    }

    @Api
    private char[] __buffer(int __l) {
        int at2 = this._at;
        int nextAt = at2 + __l;
        char[] buffer = this._buffer;
        int limit = buffer.length;
        if (nextAt > limit) {
            int newCapacity = nextAt + 16;
            char[] extra = Arrays.copyOf(buffer, newCapacity);
            ObjectShelf.arrayFill(buffer, 0, buffer.length, '\u0000');
            buffer = extra;
            this._buffer = extra;
        }
        return buffer;
    }
}

