/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import cc.squirreljme.jvm.mle.JarPackageShelf;
import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.TypeShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.runtime.cldc.SquirrelJME;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.i18n.DefaultLocale;
import cc.squirreljme.runtime.cldc.io.CodecFactory;
import cc.squirreljme.runtime.cldc.io.PipeOutputStream;
import cc.squirreljme.runtime.cldc.lang.LineEndingUtils;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@Api
public final class System {
    @Api
    public static final PrintStream err = new __CanSetPrintStream__(new PrintStream(PipeOutputStream.stdErr(), true));
    @Api
    public static final PrintStream out = new __CanSetPrintStream__(new PrintStream(PipeOutputStream.stdOut(), true));

    private System() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Api
    public static void arraycopy(@Flow(sourceIsContainer=true, target="__dest", targetIsContainer=true) @NotNull Object __src, @Range(from=0L, to=0x7FFFFFFFL) int __srcOff, @NotNull Object __dest, @Range(from=0L, to=0x7FFFFFFFL) int __destOff, @Range(from=0L, to=0x7FFFFFFFL) int __copyLen) throws ArrayStoreException, IndexOutOfBoundsException, NullPointerException {
        Class<?> destClass;
        if (__src == null || __dest == null) {
            throw new NullPointerException("NARG");
        }
        if (__srcOff < 0 || __destOff < 0 || __copyLen < 0) {
            throw new IndexOutOfBoundsException(String.format("ZZ1w %d %d %d", __srcOff, __destOff, __copyLen));
        }
        int srcLen = ObjectShelf.arrayLength(__src);
        int destLen = ObjectShelf.arrayLength(__dest);
        if (__srcOff + __copyLen < 0 || __srcOff + __copyLen > srcLen || __destOff + __copyLen < 0 || __destOff + __copyLen > destLen) {
            throw new IndexOutOfBoundsException(String.format("ZZ1x %d %d %d %d %d", __srcOff, srcLen, __destOff, destLen, __copyLen));
        }
        Class<?> srcClass = __src.getClass();
        if (srcClass != (destClass = __dest.getClass()) && !destClass.isAssignableFrom(srcClass)) {
            throw new ArrayStoreException(String.format("ZZ1y %s %s", __src, __dest));
        }
        if (__copyLen == 0) {
            return;
        }
        if (__src == __dest && __srcOff == __destOff) {
            return;
        }
        if (TypeShelf.isPrimitive(TypeShelf.component(srcClass))) {
            if (srcClass == byte[].class) {
                ObjectShelf.arrayCopy((byte[])__src, __srcOff, (byte[])__dest, __destOff, __copyLen);
                return;
            } else if (srcClass == char[].class) {
                ObjectShelf.arrayCopy((char[])__src, __srcOff, (char[])__dest, __destOff, __copyLen);
                return;
            } else if (srcClass == int[].class) {
                ObjectShelf.arrayCopy((int[])__src, __srcOff, (int[])__dest, __destOff, __copyLen);
                return;
            } else if (srcClass == short[].class) {
                ObjectShelf.arrayCopy((short[])__src, __srcOff, (short[])__dest, __destOff, __copyLen);
                return;
            } else if (srcClass == boolean[].class) {
                ObjectShelf.arrayCopy((boolean[])__src, __srcOff, (boolean[])__dest, __destOff, __copyLen);
                return;
            } else if (srcClass == long[].class) {
                ObjectShelf.arrayCopy((long[])__src, __srcOff, (long[])__dest, __destOff, __copyLen);
                return;
            } else if (srcClass == float[].class) {
                ObjectShelf.arrayCopy((float[])__src, __srcOff, (float[])__dest, __destOff, __copyLen);
                return;
            } else {
                if (srcClass != double[].class) throw Debugging.oops("ZZ1h");
                ObjectShelf.arrayCopy((double[])__src, __srcOff, (double[])__dest, __destOff, __copyLen);
            }
            return;
        } else {
            Object[] src = (Object[])__src;
            Object[] dest = (Object[])__dest;
            if (__destOff > __srcOff) {
                int i2 = __srcOff + __copyLen - 1;
                int o2 = __destOff + __copyLen - 1;
                while (i2 >= __srcOff) {
                    dest[o2] = src[i2];
                    --i2;
                    --o2;
                }
                return;
            } else {
                int end = __srcOff + __copyLen;
                while (__srcOff < end) {
                    dest[__destOff] = src[__srcOff];
                    ++__srcOff;
                    ++__destOff;
                }
            }
        }
    }

    @Api
    public static long currentTimeMillis() {
        return RuntimeShelf.currentTimeMillis();
    }

    @Api
    @Contract(value="_ -> fail")
    public static void exit(int __e) {
        Runtime.getRuntime().exit(__e);
    }

    @Api
    public static void gc() {
        Runtime.getRuntime().gc();
    }

    @Api
    public static String getProperty(String __k) throws IllegalArgumentException, NullPointerException, SecurityException {
        if (__k == null) {
            throw new NullPointerException("NARG");
        }
        if (__k.isEmpty()) {
            throw new IllegalArgumentException("ZZ1z");
        }
        System.getSecurityManager().checkPropertyAccess(__k);
        switch (__k) {
            case "cc.squirreljme.vm.execpath": {
                return RuntimeShelf.vmDescription(6);
            }
            case "cc.squirreljme.vm.freemem": {
                return Long.toString(Runtime.getRuntime().freeMemory());
            }
            case "cc.squirreljme.vm.totalmem": {
                return Long.toString(Runtime.getRuntime().totalMemory());
            }
            case "cc.squirreljme.vm.maxmem": {
                return Long.toString(Runtime.getRuntime().maxMemory());
            }
            case "file.separator": {
                return RuntimeShelf.vmDescription(13);
            }
            case "java.class.path": {
                return System.__classPath();
            }
            case "java.version": {
                return "1.8.0";
            }
            case "java.vm.info": {
                return RuntimeShelf.vmDescription(14);
            }
            case "java.vm.version": {
                return RuntimeShelf.vmDescription(1);
            }
            case "java.vm.name": {
                return RuntimeShelf.vmDescription(2);
            }
            case "java.vm.vendor": {
                return RuntimeShelf.vmDescription(3);
            }
            case "java.vm.vendor.email": {
                return RuntimeShelf.vmDescription(4);
            }
            case "java.vm.vendor.url": {
                return RuntimeShelf.vmDescription(5);
            }
            case "java.vendor": {
                return "Stephanie Gawroriski";
            }
            case "java.vendor.email": {
                return "xerthesquirrel@gmail.com";
            }
            case "java.vendor.url": {
                return "http://squirreljme.cc/";
            }
            case "java.runtime.name": {
                return "SquirrelJME";
            }
            case "java.runtime.version": {
                return "0.3.0";
            }
            case "line.separator": {
                return LineEndingUtils.toString(RuntimeShelf.lineEnding());
            }
            case "microedition.configuration": {
                try {
                    Class<?> file = Class.forName("java.nio.FileSystem");
                    if (file == null) {
                        return "CLDC-1.8-Compact";
                    }
                    return "CLDC-1.8";
                }
                catch (ClassNotFoundException e2) {
                    return "CLDC-1.8-Compact";
                }
            }
            case "microedition.encoding": {
                return System.__encoding();
            }
            case "microedition.locale": {
                return System.__locale();
            }
            case "microedition.platform": {
                String platformOverride = RuntimeShelf.systemProperty(__k);
                if (platformOverride != null) {
                    return platformOverride;
                }
                int phoneModel = RuntimeShelf.phoneModel();
                if (phoneModel != 0) {
                    return SquirrelJME.platform(phoneModel);
                }
                return "SquirrelJME/0.3.0";
            }
            case "os.arch": {
                return RuntimeShelf.vmDescription(9);
            }
            case "os.name": {
                return RuntimeShelf.vmDescription(7);
            }
            case "os.version": {
                return RuntimeShelf.vmDescription(8);
            }
            case "jscl.system.mannermode": 
            case "jscl.system.offlinemode": 
            case "jscl.system.javasetting.volume": 
            case "jscl.system.javasetting.vibration": 
            case "jscl.system.wakeupmode": 
            case "jscl.system.display.colordepth": 
            case "jscl.supports.subdisplay": 
            case "jscl.supports.subdisplay.dualdraw": 
            case "jscl.supports.external_storage": 
            case "jscl.supports.barcode": 
            case "jscl.supports.irda": 
            case "jscl.supports.remote_control": 
            case "jscl.supports.voice_recognition": {
                throw Debugging.todo(__k);
            }
        }
        return RuntimeShelf.systemProperty(__k);
    }

    @Api
    public static String getProperty(String __k, String __d) throws IllegalArgumentException, NullPointerException, SecurityException {
        String rv = System.getProperty(__k);
        if (rv == null) {
            return __d;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public static SecurityManager getSecurityManager() {
        Class<SecurityManager> clazz = SecurityManager.class;
        synchronized (SecurityManager.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return SecurityManager._CURRENT_MANAGER;
        }
    }

    @Api
    public static int identityHashCode(Object __o) {
        if (__o == null) {
            return 0;
        }
        return ObjectShelf.identityHashCode(__o);
    }

    @Api
    public static long nanoTime() {
        return RuntimeShelf.nanoTime();
    }

    @Api
    public static void setErr(PrintStream __a) throws NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        System.getSecurityManager().checkPermission(new RuntimePermission("setIO"));
        ((__CanSetPrintStream__)err).__set(__a);
    }

    @Api
    public static void setOut(PrintStream __a) throws NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        System.getSecurityManager().checkPermission(new RuntimePermission("setIO"));
        ((__CanSetPrintStream__)out).__set(__a);
    }

    private static String __classPath() {
        String sep = Objects.toString(RuntimeShelf.vmDescription(13), ":");
        StringBuilder sb = new StringBuilder();
        for (JarPackageBracket jar : JarPackageShelf.classPath()) {
            String path;
            if (sb.length() > 0) {
                sb.append(sep);
            }
            if ((path = JarPackageShelf.libraryPath(jar)) != null) {
                sb.append(path);
                continue;
            }
            sb.append(JarPackageShelf.libraryId(jar));
        }
        return sb.toString();
    }

    private static final String __encoding() {
        String override = RuntimeShelf.systemProperty("cc.squirreljme.override.encoding");
        if (override != null) {
            try {
                return CodecFactory.toString(CodecFactory.toBuiltIn(override));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return CodecFactory.toString(RuntimeShelf.encoding());
    }

    private static final String __locale() {
        String override = RuntimeShelf.systemProperty("cc.squirreljme.override.locale");
        if (override != null) {
            try {
                return DefaultLocale.toString(DefaultLocale.toBuiltIn(override));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return DefaultLocale.toString(RuntimeShelf.locale());
    }
}

