/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.jvm.mle.ThreadShelf;
import cc.squirreljme.jvm.mle.brackets.VMThreadBracket;
import cc.squirreljme.runtime.cldc.annotation.Api;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Range;

@Api
public class Thread
implements Runnable {
    @Api
    public static final int MAX_PRIORITY = 10;
    @Api
    public static final int MIN_PRIORITY = 1;
    @Api
    public static final int NORM_PRIORITY = 5;
    private static final long _NS_SECOND = 1000000L;
    private final Runnable _runnable;
    private final VMThreadBracket _vmThread;
    private volatile String _name;
    private volatile int _priority = 5;
    volatile boolean _interrupted;

    @Api
    public Thread() {
        this(null, false, null);
    }

    @Api
    public Thread(Runnable __r) {
        this(__r, false, null);
    }

    @Api
    public Thread(String __n) throws NullPointerException {
        this(null, true, __n);
    }

    @Api
    public Thread(Runnable __r, String __n) throws NullPointerException {
        this(__r, true, __n);
    }

    @Api
    private Thread(Runnable __runnable, boolean __hasName, String __name) {
        VMThreadBracket vmThread;
        if (__hasName && __name == null) {
            throw new NullPointerException("NARG");
        }
        this._vmThread = vmThread = ThreadShelf.createVMThread(this, __name);
        this._runnable = __runnable;
        this._name = Thread.__defaultName(__name, vmThread);
    }

    @Api
    public final void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkAccess(this);
        }
    }

    @Api
    public long getId() {
        return ThreadShelf.vmThreadId(this._vmThread);
    }

    @Api
    public final String getName() {
        return this._name;
    }

    @Api
    public final int getPriority() {
        return this._priority;
    }

    @Api
    public void interrupt() throws SecurityException {
        if (ThreadShelf.currentJavaThread() != this) {
            this.checkAccess();
        }
        this._interrupted = true;
        ThreadShelf.vmThreadInterrupt(this._vmThread);
    }

    @Api
    public final boolean isAlive() {
        return ThreadShelf.vmThreadIsAlive(this._vmThread);
    }

    @Api
    public boolean isInterrupted() {
        return this._interrupted;
    }

    @Api
    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    @Api
    public final void join(long __ms) throws IllegalArgumentException, InterruptedException {
        this.join(__ms, 0);
    }

    @Api
    public final void join(long __ms, int __ns) throws IllegalArgumentException, InterruptedException {
        long end = __ms == 0L && __ns == 0 ? Long.MAX_VALUE : System.nanoTime() + __ms * 1000000L + (long)__ns;
        Thread thread = this;
        synchronized (thread) {
            while (true) {
                long now;
                if ((now = System.nanoTime()) >= end) {
                    return;
                }
                if (ThreadShelf.vmThreadIsStarted(this._vmThread) && !this.isAlive()) {
                    return;
                }
                long diff = end - now;
                this.wait(diff / 1000000L, (int)(diff % 1000000L));
            }
        }
    }

    @Override
    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public final void setName(String __n) throws NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        this.checkAccess();
        Thread thread = this;
        synchronized (thread) {
            this._name = __n;
        }
    }

    @Api
    public final void setPriority(int __p) throws IllegalArgumentException, SecurityException {
        if (__p < 1 || __p > 10) {
            throw new IllegalArgumentException("ZZ20");
        }
        this.checkAccess();
        this._priority = __p;
        ThreadShelf.vmThreadSetPriority(this._vmThread, __p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void start() throws IllegalThreadStateException {
        Thread thread = this;
        synchronized (thread) {
            if (ThreadShelf.vmThreadIsStarted(this._vmThread)) {
                throw new IllegalThreadStateException("ZZ21");
            }
            if (!ThreadShelf.vmThreadStart(this._vmThread)) {
                throw new IllegalThreadStateException("ZZ22");
            }
        }
    }

    public String toString() {
        return "Thread[" + this._name + "," + this._priority + "]";
    }

    @Api
    public static int activeCount() {
        return ThreadShelf.aliveThreadCount(true, true);
    }

    @Api
    public static Thread currentThread() {
        return ThreadShelf.currentJavaThread();
    }

    @Api
    public static boolean holdsLock(Object __o) throws NullPointerException {
        if (__o == null) {
            throw new NullPointerException("NARG");
        }
        return ObjectShelf.holdsLock(ThreadShelf.currentJavaThread(), __o);
    }

    @Api
    public static boolean interrupted() {
        return ThreadShelf.javaThreadClearInterrupt(Thread.currentThread());
    }

    @Api
    @Blocking
    public static void sleep(@Range(from=0L, to=0x7FFFFFFFL) long __ms) throws InterruptedException {
        Thread.sleep(__ms, 0);
    }

    @Api
    @Blocking
    public static void sleep(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long __ms, @Range(from=0L, to=999999L) int __ns) throws IllegalArgumentException, InterruptedException {
        int ims;
        if (__ms < 0L || __ns < 0 || __ns > 999999) {
            throw new IllegalArgumentException("ZZ23");
        }
        int n2 = ims = __ms > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)__ms;
        if (ThreadShelf.sleep(ims, __ns)) {
            ThreadShelf.javaThreadClearInterrupt(Thread.currentThread());
            throw new InterruptedException("ZZ24");
        }
    }

    @Api
    @Blocking
    public static void yield() {
        try {
            Thread.sleep(0L, 0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String __defaultName(String __name, VMThreadBracket __vm) throws NullPointerException {
        if (__vm == null) {
            throw new NullPointerException("NARG");
        }
        if (__name != null) {
            return __name;
        }
        return "Thread-" + ThreadShelf.vmThreadId(__vm);
    }
}

