/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import cc.squirreljme.runtime.cldc.annotation.Api;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

@Api
public abstract class AbstractCollection<E>
implements Collection<E> {
    @Api
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean add(E __a) {
        throw new UnsupportedOperationException("RORO");
    }

    @Override
    public boolean addAll(Collection<? extends E> __c) throws NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        boolean changed = false;
        for (E e2 : __c) {
            changed |= this.add(e2);
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public boolean contains(Object __v) {
        for (E e2 : this) {
            if (!Objects.equals(__v, e2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> __c) throws NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        int total = 0;
        int found = 0;
        for (Object e2 : __c) {
            ++total;
            if (this.contains(e2)) {
                ++found;
                continue;
            }
            return false;
        }
        return found == total;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object __v) {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e2 = it.next();
            if (!Objects.equals(__v, e2)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> __c) throws NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        boolean did = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e2 = it.next();
            if (!__c.contains(e2)) continue;
            it.remove();
            did = true;
        }
        return did;
    }

    @Override
    public boolean retainAll(Collection<?> __c) {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        boolean did = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e2 = it.next();
            if (__c.contains(e2)) continue;
            it.remove();
            did = true;
        }
        return did;
    }

    @Override
    public Object[] toArray() {
        int n2 = this.size();
        Object[] rv = new Object[n2];
        int i2 = 0;
        for (E __e : this) {
            rv[i2++] = __e;
        }
        return rv;
    }

    @Override
    public <T> T[] toArray(T[] __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int size = this.size();
        if (size > 0) {
            if (__v.length < size) {
                __v = Arrays.copyOf(__v, size);
            }
            int o2 = 0;
            for (E e2 : this) {
                __v[o2++] = e2;
            }
        }
        if (__v.length > size) {
            __v[size] = null;
        }
        return __v;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean comma = false;
        for (E __e : this) {
            if (comma) {
                sb.append(", ");
            }
            comma = true;
            sb.append(__e);
        }
        sb.append("]");
        return sb.toString();
    }
}

