/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import cc.squirreljme.runtime.cldc.annotation.Api;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.__DescendingIteratorViaListIterator__;
import java.util.__HideIterator__;

@Api
public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable {
    private static final int _DEFAULT_CAPACITY = 16;
    private final ArrayList<E> _elements;

    @Api
    public ArrayDeque() {
        this(16);
    }

    @Api
    public ArrayDeque(int __initialCap) throws IllegalArgumentException {
        if (__initialCap < 0) {
            throw new IllegalArgumentException("ZZxx " + __initialCap);
        }
        this._elements = new ArrayList(__initialCap);
    }

    @Api
    public ArrayDeque(Collection<? extends E> __c) throws NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        int size = __c.size();
        ArrayList<E> elements = new ArrayList<E>(size);
        for (E element : __c) {
            if (element == null) {
                throw new NullPointerException("NARG");
            }
            elements.add(element);
        }
        this._elements = elements;
    }

    @Override
    public boolean add(E __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.__elementAdd(true, __v);
        return true;
    }

    @Override
    public void addFirst(E __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.__elementAdd(false, __v);
    }

    @Override
    public void addLast(E __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.__elementAdd(true, __v);
    }

    @Override
    public void clear() {
        this._elements.clear();
    }

    public ArrayDeque<E> clone() {
        return new ArrayDeque<E>(this);
    }

    @Override
    public boolean contains(Object __v) {
        return this._elements.contains(__v);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.__iterator(true);
    }

    @Override
    public E element() throws NoSuchElementException {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException("NSEE");
        }
        return this.__elementGet(false, false);
    }

    @Override
    public E getFirst() throws NoSuchElementException {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException("NSEE");
        }
        return this.__elementGet(false, false);
    }

    @Override
    public E getLast() throws NoSuchElementException {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException("NSEE");
        }
        return this.__elementGet(true, false);
    }

    @Override
    public Iterator<E> iterator() {
        return this.__iterator(false);
    }

    @Override
    public boolean offer(E __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.__elementAdd(true, __v);
        return true;
    }

    @Override
    public boolean offerFirst(E __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.__elementAdd(false, __v);
        return true;
    }

    @Override
    public boolean offerLast(E __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.__elementAdd(true, __v);
        return true;
    }

    @Override
    public E peek() {
        if (this._elements.isEmpty()) {
            return null;
        }
        return this.__elementGet(false, false);
    }

    @Override
    public E peekFirst() {
        if (this._elements.isEmpty()) {
            return null;
        }
        return this.__elementGet(false, false);
    }

    @Override
    public E peekLast() {
        if (this._elements.isEmpty()) {
            return null;
        }
        return this.__elementGet(true, false);
    }

    @Override
    public E poll() {
        if (this._elements.isEmpty()) {
            return null;
        }
        return this.__elementGet(false, true);
    }

    @Override
    public E pollFirst() {
        if (this._elements.isEmpty()) {
            return null;
        }
        return this.__elementGet(false, true);
    }

    @Override
    public E pollLast() {
        if (this._elements.isEmpty()) {
            return null;
        }
        return this.__elementGet(true, true);
    }

    @Override
    public E pop() throws NoSuchElementException {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException("NSEE");
        }
        return this.__elementGet(false, true);
    }

    @Override
    public void push(E __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.__elementAdd(false, __v);
    }

    @Override
    public E remove() throws NoSuchElementException {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException("NSEE");
        }
        return this.__elementGet(false, true);
    }

    @Override
    public E removeFirst() throws NoSuchElementException {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException("NSEE");
        }
        return this.__elementGet(false, true);
    }

    @Override
    public boolean removeFirstOccurrence(Object __v) {
        if (__v == null) {
            return false;
        }
        return this.__removeFirst(this.__iterator(false), __v);
    }

    @Override
    public E removeLast() throws NoSuchElementException {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException("NSEE");
        }
        return this.__elementGet(true, true);
    }

    @Override
    public boolean removeLastOccurrence(Object __v) {
        if (__v == null) {
            return false;
        }
        return this.__removeFirst(this.__iterator(true), __v);
    }

    @Override
    public int size() {
        return this._elements.size();
    }

    private void __elementAdd(boolean __rightSide, E __value) throws NullPointerException {
        if (__value == null) {
            throw new NullPointerException("NARG");
        }
        ArrayList<E> elements = this._elements;
        if (__rightSide) {
            elements.add(__value);
        } else {
            elements.add(0, __value);
        }
    }

    private E __elementGet(boolean __rightSide, boolean __delete) {
        ArrayList<E> elements = this._elements;
        int size = elements.size();
        if (size <= 0) {
            throw new IllegalStateException("ZZ37");
        }
        if (__rightSide) {
            if (__delete) {
                return elements.remove(size - 1);
            }
            return elements.get(size - 1);
        }
        if (__delete) {
            return elements.remove(0);
        }
        return elements.get(0);
    }

    private Iterator<E> __iterator(boolean __descending) {
        ArrayList<E> elements = this._elements;
        if (__descending) {
            return new __DescendingIteratorViaListIterator__(elements.listIterator(elements.size()));
        }
        return new __HideIterator__(elements.iterator());
    }

    private boolean __removeFirst(Iterator<E> __iterator, Object __v) throws NullPointerException {
        if (__iterator == null) {
            throw new NullPointerException("NARG");
        }
        while (__iterator.hasNext()) {
            E element = __iterator.next();
            if (!Objects.equals(element, __v)) continue;
            __iterator.remove();
            return true;
        }
        return false;
    }
}

