/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

@Api
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable {
    private static final int _GROWTH = 8;
    private E[] _elements;
    private int _size;

    @Api
    public ArrayList() {
        this(10);
    }

    public ArrayList(int __cap) throws IllegalArgumentException {
        if (__cap < 0) {
            throw new IllegalArgumentException(String.format("ZZ2e %d", __cap));
        }
        this._elements = new Object[__cap];
    }

    public ArrayList(Collection<? extends E> __o) throws NullPointerException {
        if (__o == null) {
            throw new NullPointerException("NARG");
        }
        this._elements = new Object[__o.size()];
        this.addAll(__o);
    }

    @Override
    public void add(int __i, E __v) throws IndexOutOfBoundsException {
        boolean resize;
        int size = this._size;
        if (__i < 0 || __i > size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        Object[] elements = this._elements;
        int cap = elements.length;
        int nextsize = size + 1;
        E[] source = elements;
        boolean bl2 = resize = nextsize > cap;
        if (resize) {
            int newcap = nextsize + 8;
            elements = new Object[newcap];
            System.arraycopy(source, 0, elements, 0, __i);
        }
        int i2 = size - 1;
        for (int o2 = size; o2 > __i; --o2) {
            elements[o2] = source[i2];
            --i2;
        }
        elements[__i] = __v;
        this._size = nextsize;
        if (elements != source) {
            this._elements = elements;
        }
        if (nextsize > cap) {
            int n2 = source.length;
            for (i2 = 0; i2 < n2; ++i2) {
                source[i2] = null;
            }
        }
        ++this.modCount;
    }

    @Override
    public void clear() {
        E[] elements = this._elements;
        int size = this._size;
        for (int i2 = 0; i2 < size; ++i2) {
            elements[i2] = null;
        }
        this._size = 0;
        ++this.modCount;
    }

    public Object clone() {
        return new ArrayList<E>(this);
    }

    @Api
    public void ensureCapacity(int __n) {
        if (__n <= 0) {
            return;
        }
        E[] elements = this._elements;
        int nowl = elements.length;
        if (__n <= nowl) {
            return;
        }
        Object[] extra = new Object[__n];
        System.arraycopy(elements, 0, extra, 0, nowl);
        this._elements = extra;
    }

    @Override
    public E get(int __i) throws IndexOutOfBoundsException {
        if (__i < 0 || __i >= this._size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        return this._elements[__i];
    }

    @Override
    public E remove(int __i) throws IndexOutOfBoundsException {
        int size = this._size;
        if (__i < 0 || __i >= size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        E[] elements = this._elements;
        E rv = elements[__i];
        int o2 = __i;
        for (int i2 = __i + 1; i2 < size; ++i2) {
            elements[o2] = elements[i2];
            ++o2;
        }
        elements[size - 1] = null;
        this._size = size - 1;
        ++this.modCount;
        return rv;
    }

    @Override
    protected void removeRange(int __a, int __b) {
        throw Debugging.todo();
    }

    @Override
    public E set(int __i, E __v) {
        int size = this._size;
        if (__i < 0 || __i >= size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        E[] elements = this._elements;
        E rv = elements[__i];
        elements[__i] = __v;
        return rv;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Api
    public void trimToSize() {
        throw Debugging.todo();
    }
}

