/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.__PrintFCategory__;
import java.util.__PrintFConversion__;
import java.util.__PrintFFlag__;
import java.util.__PrintFGlobal__;
import java.util.__PrintFState__;
import org.intellij.lang.annotations.PrintFormat;

@Api
public final class Formatter
implements Closeable {
    private static final String _NEWLINE;
    private final Appendable _out;
    private final StringBuilder _buffer;
    private volatile boolean _closed;
    private IOException _ioe;

    @Api
    public Formatter() {
        this(new StringBuilder());
    }

    @Api
    public Formatter(Appendable __a) throws NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        this._out = __a;
        this._buffer = __a instanceof StringBuilder ? null : new StringBuilder();
    }

    @Api
    public Formatter(PrintStream __ps) throws NullPointerException {
        this((Appendable)__ps);
    }

    @Override
    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        Appendable out = this._out;
        if (out instanceof Closeable) {
            try {
                ((Closeable)((Object)out)).close();
            }
            catch (IOException e2) {
                this._ioe = e2;
            }
        }
    }

    @Api
    public void flush() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("ZZ2i");
        }
        try {
            Appendable out = this._out;
            if (out instanceof OutputStream) {
                ((OutputStream)((Object)out)).flush();
            } else if (out instanceof Writer) {
                ((Writer)out).flush();
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("ZZ2j", e2);
        }
    }

    @Api
    public Formatter format(@PrintFormat String __fmt, Object ... __args) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        if (__fmt == null) {
            throw new NullPointerException("NARG");
        }
        if (this._closed) {
            throw new IllegalStateException("ZZ2k");
        }
        if (__args == null) {
            __args = new Object[]{};
        }
        __PrintFGlobal__ pg = new __PrintFGlobal__(__args);
        try {
            Appendable workingOut;
            StringBuilder buffer = this._buffer;
            Appendable finalOut = this._out;
            Appendable appendable = workingOut = buffer != null ? buffer : finalOut;
            if (buffer != null) {
                buffer.setLength(0);
            }
            int i2 = 0;
            int n2 = __fmt.length();
            int next = 0;
            while (i2 < n2) {
                char c2 = __fmt.charAt(i2);
                if (c2 != '%') {
                    workingOut.append(c2);
                    next = i2 + 1;
                } else {
                    __PrintFState__ pf = new __PrintFState__(pg);
                    next = Formatter.__specifier(pf, i2, __fmt);
                    Formatter.__output(workingOut, pf);
                }
                i2 = next;
            }
            if (buffer != null) {
                finalOut.append(buffer);
            }
        }
        catch (IOException e2) {
            this._ioe = e2;
        }
        return this;
    }

    @Api
    public IOException ioException() {
        return this._ioe;
    }

    @Api
    public Appendable out() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("ZZ2l");
        }
        return this._out;
    }

    public String toString() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("ZZ2m");
        }
        return this._out.toString();
    }

    private static String __formatDecimalInt(__PrintFState__ __pf, Number __n) throws NullPointerException {
        if (__pf == null) {
            throw new NullPointerException("NARG");
        }
        if (__n == null) {
            return null;
        }
        if (__pf.__hasFlag(__PrintFFlag__.ALTERNATIVE_FORM)) {
            throw new IllegalArgumentException("ZZ3s");
        }
        long value = __n.longValue();
        boolean neg = value < 0L;
        StringBuilder base = new StringBuilder(Long.toString(value));
        if (__pf.__hasFlag(__PrintFFlag__.LOCALE_GROUPING)) {
            throw Debugging.todo();
        }
        boolean signed = neg;
        if (neg) {
            if (__pf.__hasFlag(__PrintFFlag__.NEGATIVE_PARENTHESIS)) {
                base.setCharAt(0, '(');
                base.append(')');
            }
        } else if (signed |= __pf.__hasFlag(__PrintFFlag__.ALWAYS_SIGNED)) {
            base.insert(0, '+');
        } else if (signed |= __pf.__hasFlag(__PrintFFlag__.SPACE_FOR_POSITIVE)) {
            base.insert(0, ' ');
        }
        if (__pf.__hasFlag(__PrintFFlag__.ZERO_PADDED)) {
            int idx;
            int w2 = __pf.__width();
            int n2 = idx = signed ? 1 : 0;
            while (base.length() < w2) {
                base.insert(idx, '0');
            }
        }
        return base.toString();
    }

    private static String __formatOtherUnsignedInt(__PrintFState__ __pf, Number __n, int __base) throws NullPointerException {
        int shift;
        int mask;
        if (__pf == null) {
            throw new NullPointerException("NARG");
        }
        if (__pf.__hasFlag(__PrintFFlag__.LOCALE_GROUPING) || __pf.__hasFlag(__PrintFFlag__.NEGATIVE_PARENTHESIS) || __pf.__hasFlag(__PrintFFlag__.ALWAYS_SIGNED) || __pf.__hasFlag(__PrintFFlag__.SPACE_FOR_POSITIVE)) {
            throw new IllegalArgumentException("ZZ3t");
        }
        long input = __n instanceof Byte ? (long)__n.byteValue() & 0xFFL : (__n instanceof Short ? (long)__n.shortValue() & 0xFFFFL : (__n instanceof Integer ? (long)__n.intValue() & 0xFFFFFFFFL : __n.longValue()));
        switch (__pf._conv) {
            case OCTAL_INTEGER: {
                mask = 7;
                shift = 3;
                break;
            }
            default: {
                mask = 15;
                shift = 4;
            }
        }
        StringBuilder out = new StringBuilder();
        for (long rest = input; rest != 0L; rest >>>= shift) {
            int val2 = (int)(rest & (long)mask);
            out.append(Character.forDigit(val2, __base));
        }
        if (__pf.__hasFlag(__PrintFFlag__.ZERO_PADDED)) {
            int n2 = __pf.__width();
            for (int i2 = out.length(); i2 < n2; ++i2) {
                out.append('0');
            }
        }
        if (__pf.__hasFlag(__PrintFFlag__.ALTERNATIVE_FORM)) {
            int len = out.length();
            if (__base == 16) {
                if (len >= 2 && out.charAt(len - 1) == '0' && out.charAt(len - 2) == '0') {
                    out.setCharAt(len - 2, 'x');
                } else if (len >= 1 && out.charAt(len - 1) == '0') {
                    out.setCharAt(len - 1, 'x');
                    out.append('0');
                } else {
                    out.append('x');
                    out.append('0');
                }
            } else if (__base == 8 && len < 1 && out.charAt(len - 1) != '0') {
                out.append('0');
            }
        }
        out.reverse();
        return out.toString();
    }

    private static void __output(Appendable __out, __PrintFState__ __pf) throws IllegalArgumentException, IOException, NullPointerException {
        int i2;
        int precision;
        String append;
        if (__out == null || __pf == null) {
            throw new NullPointerException("NARG");
        }
        __PrintFConversion__ conv = __pf._conv;
        __PrintFCategory__ cat = conv.__category();
        switch (conv) {
            case NEWLINE: {
                append = _NEWLINE;
                break;
            }
            case BOOLEAN: {
                append = __pf.__argument(Boolean.class, Boolean.FALSE).toString();
                break;
            }
            case CHARACTER: {
                Character cha = __pf.__argument(Character.class);
                append = cha == null ? "null" : cha.toString();
                break;
            }
            case OCTAL_INTEGER: {
                append = Formatter.__formatOtherUnsignedInt(__pf, __pf.__argument(Number.class), 8);
                break;
            }
            case DECIMAL_INTEGER: {
                append = Formatter.__formatDecimalInt(__pf, __pf.__argument(Number.class));
                break;
            }
            case HEXADECIMAL_INTEGER: {
                append = Formatter.__formatOtherUnsignedInt(__pf, __pf.__argument(Number.class), 16);
                break;
            }
            case STRING: {
                append = __pf.__argument(Object.class, "null").toString();
                break;
            }
            case PERCENT: {
                append = "%";
                break;
            }
            default: {
                throw Debugging.todo("ZZ2n " + (Object)((Object)conv));
            }
        }
        if (__pf._upper) {
            append = append.toUpperCase();
        }
        if (cat == __PrintFCategory__.GENERAL && (precision = __pf._precision) >= 0) {
            append = append.substring(0, Math.min(precision, append.length()));
        }
        int strlen = append.length();
        int width = Math.max(strlen, __pf._width);
        int padding = width - strlen;
        boolean isleft = __pf.__isLeftJustified();
        if (!isleft) {
            for (i2 = 0; i2 < padding; ++i2) {
                __out.append(' ');
            }
        }
        __out.append(append);
        if (isleft) {
            for (i2 = 0; i2 < padding; ++i2) {
                __out.append(' ');
            }
        }
    }

    private static int __specifier(__PrintFState__ __pf, int __base, String __fmt) throws IllegalArgumentException, NullPointerException {
        if (__pf == null || __fmt == null) {
            throw new NullPointerException("NARG");
        }
        int fmtlen = __fmt.length();
        int at2 = __base + 1;
        try {
            int base;
            char c2 = __fmt.charAt(at2);
            if (c2 >= '1' && c2 <= '9') {
                base = at2;
                while ((c2 = __fmt.charAt(at2)) >= '0' && c2 <= '9') {
                    ++at2;
                }
                int val2 = Integer.valueOf(__fmt.substring(base, at2));
                if (__fmt.charAt(at2) == '$') {
                    __pf.__setArgumentIndex(val2);
                    ++at2;
                } else {
                    __pf.__setWidth(val2);
                }
            }
            if (!__pf.__hasWidth()) {
                c2 = __fmt.charAt(at2);
                while (__pf.__setFlag(c2)) {
                    c2 = __fmt.charAt(++at2);
                }
            }
            c2 = __fmt.charAt(at2);
            if (!__pf.__hasWidth() && c2 >= '1' && c2 <= '9') {
                base = at2;
                while ((c2 = __fmt.charAt(at2)) >= '0' && c2 <= '9') {
                    ++at2;
                }
                __pf.__setWidth(Integer.valueOf(__fmt.substring(base, at2)));
            }
            if ((c2 = __fmt.charAt(at2)) == '.') {
                throw Debugging.todo();
            }
            c2 = __fmt.charAt(at2);
            if (c2 == 't' || c2 == 'T') {
                __pf.__setConversion(c2, __fmt.charAt(at2 + 1));
                ++at2;
            } else {
                __pf.__setConversion(c2, -1);
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException e2) {
            throw new IllegalArgumentException("ZZ2o " + __fmt.substring(__base, Math.min(at2, __fmt.length())), e2);
        }
        return ++at2;
    }

    static {
        String nl;
        try {
            nl = System.getProperty("line.separator");
        }
        catch (SecurityException e2) {
            nl = "\n";
        }
        _NEWLINE = nl;
    }
}

