/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.IteratorToEnumeration;
import cc.squirreljme.runtime.cldc.util.MapKeySetView;
import cc.squirreljme.runtime.cldc.util.SynchronizedEntrySetNotNull;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.__AbstractMapValues__;
import java.util.__BucketMapEntry__;
import java.util.__BucketMap__;

@Api
public class Hashtable<K, V>
implements Map<K, V>,
Cloneable {
    private final __BucketMap__<K, V> _map;

    @Api
    public Hashtable(int __cap, float __load) {
        this._map = new __BucketMap__(false, false, __cap, __load);
    }

    @Api
    public Hashtable(int __cap) throws IllegalArgumentException {
        this._map = new __BucketMap__(false, __cap);
    }

    @Api
    public Hashtable() {
        this._map = new __BucketMap__(false);
    }

    @Api
    public Hashtable(Map<? extends K, ? extends V> __m) throws NullPointerException {
        if (__m == null) {
            throw new NullPointerException("NARG");
        }
        this._map = new __BucketMap__(false, Math.max(16, __m.size()));
        this.putAll(__m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            this._map.clear();
        }
    }

    public Object clone() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            try {
                Map copy = (Map)this.getClass().newInstance();
                copy.putAll(this);
                return copy;
            }
            catch (IllegalAccessException | InstantiationException e2) {
                throw new RuntimeException("ZZ2r", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object __v) {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return this.values().contains(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object __k) {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return null != this._map.getEntry(__k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object __v) {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return this.values().contains(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public Enumeration<V> elements() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return new IteratorToEnumeration<V>(this.values().iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return new SynchronizedEntrySetNotNull<K, V>(this, this._map.entrySet());
        }
    }

    @Override
    public boolean equals(Object __a) {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            throw Debugging.todo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object __k) throws NullPointerException {
        if (__k == null) {
            throw new NullPointerException("NARG");
        }
        Hashtable hashtable = this;
        synchronized (hashtable) {
            __BucketMapEntry__<K, V> e2 = this._map.getEntry(__k);
            if (e2 == null) {
                return null;
            }
            return e2.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            int rv = 0;
            for (Map.Entry<K, V> e2 : this.entrySet()) {
                rv += e2.hashCode();
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return this._map.isEmpty();
        }
    }

    @Override
    public Set<K> keySet() {
        return new MapKeySetView(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public Enumeration<K> keys() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return new IteratorToEnumeration<K>(this.keySet().iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K __k, V __v) throws NullPointerException {
        if (__k == null || __v == null) {
            throw new NullPointerException("NARG");
        }
        __BucketMap__<K, V> map = this._map;
        Hashtable hashtable = this;
        synchronized (hashtable) {
            int numrehash = map._numrehash;
            V rv = this._map.putEntry(__k).setValue(__v);
            if (map._numrehash != numrehash) {
                this.rehash();
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> __m) throws NullPointerException {
        if (__m == null) {
            throw new NullPointerException("NARG");
        }
        Hashtable hashtable = this;
        synchronized (hashtable) {
            for (Map.Entry<K, V> e2 : __m.entrySet()) {
                this.put(e2.getKey(), e2.getValue());
            }
        }
    }

    @Api
    protected void rehash() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object __k) throws NullPointerException {
        if (__k == null) {
            throw new NullPointerException("NARG");
        }
        __BucketMap__<K, V> map = this._map;
        Hashtable hashtable = this;
        synchronized (hashtable) {
            int numrehash = map._numrehash;
            V rv = this._map.remove(__k);
            if (map._numrehash != numrehash) {
                this.rehash();
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            return this._map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Hashtable hashtable = this;
        synchronized (hashtable) {
            StringBuilder sb = new StringBuilder("{");
            boolean comma = false;
            for (Map.Entry<K, V> e2 : this.entrySet()) {
                if (comma) {
                    sb.append(", ");
                }
                comma = true;
                sb.append(e2.getKey());
                sb.append('=');
                sb.append(e2.getValue());
            }
            sb.append('}');
            return sb.toString();
        }
    }

    @Override
    public Collection<V> values() {
        return new __AbstractMapValues__(this);
    }
}

