/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.IteratorToEnumeration;
import cc.squirreljme.runtime.cldc.util.SynchronizedIterator;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

@Api
public class Vector<E>
extends AbstractList<E>
implements RandomAccess,
Cloneable {
    @Api
    protected int capacityIncrement;
    @Api
    protected int elementCount;
    @Api
    protected Object[] elementData;

    @Api
    public Vector(int __cap, int __inc) throws IllegalArgumentException {
        if (__cap < 0) {
            throw new IllegalArgumentException("ZZ32");
        }
        this.elementData = new Object[__cap];
        this.capacityIncrement = Math.max(__inc, 0);
    }

    @Api
    public Vector(int __cap) throws IllegalArgumentException {
        this(__cap, 0);
    }

    @Api
    public Vector() {
        this(10, 0);
    }

    @Api
    public Vector(Collection<? extends E> __c) throws NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        int initialCap = __c.size();
        this.elementData = new Object[initialCap];
        this.capacityIncrement = initialCap;
        this.addAll(__c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int __i, E __v) {
        Vector vector = this;
        synchronized (vector) {
            this.__internalAdd(__i, __v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> __c) {
        Vector vector = this;
        synchronized (vector) {
            return super.addAll(__c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int __i, Collection<? extends E> __c) {
        Vector vector = this;
        synchronized (vector) {
            return super.addAll(__i, __c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(E __v) {
        Vector vector = this;
        synchronized (vector) {
            super.add(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public int capacity() {
        Vector vector = this;
        synchronized (vector) {
            return this.elementData.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Vector vector = this;
        synchronized (vector) {
            this.elementCount = 0;
            Object[] elements = this.elementData;
            int n2 = elements.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                elements[i2] = null;
            }
        }
    }

    public Vector<E> clone() {
        Vector vector = this;
        synchronized (vector) {
            throw Debugging.todo("Vector clone");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object __v) {
        Vector vector = this;
        synchronized (vector) {
            return super.contains(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> __c) {
        Vector vector = this;
        synchronized (vector) {
            return super.containsAll(__c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(Object[] __a) throws ArrayStoreException, IndexOutOfBoundsException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        Vector vector = this;
        synchronized (vector) {
            int n2 = this.elementCount;
            if (n2 > __a.length) {
                throw new IndexOutOfBoundsException("ZZ3q");
            }
            Object[] elements = this.elementData;
            for (int i2 = 0; i2 < n2; ++i2) {
                __a[i2] = elements[i2];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public E elementAt(int __i) {
        Vector vector = this;
        synchronized (vector) {
            return this.__internalGet(__i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public Enumeration<E> elements() {
        Vector vector = this;
        synchronized (vector) {
            return new IteratorToEnumeration<E>(this.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void ensureCapacity(int __n) {
        Vector vector = this;
        synchronized (vector) {
            if (__n <= 0) {
                return;
            }
            Object[] elements = this.elementData;
            int nowLen = elements.length;
            if (__n <= nowLen) {
                return;
            }
            Object[] extra = new Object[__n];
            for (int i2 = 0; i2 < nowLen; ++i2) {
                extra[i2] = elements[i2];
            }
            this.elementData = extra;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object __o) {
        Vector vector = this;
        synchronized (vector) {
            return super.equals(__o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public E firstElement() throws NoSuchElementException {
        Vector vector = this;
        synchronized (vector) {
            if (this.elementCount <= 0) {
                throw new NoSuchElementException("NSEE");
            }
            return (E)this.elementData[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int __i) {
        Vector vector = this;
        synchronized (vector) {
            return this.__internalGet(__i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Vector vector = this;
        synchronized (vector) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object __v) {
        Vector vector = this;
        synchronized (vector) {
            return super.indexOf(__v);
        }
    }

    @Api
    public int indexOf(Object __v, int __base) {
        Vector vector = this;
        synchronized (vector) {
            throw Debugging.todo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void insertElementAt(E __v, int __at) {
        Vector vector = this;
        synchronized (vector) {
            this.__internalAdd(__at, __v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Vector vector = this;
        synchronized (vector) {
            return new SynchronizedIterator(this, super.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public E lastElement() throws NoSuchElementException {
        Vector vector = this;
        synchronized (vector) {
            int count = this.elementCount;
            if (count <= 0) {
                throw new NoSuchElementException("NSEE");
            }
            return (E)this.elementData[count - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object __v) {
        Vector vector = this;
        synchronized (vector) {
            return super.lastIndexOf(__v);
        }
    }

    @Api
    public int lastIndexOf(Object __v, int __base) {
        Vector vector = this;
        synchronized (vector) {
            throw Debugging.todo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object __v) {
        Vector vector = this;
        synchronized (vector) {
            return super.remove(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int __i) throws ArrayIndexOutOfBoundsException {
        Vector vector = this;
        synchronized (vector) {
            int size = this.elementCount;
            if (__i < 0 || __i >= size) {
                throw new ArrayIndexOutOfBoundsException("IOOB");
            }
            Object[] elements = this.elementData;
            Object rv = elements[__i];
            int o2 = __i;
            for (int i2 = __i + 1; i2 < size; ++i2) {
                elements[o2] = elements[i2];
                ++o2;
            }
            elements[size - 1] = null;
            this.elementCount = size - 1;
            return (E)rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> __c) {
        Vector vector = this;
        synchronized (vector) {
            return super.removeAll(__c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void removeAllElements() {
        Vector vector = this;
        synchronized (vector) {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public boolean removeElement(Object __v) {
        Vector vector = this;
        synchronized (vector) {
            return this.remove(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void removeElementAt(int __i) throws ArrayIndexOutOfBoundsException {
        Vector vector = this;
        synchronized (vector) {
            this.remove(__i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRange(int __a, int __b) {
        Vector vector = this;
        synchronized (vector) {
            super.removeRange(__a, __b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> __c) {
        Vector vector = this;
        synchronized (vector) {
            return super.retainAll(__c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int __i, E __v) {
        Vector vector = this;
        synchronized (vector) {
            int size = this.elementCount;
            if (__i < 0 || __i >= size) {
                throw new ArrayIndexOutOfBoundsException("IOOB");
            }
            Object[] elements = this.elementData;
            Object rv = elements[__i];
            elements[__i] = __v;
            return (E)rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void setElementAt(E __v, int __i) throws ArrayIndexOutOfBoundsException {
        Vector vector = this;
        synchronized (vector) {
            this.set(__i, __v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void setSize(int __n) throws ArrayIndexOutOfBoundsException {
        if (__n < 0) {
            throw new ArrayIndexOutOfBoundsException("IOOB");
        }
        Vector vector = this;
        synchronized (vector) {
            this.ensureCapacity(__n);
            int count = this.elementCount;
            Object[] elements = this.elementData;
            for (int i2 = count; i2 < __n; ++i2) {
                elements[i2] = null;
            }
            this.elementCount = __n;
            ++this.modCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Vector vector = this;
        synchronized (vector) {
            return this.elementCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int __from, int __to) {
        Vector vector = this;
        synchronized (vector) {
            return super.subList(__from, __to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public void trimToSize() {
        Vector vector = this;
        synchronized (vector) {
            int elementCount = this.elementCount;
            Object[] elementData = this.elementData;
            if (elementData.length > elementCount) {
                this.elementData = Arrays.copyOf(elementData, elementCount);
            }
        }
    }

    private void __internalAdd(int __i, E __v) {
        int size = this.elementCount;
        if (__i < 0 || __i > size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        Object[] elements = this.elementData;
        int cap = elements.length;
        int nextSize = size + 1;
        Object[] source = elements;
        if (nextSize > cap) {
            int newCap = nextSize + Math.max(1, this.capacityIncrement);
            elements = new Object[newCap];
            for (int i2 = 0; i2 < __i; ++i2) {
                elements[i2] = source[i2];
            }
        }
        int i3 = size - 1;
        for (int o2 = size; o2 > __i; --o2) {
            elements[o2] = source[i3];
            --i3;
        }
        elements[__i] = __v;
        this.elementCount = nextSize;
        if (elements != source) {
            this.elementData = elements;
        }
        ++this.modCount;
    }

    private E __internalGet(int __i) throws ArrayIndexOutOfBoundsException {
        if (__i < 0 || __i >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException("IOOB");
        }
        return (E)this.elementData[__i];
    }
}

