/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import cc.squirreljme.jvm.mle.JarPackageShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.ServiceConfigurationError;
import java.util.__ServiceLoaderCache__;

final class __ServiceLoaderFreshIterator__<S>
implements Iterator<S> {
    private final Class<S> _search;
    private final __ServiceLoaderCache__<S> _cache;
    private final List<Object> _cacheBuild = new ArrayList<Object>();
    private final Queue<JarPackageBracket> _jarsLeft = new LinkedList<JarPackageBracket>();
    private final Queue<String> _classes = new LinkedList<String>();
    private S _next;
    private boolean _finished;

    __ServiceLoaderFreshIterator__(Class<S> __s, __ServiceLoaderCache__<S> __c) throws NullPointerException {
        if (__s == null || __c == null) {
            throw new NullPointerException("NARG");
        }
        this._search = __s;
        this._cache = __c;
        this._jarsLeft.addAll(Arrays.asList(JarPackageShelf.classPath()));
    }

    @Override
    public final boolean hasNext() {
        String maybe;
        if (this._finished) {
            return false;
        }
        if (this._next != null) {
            return true;
        }
        Queue<String> classes = this._classes;
        do {
            if (!classes.isEmpty()) continue;
            this.__consumeNextJar();
            if (!this._finished) continue;
            return false;
        } while ((maybe = classes.poll()) == null);
        try {
            Class<?> cl2 = Class.forName(maybe);
            Object rv = cl2.newInstance();
            this._cacheBuild.add(rv);
            this._next = this._search.cast(rv);
            return true;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
            throw new ServiceConfigurationError("ZZ30", e2);
        }
    }

    @Override
    public final S next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("NSEE");
        }
        S rv = this._next;
        this._next = null;
        return rv;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("RORO");
    }

    private void __consumeNextJar() {
        JarPackageBracket nextJar = this._jarsLeft.poll();
        if (nextJar == null) {
            this._finished = true;
            List<Object> cb2 = this._cacheBuild;
            this._cache._cache = cb2.toArray(new Object[cb2.size()]);
            cb2.clear();
            return;
        }
        this.__loadJar(nextJar);
    }

    private void __loadJar(JarPackageBracket __jar) throws NullPointerException {
        if (__jar == null) {
            throw new NullPointerException("NARG");
        }
        try (InputStream in = JarPackageShelf.openResource(__jar, "META-INF/services/" + this._search.getName());){
            if (in == null) {
                return;
            }
            Queue<String> classes = this._classes;
            try (BufferedReader br2 = new BufferedReader(new InputStreamReader(in, "utf-8"));){
                String ln;
                while ((ln = br2.readLine()) != null) {
                    if ((ln = ln.trim()).isEmpty() || ln.charAt(0) == '#') continue;
                    classes.add(ln);
                }
            }
        }
        catch (IOException e2) {
            throw new ServiceConfigurationError("ZZ31", e2);
        }
    }
}

