/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.gcf.CustomConnectionFactory;
import cc.squirreljme.runtime.gcf.HTTPAddress;
import cc.squirreljme.runtime.gcf.HTTPClientConnection;
import cc.squirreljme.runtime.gcf.IPAddress;
import cc.squirreljme.runtime.gcf.IPConnectionFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ServiceLoader;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.ConnectionOption;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import org.intellij.lang.annotations.Language;

@Api
public class Connector {
    @Api
    public static final int READ = 1;
    @Api
    public static final int WRITE = 2;
    @Api
    public static final int READ_WRITE = 3;
    private static final ServiceLoader<CustomConnectionFactory> _SERVICES = ServiceLoader.load(CustomConnectionFactory.class);

    private Connector() {
    }

    @Api
    public static long getBytesRead(Connection __a) throws IOException {
        throw Debugging.todo();
    }

    @Api
    public static long getBytesWritten(Connection __a) throws IOException {
        throw Debugging.todo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public static boolean isProtocolSupported(@Language(value="http-url-reference") String __uri, boolean __server) throws NullPointerException {
        if (__uri == null) {
            throw new NullPointerException("NARG");
        }
        int fc = __uri.indexOf(58);
        if (fc > 0) {
            __uri = __uri.substring(0, fc);
        }
        switch (__uri) {
            case "comm": 
            case "datagram": 
            case "dtls": 
            case "file": 
            case "imc": 
            case "multicast": 
            case "socket": 
            case "ssl": {
                return true;
            }
            case "http": 
            case "https": {
                return !__server;
            }
        }
        Class<Connector> clazz = Connector.class;
        synchronized (Connector.class) {
            for (CustomConnectionFactory custom : _SERVICES) {
                if (!__uri.equalsIgnoreCase(custom.scheme())) continue;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return false;
        }
    }

    @Api
    public static Connection open(@Language(value="http-url-reference") String __uri) throws IOException {
        return Connector.open(__uri, 3, false, (ConnectionOption[])null);
    }

    @Api
    public static Connection open(@Language(value="http-url-reference") String __uri, ConnectionOption<?> ... __opts) throws IOException {
        return Connector.open(__uri, 3, false, __opts);
    }

    @Api
    public static Connection open(@Language(value="http-url-reference") String __uri, int __mode) throws IOException {
        return Connector.open(__uri, __mode, false, (ConnectionOption[])null);
    }

    @Api
    public static Connection open(@Language(value="http-url-reference") String __uri, int __mode, ConnectionOption<?> ... __opts) throws IOException {
        return Connector.open(__uri, __mode, false, __opts);
    }

    @Api
    public static Connection open(@Language(value="http-url-reference") String __uri, int __mode, boolean __timeouts) throws IOException {
        return Connector.open(__uri, __mode, __timeouts, (ConnectionOption[])null);
    }

    @Api
    public static Connection open(@Language(value="http-url-reference") String __uri, int __mode, boolean __timeouts, ConnectionOption<?> ... __opts) throws ConnectionNotFoundException, IllegalArgumentException, IOException, NullPointerException, SecurityException {
        Debugging.debugNote("Open %s", __uri);
        try {
            return Connector.__open(__uri, __mode, __timeouts, __opts);
        }
        catch (IOException | IllegalArgumentException | NullPointerException | SecurityException e2) {
            e2.printStackTrace();
            throw e2;
        }
    }

    @Api
    public static DataInputStream openDataInputStream(@Language(value="http-url-reference") String __uri) throws IOException {
        return new DataInputStream(Connector.openInputStream(__uri));
    }

    @Api
    public static DataOutputStream openDataOutputStream(@Language(value="http-url-reference") String __uri) throws IOException {
        return new DataOutputStream(Connector.openOutputStream(__uri));
    }

    @Api
    public static InputStream openInputStream(@Language(value="http-url-reference") String __uri) throws IllegalArgumentException, IOException {
        try (Connection c2 = Connector.open(__uri, 1);){
            if (!(c2 instanceof InputConnection)) {
                throw new IllegalArgumentException(String.format("EC0z %s", __uri));
            }
            InputStream inputStream = ((InputConnection)c2).openInputStream();
            return inputStream;
        }
    }

    @Api
    public static OutputStream openOutputStream(@Language(value="http-url-reference") String __uri) throws IllegalArgumentException, IOException {
        try (Connection c2 = Connector.open(__uri, 2);){
            if (!(c2 instanceof OutputConnection)) {
                throw new IllegalArgumentException(String.format("EC10 %s", __uri));
            }
            OutputStream outputStream = ((OutputConnection)c2).openOutputStream();
            return outputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    private static Connection __open(@Language(value="http-url-reference") String __uri, int __mode, boolean __timeouts, ConnectionOption<?> ... __opts) throws ConnectionNotFoundException, IllegalArgumentException, IOException, NullPointerException, SecurityException {
        int fc;
        if (__uri == null) {
            throw new NullPointerException("NARG");
        }
        if (__opts == null) {
            __opts = new ConnectionOption[]{};
        }
        if ((fc = __uri.indexOf(58)) < 0) {
            throw new IllegalArgumentException(String.format("EC11 %s", __uri));
        }
        String scheme = __uri.substring(0, fc);
        String part = __uri.substring(fc + 1);
        switch (scheme) {
            case "comm": {
                throw Debugging.todo();
            }
            case "datagram": {
                throw Debugging.todo();
            }
            case "dtls": {
                throw Debugging.todo();
            }
            case "file": {
                throw Debugging.todo();
            }
            case "http": {
                return HTTPClientConnection.connectDefault(HTTPAddress.fromUriPart(part));
            }
            case "https": {
                throw Debugging.todo();
            }
            case "imc": {
                throw Debugging.todo();
            }
            case "multicast": {
                throw Debugging.todo();
            }
            case "socket": {
                IPAddress addr = IPAddress.fromUriPart(part);
                if (addr.isServer()) {
                    throw Debugging.todo();
                }
                IPConnectionFactory pf = IPConnectionFactory.factory();
                return pf.tcpClientConnect(pf.resolveAddress(addr));
            }
            case "ssl": {
                throw Debugging.todo();
            }
        }
        Object object = Connector.class;
        synchronized (Connector.class) {
            for (CustomConnectionFactory custom : _SERVICES) {
                if (!scheme.equalsIgnoreCase(custom.scheme())) continue;
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return custom.connect(part, __mode, __timeouts, __opts);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            throw new ConnectionNotFoundException(String.format("EC12 %s", __uri));
        }
    }
}

