/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import cc.squirreljme.jvm.mle.scritchui.ScritchInterface;
import cc.squirreljme.jvm.mle.scritchui.ScritchLAFInterface;
import cc.squirreljme.jvm.mle.scritchui.ScritchPanelInterface;
import cc.squirreljme.jvm.mle.scritchui.brackets.ScritchPanelBracket;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.lcdui.event.EventTranslate;
import cc.squirreljme.runtime.lcdui.event.KeyNames;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayScale;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayState;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayableState;
import cc.squirreljme.runtime.lcdui.scritchui.ScritchLcdUiUtils;
import cc.squirreljme.runtime.midlet.MeepRuntime;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.KeyListener;
import javax.microedition.lcdui.__CanvasDefaultKeyListener__;
import javax.microedition.lcdui.__ExecCanvasInput__;
import javax.microedition.lcdui.__ExecCanvasPaint__;
import javax.microedition.lcdui.__ExecCanvasRepainter__;
import javax.microedition.lcdui.__ExecCanvasVisible__;
import org.jetbrains.annotations.Async;

@Api
public abstract class Canvas
extends Displayable {
    @SquirrelJMEVendorApi
    private static final boolean _FORCE_BUFFER = false;
    private static final int _REPAINT_STOP = 5;
    private static final int _REPAINT_DELAY = 16;
    @Api
    public static final int ACTIONS_ALL = -2;
    @Api
    public static final int ACTIONS_NAVIGATION = -1;
    @Api
    public static final int ACTIONS_NONE = 0;
    @Api
    public static final int DOWN = 6;
    @Api
    public static final int FIRE = 8;
    @Api
    public static final int GAME_A = 9;
    @Api
    public static final int GAME_B = 10;
    @Api
    public static final int GAME_C = 11;
    @Api
    public static final int GAME_D = 12;
    @Api
    public static final int KEY_BACKSPACE = 8;
    @Api
    public static final int KEY_DELETE = 127;
    @Api
    public static final int KEY_DOWN = -2;
    @Api
    public static final int KEY_ENTER = 10;
    @Api
    public static final int KEY_ESCAPE = 27;
    @Api
    public static final int KEY_LEFT = -3;
    @Api
    public static final int KEY_NUM0 = 48;
    @Api
    public static final int KEY_NUM1 = 49;
    @Api
    public static final int KEY_NUM2 = 50;
    @Api
    public static final int KEY_NUM3 = 51;
    @Api
    public static final int KEY_NUM4 = 52;
    @Api
    public static final int KEY_NUM5 = 53;
    @Api
    public static final int KEY_NUM6 = 54;
    @Api
    public static final int KEY_NUM7 = 55;
    @Api
    public static final int KEY_NUM8 = 56;
    @Api
    public static final int KEY_NUM9 = 57;
    @Api
    public static final int KEY_POUND = 35;
    @Api
    public static final int KEY_RIGHT = -4;
    @Api
    public static final int KEY_SELECT = -5;
    @Api
    public static final int KEY_SPACE = 32;
    @Api
    public static final int KEY_STAR = 42;
    @Api
    public static final int KEY_TAB = 9;
    @Api
    public static final int KEY_UP = -1;
    @Api
    public static final int LEFT = 2;
    @Api
    public static final int RIGHT = 5;
    @Api
    public static final int UP = 1;
    private final Object _repaintLock = new Object();
    private final __ExecCanvasRepainter__ _repainter;
    volatile Image _buffer;
    KeyListener _keyListener;
    boolean _isOpaque;
    volatile boolean _isFullScreen;
    volatile int _pendingPaints;
    private KeyListener _defaultKeyListener;
    private int _requiredActions;

    @Api
    protected Canvas() {
        DisplayableState state = this.__state();
        ScritchInterface scritchApi = state.scritchApi();
        ScritchPanelInterface panelApi = scritchApi.panel();
        ScritchPanelBracket scritchPanel = state.scritchPanel();
        scritchApi.paintable().componentSetPaintListener(scritchPanel, new __ExecCanvasPaint__(this));
        scritchApi.component().componentSetVisibleListener(scritchPanel, new __ExecCanvasVisible__(this));
        panelApi.panelSetInputListener(scritchPanel, new __ExecCanvasInput__(this));
        panelApi.panelEnableFocus(scritchPanel, true, true);
        this._repainter = new __ExecCanvasRepainter__(this);
        this._isOpaque = MeepRuntime.versionLeast(3, 0);
    }

    @Api
    @Async.Execute
    protected abstract void paint(Graphics var1);

    @Api
    public int getGameAction(int __kc) throws IllegalArgumentException {
        return EventTranslate.keyCodeToGameAction(__kc);
    }

    @Override
    public int getHeight() {
        Image buffer = this._buffer;
        if (buffer != null) {
            return buffer.getHeight();
        }
        return ScritchLcdUiUtils.lcduiDisplaySize(this.__state(), true);
    }

    @Api
    public int getKeyCode(int __gc) throws IllegalArgumentException {
        int rv = EventTranslate.gameActionToKeyCode(__gc);
        if (rv == 0) {
            throw new IllegalArgumentException("EB1a " + __gc);
        }
        return rv;
    }

    @Api
    public String getKeyName(int __a) throws IllegalArgumentException {
        return KeyNames.getKeyName(__a);
    }

    @Api
    public int[] getSoftkeyLabelCoordinates(int __sk) throws IllegalArgumentException {
        throw Debugging.todo();
    }

    @Override
    public int getWidth() {
        Image buffer = this._buffer;
        if (buffer != null) {
            return buffer.getWidth();
        }
        return ScritchLcdUiUtils.lcduiDisplaySize(this.__state(), false);
    }

    @Api
    public boolean hasPointerEvents() {
        throw Debugging.todo();
    }

    @Api
    public boolean hasPointerMotionEvents() {
        throw Debugging.todo();
    }

    @Api
    public boolean hasRepeatEvents() {
        return true;
    }

    @Api
    @Async.Execute
    protected void hideNotify() {
    }

    @Api
    public boolean isDoubleBuffered() {
        DisplayState display = this.__state().currentDisplay();
        if (display == null) {
            return false;
        }
        return display.display()._scale.requiresBuffer();
    }

    @Api
    @Async.Execute
    protected void keyPressed(int __code) {
    }

    @Api
    @Async.Execute
    protected void keyReleased(int __code) {
    }

    @Api
    @Async.Execute
    protected void keyRepeated(int __code) {
    }

    @Api
    @Async.Execute
    protected void pointerDragged(int __x, int __y) {
    }

    @Api
    @Async.Execute
    protected void pointerPressed(int __x, int __y) {
    }

    @Api
    @Async.Execute
    protected void pointerReleased(int __x, int __y) {
    }

    @Api
    public final void repaint() {
        this.__state().scritchApi().eventLoop().loopExecuteLater(this._repainter);
    }

    @Api
    public final void repaint(int __x, int __y, int __w, int __h) {
        if (__w <= 0 || __h <= 0) {
            return;
        }
        this.__state().scritchApi().eventLoop().loopExecuteLater(this._repainter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public final void serviceRepaints() {
        DisplayState current = this.__state().currentDisplay();
        if (current == null) {
            return;
        }
        Object repaintLock = this._repaintLock;
        for (int i2 = 0; i2 < 5; ++i2) {
            Object object = repaintLock;
            synchronized (object) {
                if (this._pendingPaints <= 0) {
                    return;
                }
                try {
                    repaintLock.wait(16L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    @Api
    public void setFullScreenMode(boolean __f) {
        if (this._isFullScreen == __f) {
            return;
        }
        this._isFullScreen = __f;
    }

    @Api
    public void setKeyListener(KeyListener __kl) {
        this._keyListener = __kl;
    }

    @Api
    public void setPaintMode(boolean __opaque) {
        this._isOpaque = __opaque;
    }

    @Api
    public void setRequiredActions(int __actions) throws IllegalArgumentException {
        if (__actions != -2 && __actions != -1 && __actions != 0) {
            throw new IllegalArgumentException("EB18 " + __actions);
        }
        if (!this.hasPointerEvents()) {
            return;
        }
        throw Debugging.todo();
    }

    @Api
    @Async.Execute
    protected void showNotify() {
    }

    @Override
    @Api
    @Async.Execute
    protected void sizeChanged(int __w, int __h) {
    }

    final KeyListener __defaultKeyListener() {
        KeyListener rv = this._defaultKeyListener;
        if (rv == null) {
            this._defaultKeyListener = rv = new __CanvasDefaultKeyListener__(this);
        }
        return rv;
    }

    @Override
    @SquirrelJMEVendorApi
    void __execRevalidate(DisplayState __parent) {
        super.__execRevalidate(__parent);
        DisplayScale scale = __parent.display()._scale;
        if (scale.requiresBuffer()) {
            int w2 = Math.max(1, scale.textureW());
            int h2 = Math.max(1, scale.textureH());
            Image oldBuffer = this._buffer;
            if (oldBuffer == null || w2 > oldBuffer.getWidth() || h2 > oldBuffer.getHeight()) {
                this._buffer = new Image(new int[w2 * h2], w2 * h2, w2, h2, true, false);
            }
        } else {
            this._buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __paint(Graphics __gfx, int __sw, int __sh, int __special) {
        Graphics subGfx;
        Image buffer;
        DisplayState display = this.__state().currentDisplay();
        if (display == null) {
            return;
        }
        DisplayScale scale = display.display()._scale;
        if (scale.requiresBuffer()) {
            buffer = this._buffer;
            if (buffer == null) {
                return;
            }
            subGfx = buffer.getGraphics();
        } else {
            buffer = null;
            subGfx = __gfx;
        }
        if (this._isOpaque) {
            ScritchLAFInterface lafApi = this.__state().scritchApi().environment().lookAndFeel();
            ScritchPanelBracket panel = this.__state().scritchPanel();
            int bgColor = lafApi.lafElementColor(panel, 7);
            subGfx.setAlphaColor(bgColor | 0xFF000000);
            subGfx.fillRect(0, 0, __sw, __sh);
            int fgColor = lafApi.lafElementColor(panel, 8);
            subGfx.setAlphaColor(fgColor | 0xFF000000);
        }
        try {
            this.paint(subGfx);
            if (buffer != null) {
                __gfx.translate(-__gfx.getTranslateX(), -__gfx.getTranslateX());
                __gfx.setClip(0, 0, __sw, __sh);
                __gfx.drawRegion(buffer, 0, 0, scale.textureW(), scale.textureH(), 0, 0, 0, 0, scale.screenX(scale.textureW()), scale.screenY(scale.textureH()));
            }
        }
        finally {
            Object repaintLock;
            Object object = repaintLock = this._repaintLock;
            synchronized (object) {
                int pending = this._pendingPaints;
                if (pending > 0) {
                    this._pendingPaints = 0;
                    repaintLock.notifyAll();
                }
            }
        }
    }
}

