/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import cc.squirreljme.jvm.mle.PencilFontShelf;
import cc.squirreljme.jvm.mle.brackets.PencilFontBracket;
import cc.squirreljme.jvm.mle.scritchui.ScritchInterface;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.debug.ErrorCode;
import cc.squirreljme.runtime.lcdui.font.FontUtilities;
import cc.squirreljme.runtime.lcdui.mle.PencilFontProvider;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;

@Api
public final class Font
extends PencilFontProvider {
    @Api
    public static final int FACE_MONOSPACE = 32;
    @Api
    public static final int FACE_PROPORTIONAL = 64;
    @Api
    public static final int FACE_SYSTEM = 0;
    @Api
    public static final int FONT_INPUT_TEXT = 1;
    @Api
    public static final int FONT_STATIC_TEXT = 0;
    @Api
    public static final int FONT_IDLE_TEXT = 2;
    @Api
    public static final int FONT_IDLE_HIGHLIGHTED_TEXT = 3;
    @Api
    public static final int SIZE_LARGE = 16;
    @Api
    public static final int SIZE_MEDIUM = 0;
    @Api
    public static final int SIZE_SMALL = 8;
    @Api
    public static final int STYLE_BOLD = 1;
    @Api
    public static final int STYLE_ITALIC = 2;
    @Api
    public static final int STYLE_PLAIN = 0;
    @Api
    public static final int STYLE_UNDERLINED = 4;
    private static final int _DEFAULT_FONT_SIZE = 12;
    private static Font[] _BUILTIN_FONTS;
    private static Font _DEFAULT_FONT;
    final PencilFontBracket _font;
    private final String _name;
    private final ScritchInterface _scritch;
    private final int _style;
    private final int _pixelsize;
    private final int _face;
    private int _height = -1;

    Font(ScritchInterface __scritch, PencilFontBracket __bracket) throws NullPointerException {
        if (__scritch == null || __bracket == null) {
            throw new NullPointerException("NARG");
        }
        this._scritch = __scritch;
        this._font = __bracket;
        this._name = PencilFontShelf.metricFontName(__bracket);
        int face = PencilFontShelf.metricFontFace(__bracket);
        this._face = (face & 1) != 0 ? 32 : 64;
        this._pixelsize = PencilFontShelf.metricPixelSize(__bracket);
        this._style = PencilFontShelf.metricFontStyle(__bracket);
    }

    @Api
    public int charWidth(char __c) {
        throw Debugging.todo();
    }

    @Api
    public int charsWidth(char[] __c, int __o, int __l) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __c.length) {
            throw new ArrayIndexOutOfBoundsException("IOOB");
        }
        throw Debugging.todo();
    }

    @Api
    public Font deriveFont(int __pixelSize) throws IllegalArgumentException {
        return this.deriveFont(this.getStyle(), __pixelSize);
    }

    @Api
    public Font deriveFont(int __style, int __pixelSize) throws IllegalArgumentException {
        if ((__style & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException(String.format("EB1t %d", __style));
        }
        if (__pixelSize == 0) {
            __pixelSize = FontUtilities.logicalSizeToPixelSize(0);
        } else if (__pixelSize < 0) {
            throw new IllegalArgumentException("EB1u");
        }
        if (this._style == __style && this._pixelsize == __pixelSize) {
            return this;
        }
        ScritchInterface scritch = this._scritch;
        return new Font(scritch, scritch.environment().fontDerive(this._font, __style, __pixelSize));
    }

    public boolean equals(Object __o) {
        if (__o == this) {
            return true;
        }
        if (!(__o instanceof Font)) {
            return false;
        }
        Font o2 = (Font)__o;
        return this._pixelsize == o2._pixelsize && this._style == o2._style && this._name.equals(o2._name) && PencilFontShelf.equals(this._font, o2._font);
    }

    @Api
    public int getAscent() {
        return PencilFontShelf.metricPixelAscent(this._font, false);
    }

    @Api
    public int getBaselinePosition() {
        return PencilFontShelf.metricPixelBaseline(this._font);
    }

    @Api
    public int getDescent() {
        return PencilFontShelf.metricPixelDescent(this._font, false);
    }

    @Api
    public int getFace() {
        return this._face;
    }

    @Api
    public String getFamily() {
        throw Debugging.todo();
    }

    @Api
    public String getFontName() {
        return this._name;
    }

    @Api
    public int getHeight() {
        int height = this._height;
        if (height == -1) {
            this._height = height = this.getLeading() + this.getAscent() + this.getDescent();
        }
        return height;
    }

    @Api
    public int getLeading() {
        return PencilFontShelf.metricPixelLeading(this._font);
    }

    @Api
    public int getMaxAscent() {
        throw Debugging.todo();
    }

    @Api
    public int getMaxDescent() {
        throw Debugging.todo();
    }

    @Api
    public int getPixelSize() {
        return this._pixelsize;
    }

    @Api
    public int getSize() {
        return FontUtilities.pixelSizeToLogicalSize(this._pixelsize);
    }

    @Api
    public int getStyle() {
        return this._style;
    }

    public int hashCode() {
        return this._name.hashCode() ^ this._style ^ this._pixelsize;
    }

    @Api
    public boolean isBold() {
        throw Debugging.todo();
    }

    @Api
    public boolean isItalic() {
        throw Debugging.todo();
    }

    @Api
    public boolean isPlain() {
        throw Debugging.todo();
    }

    @Api
    public boolean isUnderlined() {
        throw Debugging.todo();
    }

    @Api
    public int stringWidth(String __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        return this.substringWidth(__s, 0, __s.length());
    }

    @Api
    public int substringWidth(String __s, int __o, int __l) throws NullPointerException, StringIndexOutOfBoundsException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __s.length()) {
            throw new StringIndexOutOfBoundsException("IOOB");
        }
        PencilFontBracket font = this._font;
        int totalW = 0;
        int i2 = 0;
        int at2 = __o;
        while (i2 < __l) {
            char c2 = __s.charAt(at2);
            totalW += PencilFontShelf.pixelCharWidth(font, c2);
            ++i2;
            ++at2;
        }
        return totalW;
    }

    @Override
    @ApiStatus.Internal
    protected PencilFontBracket __squirreljmePencilFont() {
        return this._font;
    }

    @Api
    public static Font createFont(InputStream __data) throws IOException {
        throw Debugging.todo();
    }

    @Api
    public static Font[] getAvailableFonts() {
        Font[] rv = _BUILTIN_FONTS;
        if (rv != null) {
            return (Font[])rv.clone();
        }
        DisplayManager manager = DisplayManager.instance();
        ScritchInterface scritch = manager.scritch();
        PencilFontBracket[] builtin = scritch.environment().builtinFonts();
        int n2 = builtin.length;
        rv = new Font[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rv[i2] = new Font(scritch, builtin[i2]);
        }
        _BUILTIN_FONTS = rv;
        return (Font[])rv.clone();
    }

    @Api
    public static Font[] getAvailableFonts(int __style) throws IllegalArgumentException {
        if ((__style & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException(String.format("EB1v %d", __style));
        }
        ArrayList<Font> rv = new ArrayList<Font>();
        for (Font f2 : Font.getAvailableFonts()) {
            try {
                rv.add(f2.deriveFont(__style, f2.getPixelSize()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return rv.toArray(new Font[rv.size()]);
    }

    @Api
    public static Font[] getAvailableFonts(int __face, int __style, int __pxs) throws IllegalArgumentException {
        if ((__style & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException(String.format("EB1w %d", __style));
        }
        ArrayList<Font> rv = new ArrayList<Font>();
        for (Font f2 : Font.getAvailableFonts()) {
            if (f2.getFace() != __face) continue;
            try {
                rv.add(f2.deriveFont(__style, __pxs));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return rv.toArray(new Font[rv.size()]);
    }

    @Api
    public static Font getDefaultFont() {
        Font rv = _DEFAULT_FONT;
        if (rv != null) {
            return rv;
        }
        _DEFAULT_FONT = rv = Font.getAvailableFonts()[0];
        return rv;
    }

    @Api
    public static Font getFont(int __spec) throws IllegalArgumentException {
        if (__spec != 1 && __spec != 0 && __spec != 2 && __spec != 3) {
            throw new IllegalArgumentException("EB1x " + __spec);
        }
        return Font.getDefaultFont();
    }

    @Api
    public static Font getFont(int __face, int __style, int __size) throws IllegalArgumentException {
        if ((__face & 0xFFFFFF9F) != 0 || Integer.bitCount(__face) > 1) {
            throw new IllegalArgumentException(String.format("EB1y %d", __face));
        }
        if ((__size & 0xFFFFFFE7) != 0 || Integer.bitCount(__size) > 1) {
            throw new IllegalArgumentException(String.format("EB1z %d", __size));
        }
        Font[] scan = Font.getAvailableFonts(__face, __style, FontUtilities.logicalSizeToPixelSize(__size));
        if (scan.length == 0) {
            Font d2 = Font.getDefaultFont();
            try {
                return d2.deriveFont(__style, FontUtilities.logicalSizeToPixelSize(__size));
            }
            catch (IllegalArgumentException e2) {
                try {
                    return d2.deriveFont(__style, d2.getPixelSize());
                }
                catch (IllegalArgumentException f2) {
                    return d2;
                }
            }
        }
        return scan[0];
    }

    @Api
    public static Font getFont(String __name, int __style, int __pxs) throws IllegalArgumentException, NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        Font faceOnly = null;
        Font faceSize = null;
        Font name = null;
        Font any = null;
        int face = Font.__commonFace(__name);
        for (Font f2 : Font.getAvailableFonts()) {
            if (Font.__compatibleName(__name, f2.getFontName())) {
                if (f2.getPixelSize() == __pxs) {
                    return f2;
                }
                if (name == null) {
                    name = f2;
                    continue;
                }
                if (Math.abs(f2.getPixelSize() - __pxs) >= Math.abs(name.getPixelSize() - __pxs)) continue;
                name = f2;
                continue;
            }
            if (faceSize == null && f2.getFace() == face && f2.getPixelSize() == __pxs) {
                faceSize = f2;
                continue;
            }
            if (faceOnly == null && f2.getFace() == face) {
                faceOnly = f2;
                continue;
            }
            if (any != null) continue;
            any = f2;
        }
        if (name != null) {
            return name.deriveFont(__style, __pxs);
        }
        if (faceSize != null) {
            return faceSize.deriveFont(__style, __pxs);
        }
        if (faceOnly != null) {
            return faceOnly.deriveFont(__style, __pxs);
        }
        if (any != null) {
            return any.deriveFont(__style, __pxs);
        }
        throw new IllegalArgumentException(ErrorCode.__error__("EB20", __name, __style, __pxs));
    }

    @Api
    public static int getPixelSize(String __name) throws IllegalArgumentException, NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        for (Font f2 : Font.getAvailableFonts()) {
            if (!__name.equals(f2.getFontName())) continue;
            return f2.getPixelSize();
        }
        throw new IllegalArgumentException("EB21 " + __name);
    }

    @Api
    public static int getStyle(String __name) throws IllegalArgumentException, NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        for (Font f2 : Font.getAvailableFonts()) {
            if (!__name.equals(f2.getFontName())) continue;
            return f2.getStyle();
        }
        throw new IllegalArgumentException("EB2g " + __name);
    }

    private static int __commonFace(String __name) throws NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        if (__name.equalsIgnoreCase("Serif") || __name.equalsIgnoreCase("SansSerif") || __name.equalsIgnoreCase("Dialog") || __name.equalsIgnoreCase("DialogInput") || __name.equalsIgnoreCase("Helvetica") || __name.equalsIgnoreCase("Arial") || __name.equalsIgnoreCase("Times New Roman")) {
            return 64;
        }
        if (__name.equalsIgnoreCase("Monospace") || __name.equalsIgnoreCase("Monospaced") || __name.equalsIgnoreCase("Courier") || __name.equalsIgnoreCase("Courier New")) {
            return 32;
        }
        return -1;
    }

    private static boolean __compatibleName(String __want, String __font) throws NullPointerException {
        if (__want == null || __font == null) {
            throw new NullPointerException("NARG");
        }
        if (__want.equalsIgnoreCase(__font)) {
            return true;
        }
        int wantIs = -1;
        int fontIs = -2;
        for (int i2 = 0; i2 < 2; ++i2) {
            int is = -(i2 + 1);
            String with = i2 == 0 ? __want : __font;
            switch (with.toLowerCase()) {
                case "serif": 
                case "times new roman": {
                    is = 1;
                    break;
                }
                case "monospace": 
                case "monospaced": 
                case "courier": 
                case "courier new": {
                    is = 2;
                    break;
                }
                case "sansserif": 
                case "dialog": 
                case "dialoginput": 
                case "helvetica": 
                case "arial": {
                    is = 3;
                }
            }
            if (is <= 0) continue;
            if (i2 == 0) {
                wantIs = is;
                continue;
            }
            fontIs = is;
        }
        return wantIs == fontIs;
    }
}

