/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.lcdui.image.AccessibleImage;
import cc.squirreljme.runtime.lcdui.image.ImageReaderDispatcher;
import cc.squirreljme.runtime.lcdui.image.MIDPImageLoadHandler;
import cc.squirreljme.runtime.lcdui.mle.PencilGraphics;
import cc.squirreljme.runtime.midlet.ActiveMidlet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.AnimatedImage;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScalableImage;
import javax.microedition.lcdui.__ImageFactory__;

@Api
public class Image
extends AccessibleImage {
    private final int[] _data;
    private final int _width;
    private final int _height;
    private final boolean _mutable;
    private final boolean _alpha;

    Image() {
        throw Debugging.todo();
    }

    Image(int[] __data, int __w, int __h, boolean __mut, boolean __alpha) throws NullPointerException {
        this(__data, __data.length, __w, __h, __mut, __alpha);
    }

    Image(int[] __data, int __l, int __w, int __h, boolean __mut, boolean __alpha) throws IndexOutOfBoundsException, NullPointerException {
        if (__data == null) {
            throw new NullPointerException("NARG");
        }
        if (__l < 0 || __l > __data.length || __w * __h > __l) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        this._data = __data;
        this._width = __w;
        this._height = __h;
        this._mutable = __mut && !this.isAnimated() && !this.isScalable();
        this._alpha = __alpha;
        if (!__alpha) {
            int i2 = 0;
            int n2 = __data.length;
            while (i2 < n2) {
                int n3 = i2++;
                __data[n3] = __data[n3] | 0xFF000000;
            }
        }
    }

    @Api
    public final void getARGB16(short[] __data, int __off, int __scanlen, int __x, int __y, int __w, int __h) {
        throw Debugging.todo();
    }

    @Api
    public final Graphics getGraphics() throws IllegalStateException {
        if (!this.isMutable()) {
            throw new IllegalStateException("EB28");
        }
        return PencilGraphics.hardwareGraphics(this._alpha ? 0 : 1, this._width, this._height, this._data, null, 0, 0, this._width, this._height);
    }

    @Api
    public final int getHeight() {
        return this._height;
    }

    @Api
    public final void getRGB(int[] __b, int __o, int __sl, int __x, int __y, int __w, int __h) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (__w <= 0 || __h <= 0) {
            return;
        }
        if (this.isScalable()) {
            throw Debugging.todo();
        }
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__x < 0 || __y < 0) {
            throw new IllegalArgumentException("EB29");
        }
        int scanLen = Math.abs(__sl);
        if (scanLen < __w) {
            throw new IllegalArgumentException("EB2a");
        }
        int areaPix = __w * __h;
        int areaScan = __sl * __h;
        if (__o < 0 || __o + areaScan > __b.length || __o + areaScan < 0) {
            throw new ArrayIndexOutOfBoundsException("EB2b");
        }
        int ex = __x + __w;
        int ey = __y + __h;
        int iw = this._width;
        int ih = this._height;
        if (ex > iw || ey > ih) {
            throw new IllegalArgumentException(String.format("EB2c (%d, %d) <> (%d, %d)", ex, ey, iw, ih));
        }
        boolean alpha = this._alpha;
        int opaqueMask = this._alpha ? 0 : -16777216;
        int[] data = this._data;
        int dataOffset = 0;
        int sy = __y;
        int wy = 0;
        while (sy < ey) {
            int srcoff = dataOffset + iw * sy + __x;
            int dstoff = __o + wy * __sl;
            ObjectShelf.arrayCopy(data, srcoff, __b, dstoff, ex - __x);
            if (!alpha) {
                for (int sx = __x; sx < ex; ++sx) {
                    int n2 = dstoff++;
                    __b[n2] = __b[n2] | opaqueMask;
                }
            }
            ++sy;
            ++wy;
        }
    }

    @Api
    public final void getRGB16(short[] __data, int __off, int __scanlen, int __x, int __y, int __w, int __h) {
        throw Debugging.todo();
    }

    @Api
    public final int getWidth() {
        return this._width;
    }

    @Api
    public final boolean hasAlpha() {
        return this._alpha;
    }

    @Api
    public final boolean isAnimated() {
        return this instanceof AnimatedImage;
    }

    @Api
    public final boolean isMutable() {
        return this._mutable && !this.isAnimated() && !this.isScalable();
    }

    @Api
    public final boolean isScalable() {
        return this instanceof ScalableImage;
    }

    @Override
    public final int squirreljmeDirectOffset() {
        if (this.squirreljmeIsDirect()) {
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public final int[] squirreljmeDirectRGBInt() {
        if (this.squirreljmeIsDirect()) {
            return this._data;
        }
        return null;
    }

    @Override
    public final int squirreljmeDirectScanLen() {
        if (this.squirreljmeIsDirect()) {
            return this._width;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public final boolean squirreljmeIsDirect() {
        return !this.isScalable() && !this.isAnimated();
    }

    @Api
    public static Image createImage(byte[] __b, int __o, int __l) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        try {
            return Image.createImage(new ByteArrayInputStream(__b, __o, __l));
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("EB2d", e2);
        }
    }

    @Api
    public static Image createImage(int __w, int __h) throws IllegalArgumentException {
        return Image.createImage(__w, __h, false, 0xFFFFFF);
    }

    @Api
    public static Image createImage(int __w, int __h, boolean __alpha, int __c) throws IllegalArgumentException {
        if (__w <= 0 || __h <= 0) {
            throw new IllegalArgumentException("EB2e");
        }
        int area = __w * __h;
        int[] data = new int[area];
        if (__c != 0) {
            for (int i2 = 0; i2 < area; ++i2) {
                data[i2] = __c;
            }
        }
        return new Image(data, __w, __h, true, __alpha);
    }

    @Api
    public static Image createImage(InputStream __is) throws IOException, NullPointerException {
        if (__is == null) {
            throw new NullPointerException("NARG");
        }
        __ImageFactory__ factory = new __ImageFactory__();
        return (Image)new ImageReaderDispatcher(new MIDPImageLoadHandler(factory)).parse(__is);
    }

    @Api
    public static Image createImage(String __s) throws IOException, NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        try (InputStream is = ActiveMidlet.get().getClass().getResourceAsStream(__s);){
            if (is == null) {
                throw new IOException(String.format("EB2f %s", __s));
            }
            Image image = Image.createImage(is);
            return image;
        }
    }

    @Api
    public static Image createImage(Image __i) throws NullPointerException {
        if (__i == null) {
            throw new NullPointerException("NARG");
        }
        if (__i instanceof ScalableImage) {
            throw Debugging.todo();
        }
        if (!__i._mutable) {
            return __i;
        }
        return new Image((int[])__i._data.clone(), __i._width, __i._height, false, __i._alpha);
    }

    @Api
    public static Image createImage(Image __i, int __x, int __y, int __w, int __h, int __trans) {
        return Image.createImage(__i, __x, __y, __w, __h, __trans, __i.getWidth(), __i.getHeight());
    }

    @Api
    public static Image createImage(Image __i, int __x, int __y, int __w, int __h, int __trans, int __iw, int __ih) {
        throw Debugging.todo();
    }

    @Api
    public static Image createRGBImage(int[] __rgb, int __w, int __h, boolean __alpha) throws IllegalArgumentException, IndexOutOfBoundsException, NullPointerException {
        if (__rgb == null) {
            throw new NullPointerException("NARG");
        }
        int area = __w * __h;
        if (__w <= 0 || __h <= 0 || area <= 0) {
            throw new IllegalArgumentException(String.format("EB2g %d %d", __w, __h));
        }
        int rgbLen = __rgb.length;
        if (rgbLen < area) {
            throw new IndexOutOfBoundsException(String.format("EB2h %d < %d", rgbLen, area));
        }
        if (rgbLen == area) {
            __rgb = (int[])__rgb.clone();
        } else {
            int[] copy = new int[area];
            ObjectShelf.arrayCopy(__rgb, 0, copy, 0, area);
            __rgb = copy;
        }
        if (!__alpha) {
            int i2 = 0;
            while (i2 < area) {
                int n2 = i2++;
                __rgb[n2] = __rgb[n2] | 0xFF000000;
            }
        }
        return new Image(__rgb, __w, __h, false, __alpha);
    }
}

