/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.lcdui.common.TextStorage;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.__TextUndirtyState__;

@Api
public class Text {
    @Api
    public static final int ALIGN_CENTER = 1;
    @Api
    public static final int ALIGN_DEFAULT = 4;
    @Api
    public static final int ALIGN_JUSTIFY = 3;
    @Api
    public static final int ALIGN_LEFT = 0;
    @Api
    public static final int ALIGN_RIGHT = 2;
    @Api
    public static final int DIRECTION_LTR = 10;
    @Api
    public static final int DIRECTION_NEUTRAL = 12;
    @Api
    public static final int DIRECTION_RTL = 11;
    private final TextStorage _storage = new TextStorage();
    private int _width;
    private int _height;
    private Font _defaultfont = Font.getDefaultFont();
    private int _defaultcolor = -16777216;
    private int _backgroundcolor = 0xFFFFFF;
    private int _alignment;
    private int _caret = -1;
    private int _requiredheight;
    private int _requiredlines;
    private int _spaceabove;
    private int _spacebelow;
    private int _align;
    private int _indentation;
    private int _direction = 12;
    private int _scrolloffset;
    private int _highlightdx = -1;
    private int _highlightlen = 0;
    private boolean _dirty;

    @Api
    public Text() {
        this("", 0, 0);
    }

    @Api
    public Text(String __c, int __w, int __h) throws IllegalArgumentException, NullPointerException {
        this(__c, 0, __c.length(), __w, __h);
    }

    @Api
    public Text(String __c, int __o, int __l, int __w, int __h) throws IllegalArgumentException, IndexOutOfBoundsException, NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l > __c.length()) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        if (__w < 0 || __h < 0) {
            throw new IllegalArgumentException("EB2p");
        }
        this._width = __w;
        this._height = __h;
        this.insert(0, __c.substring(__o, __o + __l));
    }

    @Api
    public void delete(int __i, int __l) throws IndexOutOfBoundsException {
        this._storage.delete(__i, __l);
        if (__l <= 0) {
            return;
        }
        this._dirty = true;
        int caret = this._caret;
        if (caret > __i) {
            this._caret = caret - Math.max(__l - (caret - __i), __l);
        }
    }

    @Api
    public int getAlignment() {
        return this._alignment;
    }

    @Api
    public int getBackgroundColor() {
        return this._backgroundcolor;
    }

    @Api
    public int getCaret() {
        return this._caret;
    }

    @Api
    public void getCharExtent(int __i, int[] __ext) throws IllegalArgumentException, IndexOutOfBoundsException, NullPointerException {
        block6: {
            if (__ext == null) {
                throw new NullPointerException("NARG");
            }
            if (this._dirty) {
                this.__undirty();
            }
            TextStorage storage = this._storage;
            if (__i >= storage.size) {
                throw new IndexOutOfBoundsException("IOOB");
            }
            Font font = storage.font[__i];
            if (font == null) {
                font = this._defaultfont;
            }
            try {
                __ext[0] = storage.x[__i];
                __ext[1] = storage.y[__i];
                __ext[2] = font.charWidth(storage.chars[__i]);
                __ext[3] = font.getHeight();
            }
            catch (IndexOutOfBoundsException e2) {
                if (__ext.length >= 4) break block6;
                throw new IllegalArgumentException("EB2q");
            }
        }
    }

    @Api
    public int getCharIndex(int __x, int __y) {
        throw Debugging.todo();
    }

    @Api
    public Font getFont() {
        return this._defaultfont;
    }

    @Api
    public Font getFont(int __i) throws IndexOutOfBoundsException {
        TextStorage storage = this._storage;
        if (__i >= storage.size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        Font rv = storage.font[__i];
        if (rv != null) {
            return rv;
        }
        return this._defaultfont;
    }

    @Api
    public int getForegroundColor() {
        return this._defaultcolor;
    }

    @Api
    public int getForegroundColor(int __i) throws IndexOutOfBoundsException {
        TextStorage storage = this._storage;
        if (__i >= storage.size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int rv = storage.color[__i];
        if (rv != 0) {
            return rv;
        }
        return this._defaultcolor;
    }

    @Api
    public int getHeight() {
        return this._height;
    }

    @Api
    public int getHighlightIndex() {
        return this._highlightdx;
    }

    @Api
    public int getHighlightLength() {
        return this._highlightlen;
    }

    @Api
    public int getIndent() {
        return this._indentation;
    }

    @Api
    public int getInitialDirection() {
        return this._direction;
    }

    @Api
    public int getRequiredHeight() {
        if (this._dirty) {
            this.__undirty();
        }
        return this._requiredheight;
    }

    @Api
    public int getRequiredLineCount() {
        if (this._dirty) {
            this.__undirty();
        }
        return this._requiredlines;
    }

    @Api
    public int getScrollOffset() {
        return this._scrolloffset;
    }

    @Api
    public int getSpaceAbove() {
        return this._spaceabove;
    }

    @Api
    public int getSpaceBelow() {
        return this._spacebelow;
    }

    @Api
    public String getText(int __i, int __l) throws IndexOutOfBoundsException {
        TextStorage storage = this._storage;
        int size = storage.size;
        if (__i < 0 || __l < 0 || __i + __l > size) {
            throw new IndexOutOfBoundsException(String.format("EB2r %d %d %d", __i, __l, size));
        }
        return new String(storage.chars, __i, __l);
    }

    @Api
    public int getTextLength() {
        return this._storage.size;
    }

    @Api
    public int getWidth() {
        return this._width;
    }

    @Api
    public void insert(int __i, String __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        if (__s.isEmpty()) {
            return;
        }
        TextStorage storage = this._storage;
        if (__i < 0) {
            __i = 0;
        } else if (__i > storage.size) {
            __i = storage.size;
        }
        int sn = __s.length();
        storage.insert(__i, sn);
        char[] chars = storage.chars;
        for (int i2 = 0; i2 < sn; ++i2) {
            chars[__i++] = __s.charAt(i2);
        }
        int caret = this._caret;
        if (caret >= 0 && __i < caret) {
            this._caret = caret + sn;
        }
        this._dirty = true;
    }

    @Api
    public int lastRenderedIndex() {
        throw Debugging.todo();
    }

    @Api
    public void moveCaret(int __nl) {
        throw Debugging.todo();
    }

    @Api
    public void setAlignment(int __a) throws IllegalArgumentException {
        if (__a != 0 && __a != 1 && __a != 2 && __a != 3 && __a != 4) {
            throw new IllegalArgumentException("EB2s " + __a);
        }
        this._alignment = __a;
    }

    @Api
    public void setBackgroundColor(int __argb) {
        this._backgroundcolor = __argb;
    }

    @Api
    public void setCaret(int __i) throws IndexOutOfBoundsException {
        if (__i == -1) {
            this._caret = -1;
            return;
        }
        throw Debugging.todo();
    }

    @Api
    public void setFont(Font __f) throws NullPointerException {
        if (__f == null) {
            throw new NullPointerException("NARG");
        }
        Font olddefaultfont = this._defaultfont;
        if (__f.equals(olddefaultfont)) {
            return;
        }
        this._defaultfont = __f;
        this._dirty = true;
    }

    @Api
    public void setFont(Font __f, int __i, int __l) {
        TextStorage storage = this._storage;
        int size = storage.size;
        if (__i < 0 || __l < 0 || __i >= size || __i + __l > size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        Font[] font = storage.font;
        for (int i2 = 0; i2 < __l; ++i2) {
            font[__i++] = __f;
        }
        this._dirty = true;
    }

    @Api
    public void setForegroundColor(int __argb) {
        this._defaultcolor = __argb;
    }

    @Api
    public void setForegroundColor(int __argb, int __i, int __l) {
        TextStorage storage = this._storage;
        int size = storage.size;
        if (__i < 0 || __l < 0 || __i >= size || __i + __l > size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int[] color = storage.color;
        for (int i2 = 0; i2 < __l; ++i2) {
            color[__i++] = __argb;
        }
        this._dirty = true;
    }

    @Api
    public void setHeight(int __h) throws IllegalArgumentException {
        if (__h < 0) {
            throw new IllegalArgumentException("EB2t");
        }
        this._height = __h;
    }

    @Api
    public void setHighlight(int __i, int __l) throws IndexOutOfBoundsException {
        if (__i == -1) {
            this._highlightdx = -1;
            this._highlightlen = 0;
            return;
        }
        throw Debugging.todo();
    }

    @Api
    public void setIndent(int __i) {
        this._indentation = __i;
    }

    @Api
    public void setInitialDirection(int __dir) throws IllegalArgumentException {
        if (__dir != 10 && __dir != 11 && __dir != 12) {
            throw new IllegalArgumentException("EB2u " + __dir);
        }
        this._direction = __dir;
    }

    @Api
    public void setScrollOffset(int __o) {
        this._scrolloffset = __o;
    }

    @Api
    public void setSpaceAbove(int __sa) {
        this._spaceabove = __sa;
    }

    @Api
    public void setSpaceBelow(int __sb) {
        this._spacebelow = __sb;
    }

    @Api
    public void setWidth(int __w) throws IllegalArgumentException {
        if (__w < 0) {
            throw new IllegalArgumentException("EB2v");
        }
        int oldwidth = this._width;
        if (__w == oldwidth) {
            return;
        }
        this._width = __w;
        this._dirty = true;
    }

    @Api
    public boolean textFits() {
        if (this._dirty) {
            this.__undirty();
        }
        return this._requiredheight <= this._height;
    }

    private void __undirty() {
        int x2;
        int y2;
        if (!this._dirty) {
            return;
        }
        __TextUndirtyState__ ts = new __TextUndirtyState__();
        ts.defaultfont = this._defaultfont;
        ts.width = this._width;
        ts.spaceabove = this._spaceabove;
        ts.spacebelow = this._spacebelow;
        ts.align = this._align;
        ts.indentation = this._indentation;
        ts.direction = this._direction;
        ts.scrolloffset = this._scrolloffset;
        if (ts.direction == 12) {
            ts.direction = 10;
        }
        boolean dortl = ts.direction == 11;
        TextStorage storage = this._storage;
        char[] chars = storage.chars;
        Font[] font = storage.font;
        short[] cx2 = storage.x;
        short[] cy2 = storage.y;
        int nexty = y2 = -ts.scrolloffset + ts.spaceabove;
        int startx = x2 = dortl ? ts.width : ts.indentation;
        Font lastfont = null;
        int fontheight = 0;
        int fontascent = 0;
        int fontdescent = 0;
        int linedxstart = 0;
        int linedxend = 0;
        boolean redo = false;
        int linecount = 0;
        int linemaxheight = 0;
        int linemaxascent = 0;
        int linemaxdescent = 0;
        int n2 = storage.size;
        for (int i2 = 0; i2 <= n2; ++i2) {
            boolean donextline = i2 == n2;
            boolean wasnewlinech = false;
            if (!donextline) {
                char ch2 = chars[i2];
                Font f2 = font[i2];
                if (f2 == null) {
                    f2 = ts.defaultfont;
                }
                if (lastfont != f2) {
                    fontheight = f2.getHeight();
                    fontascent = f2.getAscent();
                    fontdescent = f2.getDescent();
                    lastfont = f2;
                    if (fontascent > linemaxascent) {
                        linemaxascent = fontascent;
                    }
                    if (fontheight > linemaxheight) {
                        linemaxheight = fontheight;
                    }
                    if (fontdescent > linemaxdescent) {
                        linemaxdescent = fontdescent;
                    }
                }
                if (ch2 == '\r') continue;
                if (ch2 == '\n') {
                    donextline = true;
                    wasnewlinech = true;
                    redo = false;
                } else {
                    int nx;
                    int dx;
                    int chw = f2.charWidth(ch2);
                    if (dortl) {
                        nx = dx = x2 - chw;
                    } else {
                        dx = x2;
                        nx = x2 + chw;
                    }
                    if (nx >= 0 && nx <= ts.width || x2 <= startx && x2 + chw <= ts.width) {
                        cx2[i2] = (short)dx;
                        x2 = nx;
                        cy2[i2] = (short)fontascent;
                        redo = false;
                    } else {
                        if (redo) {
                            redo = false;
                            continue;
                        }
                        donextline = true;
                        redo = true;
                    }
                }
            }
            if (!donextline) continue;
            linedxend = i2;
            nexty = y2 + linemaxheight + ts.spacebelow + (wasnewlinech ? ts.spaceabove : 0);
            for (int q2 = linedxstart; q2 < linedxend; ++q2) {
                short origascent = cy2[q2];
                cy2[q2] = (short)(y2 + (linemaxascent - origascent));
            }
            if (dortl && ts.align != 2 || !dortl && ts.align != 0) {
                throw Debugging.todo();
            }
            ++linecount;
            if (redo) {
                --i2;
            }
            linedxstart = i2 + 1;
            y2 = nexty;
            x2 = startx;
        }
        this._requiredheight = nexty;
        this._requiredlines = linecount;
        this._dirty = false;
    }
}

