/*
 * Decompiled with CFR 0.152.
 */
package lombok.launch;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import lombok.launch.ClassFileMetaData;

class PackageShader {
    private final byte[][] froms;
    private final byte[][] tos;
    private static final byte CONSTANTPOOLTYPE_UTF8 = 1;

    public PackageShader(String ... shadeOps) {
        if (shadeOps.length % 2 != 0) {
            throw new IllegalArgumentException("Provide pairs: real package name to shaded package name (you provided an odd number of strings; even number required)");
        }
        Charset ascii = Charset.forName("US-ASCII");
        int len = shadeOps.length / 2;
        this.froms = new byte[len][];
        this.tos = new byte[len][];
        int i2 = 0;
        while (i2 < len) {
            String in = shadeOps[i2 << 1];
            String out = shadeOps[i2 << 1 | 1];
            if (in.contains(".") || out.contains(".")) {
                throw new IllegalArgumentException("Binary name prefixes are required (use slashes and dollars instead of dots to separate type name elements); they look like e.g. 'java/util/'. Violating entry: " + in + " -> " + out);
            }
            this.froms[i2] = in.getBytes(ascii);
            this.tos[i2] = out.getBytes(ascii);
            if (this.froms[i2].length != this.tos[i2].length) {
                throw new IllegalArgumentException("Pair [" + in + " -> " + out + "] is invalid: Both strings must be the same length");
            }
            ++i2;
        }
    }

    public boolean apply(byte[] b2) {
        ClassFileMetaData md = new ClassFileMetaData(b2);
        boolean changes = false;
        int[] startPoints = new int[260];
        int[] nArray = md.getOffsets((byte)1);
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int offset = nArray[n3];
            int len = PackageShader.readValue(b2, offset);
            startPoints[0] = offset += 2;
            int maxStartPoints = 1;
            int i2 = offset;
            int max = offset + len;
            while (i2 < max) {
                if (b2[i2] == 76) {
                    startPoints[maxStartPoints++] = i2 + 1;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.froms.length) {
                int startPointIdx = 0;
                while (startPointIdx < maxStartPoints) {
                    block8: {
                        int indexIntoSignature = startPoints[startPointIdx];
                        if (len - (indexIntoSignature - offset) >= this.froms[i2].length) {
                            int p2 = 0;
                            while (p2 < this.froms[i2].length) {
                                if (b2[indexIntoSignature + p2] == this.froms[i2][p2]) {
                                    ++p2;
                                    continue;
                                }
                                break block8;
                            }
                            System.arraycopy(this.tos[i2], 0, b2, indexIntoSignature, this.tos[i2].length);
                            changes = true;
                        }
                    }
                    ++startPointIdx;
                }
                ++i2;
            }
            ++n3;
        }
        return changes;
    }

    private static int readValue(byte[] b2, int position) {
        return (b2[position] & 0xFF) << 8 | b2[position + 1] & 0xFF;
    }

    public String reverseResourceName(String name) {
        int i2 = 0;
        while (i2 < this.tos.length) {
            block6: {
                int len = this.tos[i2].length;
                if (name.length() >= len) {
                    int p2 = 0;
                    while (p2 < len) {
                        if (name.charAt(p2) == this.tos[i2][p2]) {
                            ++p2;
                            continue;
                        }
                        break block6;
                    }
                    try {
                        String out = String.valueOf(new String(this.froms[i2], 0, this.froms[i2].length, "US-ASCII")) + name.substring(len);
                        return out;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return name;
                    }
                }
            }
            ++i2;
        }
        return name;
    }
}

