/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.debug.ErrorCode;
import cc.squirreljme.runtime.cldc.util.IntegerArrayList;
import cc.squirreljme.runtime.cldc.util.SortedTreeMap;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.multiphasicapps.classfile.Attribute;
import net.multiphasicapps.classfile.AttributeTable;
import net.multiphasicapps.classfile.ByteCodeUtils;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.ConstantValue;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.ExceptionHandlerTable;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.FieldReference;
import net.multiphasicapps.classfile.Instruction;
import net.multiphasicapps.classfile.InstructionJumpTarget;
import net.multiphasicapps.classfile.InstructionJumpTargets;
import net.multiphasicapps.classfile.InstructionMnemonics;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.JavaStackShuffleType;
import net.multiphasicapps.classfile.JavaType;
import net.multiphasicapps.classfile.LocalVariableTable;
import net.multiphasicapps.classfile.Method;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodFlags;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.MethodReference;
import net.multiphasicapps.classfile.Pool;
import net.multiphasicapps.classfile.PrimitiveType;
import net.multiphasicapps.classfile.StackMapTable;
import net.multiphasicapps.classfile.StackMapTableEntry;
import net.multiphasicapps.classfile.StackMapTablePairs;
import net.multiphasicapps.classfile.StackMapTableState;
import net.multiphasicapps.classfile.__StackMapParser__;

public final class ByteCode
implements Contexual,
Iterable<Instruction> {
    public static final int CODE_OFFSET = 8;
    private static final int _MAX_CODE_LENGTH = 65535;
    protected final int maxstack;
    protected final int maxlocals;
    protected final int codelen;
    protected final Pool pool;
    protected final ExceptionHandlerTable exceptions;
    protected final ClassName thistype;
    protected final MethodName methodname;
    protected final MethodDescriptor methodtype;
    protected final boolean issynchronized;
    protected final boolean isinstance;
    protected final LocalVariableTable localVariables;
    private final byte[] _rawByteCode;
    private final byte[] _smtdata;
    private final boolean _newsmtdata;
    private final Reference<Method> _methodref;
    private final int[] _lengths;
    private final int[] _index;
    private final short[] _linenumbertable;
    private final Reference<Instruction>[] _icache;
    private Reference<String> _string;
    private Reference<StackMapTable> _smt;
    private Reference<StackMapTablePairs> _stackMapRunTime;

    ByteCode(Reference<Method> __mr, byte[] __ca, ClassName __tt, MethodFlags __mf) throws InvalidClassFormatException, NullPointerException {
        if (__mr == null || __ca == null || __tt == null || __mf == null) {
            throw new NullPointerException("NARG");
        }
        Method method = __mr.get();
        this._methodref = __mr;
        this._rawByteCode = __ca;
        this.issynchronized = __mf.isSynchronized();
        this.isinstance = !__mf.isStatic();
        this.methodname = method.name();
        this.methodtype = method.type();
        Pool pool = method.pool();
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(__ca));){
            int i2;
            int maxStack = in.readUnsignedShort();
            int maxLocals = in.readUnsignedShort();
            int codeLen = in.readInt();
            if (codeLen <= 0 || codeLen > 65535) {
                throw new InvalidClassFormatException(String.format("JC1y %d", codeLen), this);
            }
            for (int i3 = 0; i3 < codeLen; ++i3) {
                in.readByte();
            }
            ExceptionHandlerTable eht = ExceptionHandlerTable.decode(in, pool, codeLen);
            int[] index = new int[codeLen];
            int indexat = 0;
            int[] lengths = new int[codeLen];
            for (i2 = 0; i2 < codeLen; ++i2) {
                lengths[i2] = -1;
            }
            i2 = 0;
            int li = -1;
            while (i2 < codeLen) {
                int opLen;
                index[indexat++] = i2;
                lengths[i2] = opLen = ByteCodeUtils.instructionLength(__ca, 8, i2, null);
                if ((i2 += opLen) > codeLen) {
                    throw new InvalidClassFormatException(String.format("JC1z %d %d %d %d", i2, opLen, codeLen, li), this);
                }
                li = i2;
            }
            byte[] smt = null;
            boolean smtnew = false;
            AttributeTable attrs = AttributeTable.parse(pool, in);
            Attribute attr = attrs.get("StackMapTable");
            if (attr != null) {
                smt = attr.bytes();
                smtnew = true;
            } else {
                attr = attrs.get("StackMap");
                if (attr != null) {
                    smt = attr.bytes();
                    smtnew = false;
                }
            }
            if (smt == null) {
                smt = new byte[2];
                smtnew = true;
            }
            short[] lnt = new short[codeLen];
            for (int i4 = 0; i4 < codeLen; ++i4) {
                lnt[i4] = -1;
            }
            attr = attrs.get("LineNumberTable");
            if (attr != null) {
                try (DataInputStream ai2 = attr.open();){
                    int n2 = ai2.readUnsignedShort();
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int pc = ai2.readUnsignedShort();
                        int line = ai2.readUnsignedShort();
                        if (pc < 0 || pc >= codeLen) continue;
                        lnt[pc] = (short)line;
                    }
                }
            }
            LocalVariableTable localVariables = LocalVariableTable.parse(pool, attrs);
            this.maxstack = maxStack;
            this.maxlocals = maxLocals;
            this.codelen = codeLen;
            this.exceptions = eht;
            this.pool = pool;
            this.thistype = __tt;
            this._smtdata = smt;
            this._newsmtdata = smtnew;
            this._lengths = lengths;
            this._icache = ByteCode.__newCache(codeLen);
            this._linenumbertable = lnt;
            this.localVariables = localVariables;
            this._index = indexat == codeLen ? index : Arrays.copyOf(index, indexat);
        }
        catch (IOException e2) {
            throw new InvalidClassFormatException("JC20", e2, this);
        }
    }

    public int addressFollowing(int __a) throws InvalidClassFormatException {
        if (!this.isValidAddress(__a)) {
            throw new InvalidClassFormatException(String.format("JC21 %d", __a), this);
        }
        int result = __a + this._lengths[__a];
        if (result >= this._lengths.length) {
            return this._lengths.length;
        }
        return result;
    }

    public int addressToIndex(int __a) {
        int[] index = this._index;
        if (__a == this.codelen) {
            return index.length;
        }
        int rv = Arrays.binarySearch(index, __a);
        if (rv < 0) {
            return -1;
        }
        return rv;
    }

    public final ExceptionHandlerTable exceptions() {
        return this.exceptions;
    }

    public Instruction getByAddress(int __a) throws InvalidClassFormatException {
        Instruction rv;
        if (!this.isValidAddress(__a)) {
            Reference<Instruction>[] iCache = this._icache;
            int numCache = iCache.length;
            Instruction[] cache = new Instruction[numCache];
            for (int i2 = 0; i2 < numCache; ++i2) {
                if (i2 == __a || iCache[i2] != null || !this.isValidAddress(i2)) {
                    cache[i2] = iCache[i2] != null ? iCache[i2].get() : null;
                    continue;
                }
                try {
                    cache[i2] = this.getByAddress(i2);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new InvalidClassFormatException(ErrorCode.__error__("JC22", __a, this.__method().inClass(), this.methodname, this.methodtype, new IntegerArrayList(this._lengths), new IntegerArrayList(this._index), Arrays.asList(cache)), this);
        }
        Reference<Instruction>[] icache = this._icache;
        Reference<Instruction> ref = icache[__a];
        if (ref == null || null == (rv = ref.get())) {
            rv = new Instruction(this._rawByteCode, this.pool, __a, this.exceptions, this.stackMapTable(), this.addressFollowing(__a), this.addressToIndex(__a));
            icache[__a] = new WeakReference<Instruction>(rv);
        }
        return rv;
    }

    public Instruction getByIndex(int __i) throws IndexOutOfBoundsException {
        int[] index = this._index;
        if (__i < 0 || __i >= index.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        return this.getByAddress(index[__i]);
    }

    public int indexToAddress(int __i) {
        int[] index = this._index;
        int n2 = index.length;
        if (__i == n2) {
            return this.codelen;
        }
        if (__i < 0 || __i >= n2) {
            return -1;
        }
        return index[__i];
    }

    public int instructionCount() {
        return this._index.length;
    }

    public Iterator<Instruction> instructionIterator() {
        return new __InstructionIterator__();
    }

    public final boolean isInstance() {
        return this.isinstance;
    }

    public final boolean isInstanceInitializer() {
        return this.methodname.isInstanceInitializer();
    }

    public final boolean isStaticInitializer() {
        return this.methodname.isStaticInitializer();
    }

    public final boolean isSynchronized() {
        return this.issynchronized;
    }

    public boolean isValidAddress(int __a) {
        if (__a < 0 || __a >= this.codelen) {
            return false;
        }
        return this._lengths[__a] > 0;
    }

    @Override
    public final Iterator<Instruction> iterator() {
        return this.instructionIterator();
    }

    public final Map<Integer, InstructionJumpTargets> jumpTargets() {
        LinkedHashMap<Integer, InstructionJumpTargets> rv = new LinkedHashMap<Integer, InstructionJumpTargets>();
        for (Instruction i2 : this) {
            rv.put(i2.address(), i2.jumpTargets());
        }
        return rv;
    }

    public int length() {
        return this.codelen;
    }

    public final int lineOfAddress(int __a) {
        int codelen = this.codelen;
        short[] linenumbertable = this._linenumbertable;
        int negscandx = __a;
        for (int pc = __a; pc >= 0 && pc < codelen; --pc) {
            short clip = linenumbertable[pc];
            if (clip == -1) continue;
            while (negscandx > pc) {
                linenumbertable[negscandx--] = clip;
            }
            return clip & 0xFFFF;
        }
        return -1;
    }

    public LocalVariableTable localVariables() {
        return this.localVariables;
    }

    public int maxLocals() {
        return this.maxlocals;
    }

    public int maxStack() {
        return this.maxstack;
    }

    public final MethodName name() {
        return this.methodname;
    }

    public Pool pool() {
        return this.pool;
    }

    public byte[] rawByteCode() {
        byte[] rawCode = this._rawByteCode;
        int rawLen = rawCode.length;
        int len = Math.min(rawLen - 8, this.codelen);
        byte[] result = new byte[len];
        ObjectShelf.arrayCopy(rawCode, 8, result, 0, len);
        return result;
    }

    public final int readRawCodeUnsignedShort(int __addr) throws IndexOutOfBoundsException {
        if (__addr < 0 || __addr >= this.codelen - 1) {
            throw new IndexOutOfBoundsException(String.format("JC23 %d", __addr));
        }
        byte[] rad = this._rawByteCode;
        int d2 = __addr + 8;
        return (rad[d2] & 0xFF) << 8 | rad[d2 + 1] & 0xFF;
    }

    public final Map<Integer, InstructionJumpTargets> reverseJumpTargets() {
        Map<Integer, InstructionJumpTargets> jumpmap = this.jumpTargets();
        class Working {
            Set<InstructionJumpTarget> normal = new LinkedHashSet<InstructionJumpTarget>();
            Set<InstructionJumpTarget> exception = new LinkedHashSet<InstructionJumpTarget>();

            Working() {
            }
        }
        LinkedHashMap<Integer, Working> works = new LinkedHashMap<Integer, Working>();
        for (Map.Entry<Integer, InstructionJumpTargets> e2 : jumpmap.entrySet()) {
            InstructionJumpTarget addr = new InstructionJumpTarget(e2.getKey());
            InstructionJumpTargets jumps = e2.getValue();
            int n2 = jumps.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int targ = jumps.get(i2).target();
                boolean isex = jumps.isException(i2);
                Working work = (Working)works.get(targ);
                if (work == null) {
                    work = new Working();
                    works.put(targ, work);
                }
                if (isex) {
                    work.exception.add(addr);
                    continue;
                }
                work.normal.add(addr);
            }
        }
        LinkedHashMap<Integer, InstructionJumpTargets> rv = new LinkedHashMap<Integer, InstructionJumpTargets>();
        for (Map.Entry e3 : works.entrySet()) {
            Working work = (Working)e3.getValue();
            Set<InstructionJumpTarget> nrm = work.normal;
            Set<InstructionJumpTarget> exe = work.exception;
            rv.put((Integer)e3.getKey(), new InstructionJumpTargets(nrm.toArray(new InstructionJumpTarget[nrm.size()]), exe.toArray(new InstructionJumpTarget[exe.size()])));
        }
        return rv;
    }

    public StackMapTable stackMapTable() {
        StackMapTable rv;
        Reference<StackMapTable> ref = this._smt;
        if (ref == null || null == (rv = ref.get())) {
            rv = new __StackMapParser__(this.pool, this.__method(), this._newsmtdata, this._smtdata, this, new JavaType(this.thistype)).get();
            this._smt = new WeakReference<StackMapTable>(rv);
        }
        return rv;
    }

    public StackMapTablePairs stackMapTableFull() {
        StackMapTablePairs rv;
        Reference<StackMapTablePairs> ref = this._stackMapRunTime;
        if (ref == null || (rv = ref.get()) == null) {
            try {
                rv = this.__calcStackMapTableFull();
                this._stackMapRunTime = new WeakReference<StackMapTablePairs>(rv);
            }
            catch (InvalidClassFormatException __e) {
                Method method = this.__method();
                throw new InvalidClassFormatException(String.format("JC9a %s %s", method.inClass(), method.nameAndType()), __e, this);
            }
        }
        return rv;
    }

    public final ClassName thisType() {
        return this.thistype;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            StringBuilder sb = new StringBuilder("[");
            boolean comma = false;
            Iterator<Instruction> it = this.instructionIterator();
            while (it.hasNext()) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(it.next());
            }
            sb.append(']');
            rv = sb.toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public final MethodDescriptor type() {
        return this.methodtype;
    }

    public final int[] validAddresses() {
        return (int[])this._index.clone();
    }

    public final int[] writtenLocals() {
        LinkedHashSet<Integer> written = new LinkedHashSet<Integer>();
        block9: for (Instruction inst : this) {
            int hit;
            boolean wide = false;
            int op = inst.operation();
            switch (op) {
                case 54: 
                case 56: 
                case 58: 
                case 132: 
                case 50230: 
                case 50232: 
                case 50234: 
                case 50308: {
                    hit = inst.intArgument(0);
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    hit = op - 75;
                    break;
                }
                case 55: 
                case 57: 
                case 50231: 
                case 50233: {
                    hit = inst.intArgument(0);
                    wide = true;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    hit = op - 71;
                    wide = true;
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    hit = op - 67;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    hit = op - 59;
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    hit = op - 63;
                    wide = true;
                    break;
                }
                default: {
                    continue block9;
                }
            }
            written.add(hit);
            if (!wide) continue;
            written.add(hit + 1);
        }
        Integer[] from = written.toArray(new Integer[written.size()]);
        int n2 = from.length;
        int[] rv = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rv[i2] = from[i2];
        }
        return rv;
    }

    private StackMapTablePairs __calcStackMapTableFull() {
        StackMapTable base = this.stackMapTable();
        SortedTreeMap<Integer, StackMapTableState> inputs = new SortedTreeMap<Integer, StackMapTableState>();
        SortedTreeMap<Integer, StackMapTableState> outputs = new SortedTreeMap<Integer, StackMapTableState>();
        ArrayList<StackMapTableEntry> popped = new ArrayList<StackMapTableEntry>();
        StackMapTableState current = null;
        int numAddrs = this.instructionCount();
        for (int logicalAddr = 0; logicalAddr < numAddrs; ++logicalAddr) {
            int actualAddr = this.indexToAddress(logicalAddr);
            Instruction instruction = this.getByIndex(logicalAddr).normalize();
            popped.clear();
            if (inputs.containsKey(actualAddr)) {
                current = (StackMapTableState)inputs.get(actualAddr);
            } else {
                StackMapTableState exist = instruction.stackMapTableState();
                if (exist != null) {
                    current = exist;
                    inputs.put(actualAddr, current);
                }
            }
            StackMapTableState input = current;
            if (current == null) {
                throw Debugging.oops();
            }
            if (!inputs.containsKey(actualAddr)) {
                inputs.put(actualAddr, current);
            }
            try {
                int op = instruction.op;
                switch (op) {
                    case 0: 
                    case 167: 
                    case 177: 
                    case 200: 
                    case 50308: {
                        break;
                    }
                    case 1: {
                        current = current.deriveStackPush(StackMapTableEntry.INITIALIZED_OBJECT);
                        break;
                    }
                    case 50197: 
                    case 50198: 
                    case 50199: 
                    case 50200: 
                    case 50201: {
                        current = current.deriveLocalLoad(instruction.intArgument(0));
                        break;
                    }
                    case 50230: 
                    case 50231: 
                    case 50232: 
                    case 50233: 
                    case 50234: {
                        current = current.deriveLocalStore(instruction.intArgument(0));
                        break;
                    }
                    case 18: 
                    case 19: 
                    case 20: {
                        current = current.deriveStackPush(ByteCode.__deriveLdc(instruction));
                        break;
                    }
                    case 50: {
                        current = current.deriveStackPop(popped, 2);
                        current = current.deriveStackPush(ByteCode.__deriveComponentType((StackMapTableEntry)popped.get(0)));
                        break;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: {
                        current = current.deriveStackPop(popped, 2);
                        current = current.deriveStackPush(ByteCode.__deriveComponentTypeViaOp(op));
                        break;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        current = current.deriveStackPop(null, 3);
                        break;
                    }
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        current = current.deriveStackShuffle(JavaStackShuffleType.ofOperation(op));
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: {
                        current = current.deriveStackPop(popped, 2);
                        current = current.deriveStackPush((StackMapTableEntry)popped.get(0));
                        break;
                    }
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 192: {
                        current = current.deriveStackPop(popped, 1);
                        current = current.deriveStackPush((StackMapTableEntry)popped.get(0));
                        break;
                    }
                    case 136: 
                    case 139: 
                    case 142: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 193: {
                        current = current.deriveStackPop(popped, 1);
                        current = current.deriveStackPush(StackMapTableEntry.INTEGER);
                        break;
                    }
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: {
                        current = current.deriveStackPop(popped, 2);
                        current = current.deriveStackPush(StackMapTableEntry.INTEGER);
                        break;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 179: 
                    case 191: 
                    case 194: 
                    case 195: 
                    case 198: 
                    case 199: {
                        current = current.deriveStackPop(popped, 1);
                        break;
                    }
                    case 190: {
                        current = current.deriveStackPopThenPush(popped, 1, StackMapTableEntry.INTEGER);
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 181: {
                        current = current.deriveStackPop(popped, 2);
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        current = current.deriveMethodCall(op == 184, instruction.argument(0, MethodReference.class));
                        break;
                    }
                    case 133: 
                    case 140: 
                    case 143: {
                        current = current.deriveStackPop(popped, 1);
                        current = current.deriveStackPush(StackMapTableEntry.LONG);
                        break;
                    }
                    case 134: 
                    case 137: 
                    case 144: {
                        current = current.deriveStackPop(popped, 1);
                        current = current.deriveStackPush(StackMapTableEntry.FLOAT);
                        break;
                    }
                    case 135: 
                    case 138: 
                    case 141: {
                        current = current.deriveStackPop(popped, 1);
                        current = current.deriveStackPush(StackMapTableEntry.DOUBLE);
                        break;
                    }
                    case 187: {
                        current = current.deriveStackPush(instruction.argument(0, ClassName.class).field());
                        break;
                    }
                    case 189: {
                        current = current.deriveStackPop(null, 1);
                        current = current.deriveStackPush(instruction.argument(0, ClassName.class).field().addDimensions(1));
                        break;
                    }
                    case 188: {
                        current = current.deriveStackPop(null, 1);
                        current = current.deriveStackPush(instruction.argument(0, PrimitiveType.class).field().addDimensions(1));
                        break;
                    }
                    case 197: {
                        current = current.deriveStackPop(null, instruction.intArgument(1));
                        current = current.deriveStackPush(instruction.argument(0, ClassName.class).field().addDimensions(instruction.intArgument(1)));
                        break;
                    }
                    case 178: {
                        current = current.deriveStackPush(instruction.argument(0, FieldReference.class).memberType());
                        break;
                    }
                    case 180: {
                        current = current.deriveStackPop(null, 1);
                        current = current.deriveStackPush(instruction.argument(0, FieldReference.class).memberType());
                        break;
                    }
                    default: {
                        throw Debugging.todo(InstructionMnemonics.toString(op));
                    }
                }
            }
            catch (IllegalArgumentException | IllegalStateException | InvalidClassFormatException __e) {
                throw new InvalidClassFormatException(String.format("JC9b %s L#%d %s ?(%s)?", instruction, this.lineOfAddress(instruction.address()), input, current), __e, this);
            }
            if (!outputs.containsKey(actualAddr)) {
                outputs.put(actualAddr, current);
            }
            InstructionJumpTargets jumps = instruction.jumpTargets();
            int n2 = jumps.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                InstructionJumpTarget jump = jumps.get(i2);
                boolean isException = jumps.isException(i2);
                if (inputs.containsKey(jump.target) || isException) continue;
                inputs.put(jump.target, current);
            }
        }
        return new StackMapTablePairs(inputs, outputs);
    }

    private Method __method() {
        Method rv = this._methodref.get();
        if (rv == null) {
            throw new IllegalStateException("JC24");
        }
        return rv;
    }

    private static StackMapTableEntry __deriveComponentType(StackMapTableEntry __entry) throws NullPointerException {
        if (__entry == null) {
            throw new NullPointerException("NARG");
        }
        FieldDescriptor type = __entry.type().type().componentType();
        if (type == null) {
            return StackMapTableEntry.INITIALIZED_OBJECT;
        }
        if (type.isPrimitive()) {
            switch (type.primitiveType()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case CHARACTER: {
                    type = FieldDescriptor.INTEGER;
                }
            }
        }
        return new StackMapTableEntry(type, true);
    }

    private static StackMapTableEntry __deriveComponentTypeViaOp(int __op) throws InvalidClassFormatException {
        switch (__op) {
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                return StackMapTableEntry.INTEGER;
            }
            case 47: {
                return StackMapTableEntry.LONG;
            }
            case 48: {
                return StackMapTableEntry.FLOAT;
            }
            case 49: {
                return StackMapTableEntry.DOUBLE;
            }
        }
        throw new InvalidClassFormatException(String.format("JCl1 %s", InstructionMnemonics.toString(__op)));
    }

    private static FieldDescriptor __deriveLdc(Instruction __instruction) throws NullPointerException {
        if (__instruction == null) {
            throw new NullPointerException("NARG");
        }
        return __instruction.argument((int)0, ConstantValue.class).type.javaType().type;
    }

    private static Reference<Instruction>[] __newCache(int __l) {
        return new Reference[__l];
    }

    private final class __InstructionIterator__
    implements Iterator<Instruction> {
        protected final int codelen;
        private int _at;

        private __InstructionIterator__() {
            this.codelen = ByteCode.this.codelen;
        }

        @Override
        public boolean hasNext() {
            return this._at < this.codelen;
        }

        @Override
        public Instruction next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("NSEE");
            }
            int at2 = this._at;
            Instruction rv = ByteCode.this.getByAddress(at2);
            this._at += ByteCode.this._lengths[at2];
            return rv;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("RORO");
        }
    }
}

