/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.IntegerList;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.ConstantValue;
import net.multiphasicapps.classfile.ConstantValueClass;
import net.multiphasicapps.classfile.FieldReference;
import net.multiphasicapps.classfile.Instruction;
import net.multiphasicapps.classfile.InstructionJumpTarget;
import net.multiphasicapps.classfile.InstructionMnemonics;
import net.multiphasicapps.classfile.InstructionRawArgumentType;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.LookupSwitch;
import net.multiphasicapps.classfile.MethodReference;
import net.multiphasicapps.classfile.Pool;
import net.multiphasicapps.classfile.PrimitiveType;
import net.multiphasicapps.classfile.TableSwitch;

public final class ByteCodeUtils {
    private ByteCodeUtils() {
    }

    public static int instructionLength(byte[] __code, int __codeOff, int __a, int[] __last) throws InvalidClassFormatException, NullPointerException {
        if (__code == null) {
            throw new NullPointerException("NARG");
        }
        int aa2 = __a + __codeOff;
        int op = ByteCodeUtils.instructionOpCode(__code, __codeOff, __a);
        int rv = ByteCodeUtils.instructionOpCodeLength(op);
        switch (op) {
            case 168: 
            case 169: 
            case 196: 
            case 201: 
            case 202: 
            case 254: 
            case 255: {
                throw new InvalidClassFormatException(String.format("JC26 %d %d", op, __a));
            }
            case 186: {
                throw new InvalidClassFormatException(String.format("JC27 %d", __a));
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 188: {
                ++rv;
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 132: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 198: 
            case 199: 
            case 50197: 
            case 50198: 
            case 50199: 
            case 50200: 
            case 50201: 
            case 50230: 
            case 50231: 
            case 50232: 
            case 50233: 
            case 50234: {
                rv += 2;
                break;
            }
            case 197: {
                rv += 3;
                break;
            }
            case 185: 
            case 200: 
            case 50308: {
                rv += 4;
                break;
            }
            case 170: {
                int tusaddr = aa2 + 4 & 0xFFFFFFFC;
                int tuspadlen = tusaddr - aa2;
                rv = tuspadlen + 12 + 4 * (Instruction.__readInt(__code, tusaddr + 8) - Instruction.__readInt(__code, tusaddr + 4) + 1);
                break;
            }
            case 171: {
                int lusaddr = aa2 + 4 & 0xFFFFFFFC;
                int luspadlen = lusaddr - aa2;
                rv = luspadlen + 8 + 8 * Instruction.__readInt(__code, lusaddr + 4);
                break;
            }
            default: {
                throw new InvalidClassFormatException(String.format("JC28 %d %d %d", op, __a, __last != null && __last.length > 0 ? __last[0] : -1));
            }
        }
        if (__last != null && __last.length > 0) {
            __last[0] = op;
        }
        return rv;
    }

    public static int instructionOpCode(byte[] __code, int __codeOff, int __a) throws InvalidClassFormatException, NullPointerException {
        if (__code == null) {
            throw new NullPointerException("NARG");
        }
        int op = __code[__codeOff + __a] & 0xFF;
        if (op == 196) {
            if (__codeOff + __a + 1 >= __code.length) {
                throw new InvalidClassFormatException(String.format("JC25 %d", __a));
            }
            return op << 8 | __code[__codeOff + __a + 1] & 0xFF;
        }
        return op;
    }

    public static int instructionOpCodeLength(byte[] __code, int __codeOff, int __a) throws InvalidClassFormatException, NullPointerException {
        return ByteCodeUtils.instructionOpCodeLength(ByteCodeUtils.instructionOpCode(__code, __codeOff, __a));
    }

    public static int instructionOpCodeLength(int __opCode) {
        if (__opCode >>> 8 == 196) {
            return 2;
        }
        return 1;
    }

    public static InstructionRawArgumentType[] instructionRawArguments(byte[] __code, int __codeOff, int __a) throws InvalidClassFormatException, NullPointerException {
        return ByteCodeUtils.instructionRawArguments(ByteCodeUtils.instructionOpCode(__code, __codeOff, __a), __a);
    }

    public static InstructionRawArgumentType[] instructionRawArguments(int __opCode, int __a) throws InvalidClassFormatException, NullPointerException {
        switch (__opCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return new InstructionRawArgumentType[0];
            }
            case 16: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.SIGNED_BYTE};
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 188: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.UNSIGNED_BYTE};
            }
            case 17: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.SIGNED_SHORT};
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.UNSIGNED_SHORT};
            }
            case 132: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.UNSIGNED_BYTE, InstructionRawArgumentType.SIGNED_BYTE};
            }
            case 50308: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.UNSIGNED_SHORT, InstructionRawArgumentType.SIGNED_SHORT};
            }
            case 197: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.UNSIGNED_SHORT, InstructionRawArgumentType.UNSIGNED_BYTE};
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 198: 
            case 199: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.JUMP_SHORT};
            }
            case 200: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.JUMP_INTEGER};
            }
            case 171: {
                return new InstructionRawArgumentType[]{ByteCodeUtils.switchPadding(__a), InstructionRawArgumentType.LOOKUPSWITCH};
            }
            case 170: {
                return new InstructionRawArgumentType[]{ByteCodeUtils.switchPadding(__a), InstructionRawArgumentType.TABLESWITCH};
            }
            case 186: {
                return new InstructionRawArgumentType[]{InstructionRawArgumentType.UNSIGNED_SHORT, InstructionRawArgumentType.SIGNED_BYTE, InstructionRawArgumentType.SIGNED_BYTE};
            }
        }
        throw new RuntimeException(String.format("JC37 %d %s %d", __opCode, InstructionMnemonics.toString(__opCode), __a));
    }

    public static boolean naturallyFlows(int __op) {
        switch (__op) {
            case 167: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: 
            case 200: {
                return false;
            }
        }
        return true;
    }

    public static Object[] processArguments(Pool __pool, int __op, int __addr, int[] __rawArgs) throws InvalidClassFormatException, NullPointerException {
        if (__pool == null || __rawArgs == null) {
            throw new NullPointerException("NARG");
        }
        switch (__op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return new Object[0];
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                return new Object[]{__pool.require(ClassName.class, __rawArgs[0])};
            }
            case 16: {
                return new Object[]{__rawArgs[0]};
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return new Object[]{__rawArgs[0]};
            }
            case 17: {
                return new Object[]{__rawArgs[0]};
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return new Object[]{__pool.require(FieldReference.class, __rawArgs[0])};
            }
            case 167: {
                return new Object[]{new InstructionJumpTarget(__rawArgs[0])};
            }
            case 132: {
                return new Object[]{__rawArgs[0], __rawArgs[1]};
            }
            case 50308: {
                return new Object[]{__rawArgs[0], __rawArgs[1]};
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return new Object[]{new InstructionJumpTarget(__rawArgs[0])};
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodReference mr = __pool.require(MethodReference.class, __rawArgs[0]);
                if (mr.isInterface() != (__op == 185)) {
                    throw new InvalidClassFormatException(String.format("JC31 %d %d %s", __op, __addr, mr));
                }
                return new Object[]{mr};
            }
            case 18: 
            case 19: {
                Object ldcv = __pool.require(Object.class, __rawArgs[0]);
                ConstantValue cvalue = ldcv instanceof ClassName ? new ConstantValueClass((ClassName)ldcv) : (ConstantValue)ldcv;
                if (!cvalue.type().isNarrow()) {
                    throw new InvalidClassFormatException(String.format("JC32 %d %d %s", __op, __addr, cvalue));
                }
                return new Object[]{cvalue};
            }
            case 20: {
                ConstantValue cvalue = __pool.require(ConstantValue.class, __rawArgs[0]);
                if (!cvalue.type().isWide()) {
                    throw new InvalidClassFormatException(String.format("JC33 %d %d %s", __op, __addr, cvalue));
                }
                return new Object[]{cvalue};
            }
            case 188: {
                PrimitiveType pt;
                int pd = __rawArgs[0];
                switch (pd) {
                    case 4: {
                        pt = PrimitiveType.BOOLEAN;
                        break;
                    }
                    case 5: {
                        pt = PrimitiveType.CHARACTER;
                        break;
                    }
                    case 6: {
                        pt = PrimitiveType.FLOAT;
                        break;
                    }
                    case 7: {
                        pt = PrimitiveType.DOUBLE;
                        break;
                    }
                    case 8: {
                        pt = PrimitiveType.BYTE;
                        break;
                    }
                    case 9: {
                        pt = PrimitiveType.SHORT;
                        break;
                    }
                    case 10: {
                        pt = PrimitiveType.INTEGER;
                        break;
                    }
                    case 11: {
                        pt = PrimitiveType.LONG;
                        break;
                    }
                    default: {
                        throw new InvalidClassFormatException(String.format("JC34 %d %d %d", __op, __addr, pd));
                    }
                }
                return new Object[]{pt};
            }
            case 197: {
                ClassName cname = __pool.require(ClassName.class, __rawArgs[0]);
                int dims = __rawArgs[1];
                if (cname.dimensions() < dims) {
                    throw new InvalidClassFormatException(String.format("JC35 %d %d %d", __op, __addr, dims));
                }
                return new Object[]{cname, dims};
            }
            case 171: {
                InstructionJumpTarget def = new InstructionJumpTarget(__rawArgs[0]);
                int n2 = __rawArgs[1];
                int[] keys = new int[n2];
                InstructionJumpTarget[] jumps = new InstructionJumpTarget[n2];
                int i2 = 0;
                int fromDx = 2;
                while (i2 < n2) {
                    int key;
                    keys[i2] = key = __rawArgs[fromDx];
                    jumps[i2] = new InstructionJumpTarget(__rawArgs[fromDx + 1], key);
                    ++i2;
                    fromDx += 2;
                }
                return new Object[]{new LookupSwitch(def, keys, jumps)};
            }
            case 170: {
                InstructionJumpTarget def = new InstructionJumpTarget(__rawArgs[0]);
                int lo = __rawArgs[1];
                int hi = __rawArgs[2];
                int n3 = hi - lo + 1;
                InstructionJumpTarget[] jumps = new InstructionJumpTarget[n3];
                int i3 = 0;
                int fromDx = 3;
                while (i3 < n3) {
                    jumps[i3] = new InstructionJumpTarget(__rawArgs[fromDx], lo + i3);
                    ++i3;
                    ++fromDx;
                }
                return new Object[]{new TableSwitch(def, lo, hi, jumps)};
            }
        }
        throw new RuntimeException(String.format("JC37 %d %s %d", __op, InstructionMnemonics.toString(__op), __addr));
    }

    public static int[] readRawArguments(byte[] __code, int __codeOff, int __a) throws InvalidClassFormatException, NullPointerException {
        if (__code == null) {
            throw new NullPointerException("NARG");
        }
        int readPos = __codeOff + __a + ByteCodeUtils.instructionOpCodeLength(__code, __codeOff, __a);
        InstructionRawArgumentType[] rawTypes = ByteCodeUtils.instructionRawArguments(__code, __codeOff, __a);
        IntegerList result = new IntegerList();
        block15: for (InstructionRawArgumentType rawType : rawTypes) {
            switch (rawType) {
                case PADDING_0: {
                    continue block15;
                }
                case PADDING_1: {
                    ++readPos;
                    continue block15;
                }
                case PADDING_2: {
                    readPos += 2;
                    continue block15;
                }
                case PADDING_3: {
                    readPos += 3;
                    continue block15;
                }
                case SIGNED_BYTE: {
                    result.addInteger(Instruction.__readByte(__code, readPos));
                    ++readPos;
                    continue block15;
                }
                case UNSIGNED_BYTE: {
                    result.addInteger(Instruction.__readUnsignedByte(__code, readPos));
                    ++readPos;
                    continue block15;
                }
                case SIGNED_SHORT: {
                    result.addInteger(Instruction.__readShort(__code, readPos));
                    readPos += 2;
                    continue block15;
                }
                case UNSIGNED_SHORT: {
                    result.addInteger(Instruction.__readUnsignedShort(__code, readPos));
                    readPos += 2;
                    continue block15;
                }
                case JUMP_SHORT: {
                    result.addInteger(__a + Instruction.__readShort(__code, readPos));
                    readPos += 2;
                    continue block15;
                }
                case INTEGER: {
                    result.addInteger(Instruction.__readInt(__code, readPos));
                    readPos += 4;
                    continue block15;
                }
                case JUMP_INTEGER: {
                    result.addInteger(__a + Instruction.__readInt(__code, readPos));
                    readPos += 4;
                    continue block15;
                }
                case LOOKUPSWITCH: {
                    result.addInteger(__a + Instruction.__readInt(__code, readPos));
                    int numPairs = Instruction.__readInt(__code, readPos += 4);
                    result.addInteger(numPairs);
                    readPos += 4;
                    for (int i2 = 0; i2 < numPairs; ++i2) {
                        result.addInteger(Instruction.__readInt(__code, readPos));
                        result.addInteger(__a + Instruction.__readInt(__code, readPos += 4));
                        readPos += 4;
                    }
                    continue block15;
                }
                case TABLESWITCH: {
                    result.addInteger(__a + Instruction.__readInt(__code, readPos));
                    int lo = Instruction.__readInt(__code, readPos += 4);
                    result.addInteger(lo);
                    int hi = Instruction.__readInt(__code, readPos += 4);
                    result.addInteger(hi);
                    readPos += 4;
                    int n2 = hi - lo + 1;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        result.addInteger(__a + Instruction.__readInt(__code, readPos));
                        readPos += 4;
                    }
                    continue block15;
                }
                default: {
                    throw Debugging.todo();
                }
            }
        }
        return result.toIntegerArray();
    }

    public static InstructionRawArgumentType switchPadding(int __a) {
        switch (__a & 3) {
            case 3: {
                return InstructionRawArgumentType.PADDING_0;
            }
            case 2: {
                return InstructionRawArgumentType.PADDING_1;
            }
            case 1: {
                return InstructionRawArgumentType.PADDING_2;
            }
            case 0: {
                return InstructionRawArgumentType.PADDING_3;
            }
        }
        throw Debugging.oops();
    }
}

