/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.multiphasicapps.classfile.Annotated;
import net.multiphasicapps.classfile.Annotation;
import net.multiphasicapps.classfile.AnnotationTable;
import net.multiphasicapps.classfile.Attribute;
import net.multiphasicapps.classfile.AttributeTable;
import net.multiphasicapps.classfile.ClassFlag;
import net.multiphasicapps.classfile.ClassFlags;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.ClassNames;
import net.multiphasicapps.classfile.ClassType;
import net.multiphasicapps.classfile.ClassVersion;
import net.multiphasicapps.classfile.Field;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.HasAccessibleFlags;
import net.multiphasicapps.classfile.InnerClass;
import net.multiphasicapps.classfile.InnerClasses;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.Method;
import net.multiphasicapps.classfile.Pool;
import net.multiphasicapps.classfile.UTFConstantEntry;
import net.multiphasicapps.collections.UnmodifiableArrayList;
import net.multiphasicapps.io.SizeLimitedInputStream;

public final class ClassFile
implements Annotated,
HasAccessibleFlags {
    private static final int _MAGIC_NUMBER = -889275714;
    protected final ClassVersion version;
    protected final ClassFlags classflags;
    protected final ClassName thisname;
    protected final ClassName supername;
    protected final AnnotationTable annotations;
    protected final InnerClasses innerclasses;
    protected final String sourcefilename;
    protected final ClassNames interfaces;
    protected final Pool pool;
    private final Field[] _fields;
    private final Method[] _methods;

    ClassFile(ClassVersion __ver, ClassFlags __cf, ClassName __tn, ClassName __sn, ClassName[] __in, Field[] __fs, Method[] __ms, InnerClasses __icl, AnnotationTable __at, String __sfn, Pool __pool) throws InvalidClassFormatException, NullPointerException {
        if (__ver == null || __cf == null || __tn == null || __in == null || __fs == null || __ms == null || __icl == null || __at == null) {
            throw new NullPointerException("NARG");
        }
        Object[][] objectArrayArray = new Object[3][];
        __in = (ClassName[])__in.clone();
        objectArrayArray[0] = __in;
        __fs = (Field[])__fs.clone();
        objectArrayArray[1] = __fs;
        __ms = (Method[])__ms.clone();
        objectArrayArray[2] = __ms;
        Object[][] objectArrayArray2 = objectArrayArray;
        int n2 = objectArrayArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] foo;
            for (Object f2 : foo = objectArrayArray2[i2]) {
                if (f2 != null) continue;
                throw new NullPointerException("NARG");
            }
        }
        ClassName objectcn = new ClassName("java/lang/Object");
        if ((__tn.isPrimitive() || __tn.equals(objectcn)) != (__sn == null)) {
            throw new InvalidClassFormatException(String.format("JC29 %s %s %s %s", __tn, __sn, objectcn, __tn.isPrimitive()), this);
        }
        this.version = __ver;
        this.classflags = __cf;
        this.thisname = __tn;
        this.supername = __sn;
        this.innerclasses = __icl;
        this.annotations = __at;
        this.interfaces = new ClassNames(__in);
        this._fields = __fs;
        this._methods = __ms;
        this.sourcefilename = __sfn;
        this.pool = __pool;
    }

    @Override
    public final AnnotationTable annotationTable() {
        return this.annotations;
    }

    public final List<Field> fields() {
        return UnmodifiableArrayList.of(this._fields);
    }

    @Override
    public final ClassFlags flags() {
        return this.classflags;
    }

    public final InnerClasses innerClasses() {
        return this.innerclasses;
    }

    public final ClassNames interfaceNames() {
        return this.interfaces;
    }

    public final Method[] methods() {
        return (Method[])this._methods.clone();
    }

    public final Pool pool() {
        return this.pool;
    }

    public final String sourceFile() {
        return this.sourcefilename;
    }

    public final ClassName superName() {
        return this.supername;
    }

    public final ClassName thisName() {
        return this.thisname;
    }

    public final ClassType type() {
        ClassFlags flags = this.classflags;
        if (flags.isEnum()) {
            return ClassType.ENUM;
        }
        if (flags.isAnnotation()) {
            return ClassType.ANNOTATION;
        }
        if (flags.isInterface()) {
            return ClassType.INTERFACE;
        }
        return ClassType.CLASS;
    }

    public final ClassVersion version() {
        return this.version;
    }

    public static ClassFile special(FieldDescriptor __d) throws IllegalArgumentException, NullPointerException {
        if (__d == null) {
            throw new NullPointerException("NARG");
        }
        if (!__d.isArray() && !__d.isPrimitive()) {
            throw new IllegalArgumentException(String.format("JC2a %s", __d));
        }
        ClassFlags cflags = new ClassFlags(ClassFlag.PUBLIC, ClassFlag.FINAL, ClassFlag.SUPER, ClassFlag.SYNTHETIC);
        Method[] methods = new Method[]{};
        boolean isPrimitive = __d.isPrimitive();
        ClassName name = isPrimitive ? ClassName.fromPrimitiveType(__d.primitiveType()) : __d.className();
        return new ClassFile(ClassVersion.MAX_VERSION, cflags, name, isPrimitive ? null : new ClassName("java/lang/Object"), new ClassName[0], new Field[0], methods, new InnerClasses(new InnerClass[0]), new AnnotationTable(new Annotation[0]), "<special>", null);
    }

    public static ClassFile decode(InputStream __is) throws InvalidClassFormatException, IOException, NullPointerException {
        if (__is == null) {
            throw new NullPointerException("NARG");
        }
        DataInputStream in = new DataInputStream(__is);
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new InvalidClassFormatException(String.format("JC2b %08x %08x", magic, -889275714));
        }
        int cver = in.readShort() | in.readShort() << 16;
        ClassVersion version = ClassVersion.findVersion(cver);
        if (version == null) {
            throw new InvalidClassFormatException(String.format("JC2c %d.%d", cver >>> 16, cver & 0xFFFF));
        }
        Pool pool = Pool.decode(in);
        ClassFlags classflags = new ClassFlags(in.readUnsignedShort());
        ClassName thisname = pool.require(ClassName.class, in.readUnsignedShort());
        ClassName supername = pool.get(ClassName.class, in.readUnsignedShort());
        int icount = in.readUnsignedShort();
        ClassName[] interfaces = new ClassName[icount];
        for (int i2 = 0; i2 < icount; ++i2) {
            interfaces[i2] = pool.require(ClassName.class, in.readUnsignedShort());
        }
        Field[] fields = Field.decode(version, thisname, classflags, pool, in);
        Method[] methods = Method.decode(version, thisname, classflags, pool, in);
        AttributeTable attrs = AttributeTable.parse(pool, in);
        AnnotationTable annotations = AnnotationTable.parse(pool, attrs);
        InnerClasses innerclasses = InnerClasses.parse(pool, attrs);
        if (in.read() >= 0) {
            throw new InvalidClassFormatException(String.format("JC2d %s", thisname));
        }
        Attribute attr = attrs.get("SourceFile");
        String sourcefilename = null;
        if (attr != null) {
            try (DataInputStream ai2 = attr.open();){
                sourcefilename = pool.require(UTFConstantEntry.class, ai2.readUnsignedShort()).toString();
            }
        }
        return new ClassFile(version, classflags, thisname, supername, interfaces, fields, methods, innerclasses, annotations, sourcefilename, pool);
    }

    @Deprecated
    static DataInputStream __nextAttribute(DataInputStream __in, Pool __pool, String[] __aname, int[] __alens) throws InvalidClassFormatException, IOException, NullPointerException {
        if (__aname == null || __alens == null) {
            throw new NullPointerException("NARG");
        }
        __aname[0] = __pool.require(UTFConstantEntry.class, __in.readUnsignedShort()).toString();
        int len = __in.readInt();
        if (len < 0) {
            throw new InvalidClassFormatException(String.format("JC2e %d", (long)len & 0xFFFFFFFFL));
        }
        __alens[0] = len;
        return new DataInputStream(new SizeLimitedInputStream(__in, len, true, false));
    }
}

