/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import net.multiphasicapps.classfile.AccessibleFlags;
import net.multiphasicapps.classfile.ClassFlag;
import net.multiphasicapps.classfile.Flag;
import net.multiphasicapps.classfile.Flags;
import net.multiphasicapps.classfile.InvalidClassFormatException;

public class ClassFlags
extends Flags<ClassFlag>
implements AccessibleFlags {
    public ClassFlags(int __i) {
        this(Flags.__decode((int)__i, (Flag[])ClassFlag.values()));
    }

    public ClassFlags(ClassFlag ... __fl) {
        super(ClassFlag.class, (Flag[])__fl);
        this.__checkFlags();
    }

    public ClassFlags(Iterable<ClassFlag> __fl) {
        super(ClassFlag.class, __fl);
        this.__checkFlags();
    }

    public final boolean isAbstract() {
        return this.contains(ClassFlag.ABSTRACT);
    }

    public final boolean isAnnotation() {
        return this.contains(ClassFlag.ANNOTATION);
    }

    public final boolean isEnum() {
        return this.contains(ClassFlag.ENUM);
    }

    public final boolean isFinal() {
        return this.contains(ClassFlag.FINAL);
    }

    public final boolean isInterface() {
        return this.contains(ClassFlag.INTERFACE);
    }

    @Override
    public final boolean isPackagePrivate() {
        return !this.isPublic();
    }

    @Override
    public final boolean isPrivate() {
        return false;
    }

    @Override
    public final boolean isProtected() {
        return false;
    }

    @Override
    public final boolean isPublic() {
        return this.contains(ClassFlag.PUBLIC);
    }

    public final boolean isSpecialInvokeSpecial() {
        return this.contains(ClassFlag.SUPER);
    }

    private void __checkFlags() throws InvalidClassFormatException {
        if (this.isInterface()) {
            if (!this.isAbstract()) {
                throw new InvalidClassFormatException(String.format("JC2f %s", this), this);
            }
            if (this.isFinal() || this.isSpecialInvokeSpecial() || this.isEnum()) {
                throw new InvalidClassFormatException(String.format("JC2g %s", this), this);
            }
        } else {
            if (this.isAnnotation()) {
                throw new InvalidClassFormatException(String.format("JC2h %s", this), this);
            }
            if (this.isAbstract() && this.isFinal()) {
                throw new InvalidClassFormatException(String.format("JC2i %s", this), this);
            }
        }
    }
}

