/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.util.Objects;
import net.multiphasicapps.classfile.BinaryName;
import net.multiphasicapps.classfile.ClassIdentifier;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.PrimitiveType;

public class ClassName
implements Contexual,
Comparable<ClassName> {
    protected final BinaryName binary;
    protected final FieldDescriptor field;
    protected final boolean isprimitive;

    public ClassName(String __n) throws InvalidClassFormatException, NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        if (__n.startsWith("[")) {
            this.binary = null;
            this.field = new FieldDescriptor(__n);
            this.isprimitive = false;
        } else {
            this.binary = new BinaryName(__n);
            this.field = null;
            switch (__n) {
                case "boolean": 
                case "byte": 
                case "short": 
                case "char": 
                case "int": 
                case "long": 
                case "float": 
                case "double": {
                    this.isprimitive = true;
                    break;
                }
                default: {
                    this.isprimitive = false;
                }
            }
        }
    }

    public final ClassName addDimensions(int __d) throws IllegalArgumentException {
        if (__d == 0) {
            return this;
        }
        if (__d < 0) {
            throw new IllegalArgumentException("JC2j");
        }
        return this.field().addDimensions(__d).className();
    }

    public BinaryName binaryName() {
        return this.binary;
    }

    @Override
    public int compareTo(ClassName __o) {
        BinaryName ab2 = this.binary;
        if (ab2 != null) {
            BinaryName bb2 = __o.binary;
            if (bb2 == null) {
                return -1;
            }
            return ab2.compareTo(bb2);
        }
        FieldDescriptor af2 = this.field;
        FieldDescriptor bf2 = __o.field;
        if (bf2 == null) {
            return 1;
        }
        return af2.compareTo(bf2);
    }

    public final ClassName componentType() throws IllegalStateException {
        if (!this.isArray()) {
            throw new IllegalStateException(String.format("JC2k %s", this));
        }
        return this.field().componentType().className();
    }

    public final int dimensions() {
        if (!this.isArray()) {
            return 0;
        }
        return this.field().dimensions();
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof ClassName)) {
            return false;
        }
        ClassName o2 = (ClassName)__o;
        return Objects.equals(this.binary, o2.binary) && Objects.equals(this.field, o2.field);
    }

    public FieldDescriptor field() {
        BinaryName binary = this.binary;
        if (this.isprimitive) {
            switch (binary.toString()) {
                case "boolean": {
                    return new FieldDescriptor("Z");
                }
                case "byte": {
                    return new FieldDescriptor("B");
                }
                case "short": {
                    return new FieldDescriptor("S");
                }
                case "char": {
                    return new FieldDescriptor("C");
                }
                case "int": {
                    return new FieldDescriptor("I");
                }
                case "long": {
                    return new FieldDescriptor("J");
                }
                case "float": {
                    return new FieldDescriptor("F");
                }
                case "double": {
                    return new FieldDescriptor("D");
                }
            }
            throw new RuntimeException("TODO");
        }
        if (binary != null) {
            return new FieldDescriptor("L" + binary + ";");
        }
        return this.field;
    }

    public int hashCode() {
        BinaryName ab2 = this.binary;
        return ab2 != null ? ab2.hashCode() : this.field.hashCode();
    }

    public BinaryName inPackage() {
        BinaryName b2 = this.binary;
        if (b2 != null) {
            return b2.inPackage();
        }
        return null;
    }

    public boolean isArray() {
        FieldDescriptor field = this.field;
        return field != null && field.isArray();
    }

    public boolean isInSamePackage(ClassName __b) throws NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        return Objects.equals(this.inPackage(), __b.inPackage());
    }

    public boolean isObjectClass() {
        return this.toString().equals("java/lang/Object");
    }

    public boolean isPrimitive() {
        FieldDescriptor field = this.field;
        return this.isprimitive || field != null && field.isPrimitive();
    }

    public final PrimitiveType primitiveType() {
        BinaryName binary = this.binary;
        if (binary == null) {
            return null;
        }
        switch (binary.toString()) {
            case "boolean": {
                return PrimitiveType.BOOLEAN;
            }
            case "byte": {
                return PrimitiveType.BYTE;
            }
            case "short": {
                return PrimitiveType.SHORT;
            }
            case "char": {
                return PrimitiveType.CHARACTER;
            }
            case "int": {
                return PrimitiveType.INTEGER;
            }
            case "long": {
                return PrimitiveType.LONG;
            }
            case "float": {
                return PrimitiveType.FLOAT;
            }
            case "double": {
                return PrimitiveType.DOUBLE;
            }
        }
        return null;
    }

    public final ClassName rootComponentType() throws IllegalStateException {
        if (!this.isArray()) {
            throw new IllegalStateException(String.format("JC4w %s", this));
        }
        ClassName rv = this;
        while (rv.isArray()) {
            rv = rv.componentType();
        }
        return rv;
    }

    public ClassIdentifier simpleName() throws IllegalStateException {
        if (this.isArray() || this.isPrimitive()) {
            throw new IllegalStateException("JC0g");
        }
        return this.binary.simpleName();
    }

    public String toRuntimeString() {
        BinaryName binary = this.binary;
        if (!this.isArray() && binary != null) {
            return binary.toString().replace('/', '.');
        }
        return this.toString().replace('/', '.');
    }

    public String toString() {
        BinaryName binary = this.binary;
        if (binary != null) {
            return binary.toString();
        }
        return this.field.toString();
    }

    public static ClassName fromPrimitiveType(PrimitiveType __t) throws NullPointerException {
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        switch (__t) {
            case BOOLEAN: {
                return new ClassName("boolean");
            }
            case BYTE: {
                return new ClassName("byte");
            }
            case SHORT: {
                return new ClassName("short");
            }
            case CHARACTER: {
                return new ClassName("char");
            }
            case INTEGER: {
                return new ClassName("int");
            }
            case LONG: {
                return new ClassName("long");
            }
            case FLOAT: {
                return new ClassName("float");
            }
            case DOUBLE: {
                return new ClassName("double");
            }
        }
        throw Debugging.oops();
    }

    public static ClassName fromRuntimeName(String __in) throws InvalidClassFormatException, NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        return new ClassName(__in.replace('.', '/'));
    }

    public static boolean isValidClassName(String __cn) throws NullPointerException {
        if (__cn == null) {
            throw new NullPointerException("NARG");
        }
        try {
            ClassName cn2 = new ClassName(__cn);
            return true;
        }
        catch (InvalidClassFormatException e2) {
            return false;
        }
    }
}

