/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.JavaType;
import net.multiphasicapps.classfile.PrimitiveType;

public enum ConstantValueType {
    INTEGER,
    LONG,
    FLOAT,
    DOUBLE,
    STRING,
    CLASS;


    public final boolean isCompatibleWith(FieldDescriptor __d) throws NullPointerException {
        if (__d == null) {
            throw new NullPointerException("NARG");
        }
        switch (this) {
            case INTEGER: {
                if (!__d.isPrimitive()) {
                    return false;
                }
                switch (__d.primitiveType()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case CHARACTER: 
                    case INTEGER: {
                        return true;
                    }
                }
                return false;
            }
            case LONG: {
                return __d.isPrimitive() && __d.primitiveType().equals((Object)PrimitiveType.LONG);
            }
            case FLOAT: {
                return __d.isPrimitive() && __d.primitiveType().equals((Object)PrimitiveType.FLOAT);
            }
            case DOUBLE: {
                return __d.isPrimitive() && __d.primitiveType().equals((Object)PrimitiveType.DOUBLE);
            }
            case STRING: {
                return __d.isObject() && "Ljava/lang/String;".equals(__d.toString());
            }
            case CLASS: {
                return __d.isObject() && "Ljava/lang/Class;".equals(__d.toString());
            }
        }
        throw Debugging.oops();
    }

    public final boolean isNarrow() {
        switch (this) {
            case INTEGER: 
            case FLOAT: 
            case STRING: 
            case CLASS: {
                return true;
            }
        }
        return false;
    }

    public final boolean isWide() {
        switch (this) {
            case LONG: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public final JavaType javaType() {
        switch (this) {
            case INTEGER: {
                return JavaType.INTEGER;
            }
            case LONG: {
                return JavaType.LONG;
            }
            case FLOAT: {
                return JavaType.FLOAT;
            }
            case DOUBLE: {
                return JavaType.DOUBLE;
            }
            case STRING: {
                return new JavaType(new FieldDescriptor("Ljava/lang/String;"));
            }
            case CLASS: {
                return new JavaType(new FieldDescriptor("Ljava/lang/Class;"));
            }
        }
        throw Debugging.oops();
    }
}

