/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.InstructionAddressRange;
import net.multiphasicapps.classfile.InvalidClassFormatException;

public final class ExceptionHandler
implements Contexual {
    protected final int startpc;
    protected final int endpc;
    protected final int handlerpc;
    protected final ClassName type;
    private Reference<String> _string;

    ExceptionHandler(int __spc, int __epc, int __hpc, ClassName __cn) throws InvalidClassFormatException {
        if (__spc < 0 || __epc < 0 || __hpc < 0) {
            throw new InvalidClassFormatException(String.format("JC2l %d %d %d", __spc, __epc, __hpc), this);
        }
        if (__epc <= __spc) {
            throw new InvalidClassFormatException(String.format("JC2m %d %d", __spc, __epc), this);
        }
        this.startpc = __spc;
        this.endpc = __epc;
        this.handlerpc = __hpc;
        this.type = __cn == null ? new ClassName("java/lang/Throwable") : __cn;
    }

    public int endAddress() {
        return this.endpc;
    }

    public boolean equals(Object __o) {
        if (!(__o instanceof ExceptionHandler)) {
            return false;
        }
        if (__o == this) {
            return true;
        }
        ExceptionHandler o2 = (ExceptionHandler)__o;
        return this.startpc == o2.startpc && this.endpc == o2.endpc && this.handlerpc == o2.handlerpc && Objects.equals(this.type, o2.type);
    }

    public int handlerAddress() {
        return this.handlerpc;
    }

    public int hashCode() {
        return this.startpc ^ this.endpc ^ this.handlerpc ^ Objects.hashCode(this.type);
    }

    public boolean inRange(int __i) {
        return __i >= this.startpc && __i < this.endpc;
    }

    public final InstructionAddressRange range() {
        return new InstructionAddressRange(this.startpc, this.endpc);
    }

    public int startAddress() {
        return this.startpc;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = String.format("{%d-%d > %d (%s)}", this.startpc, this.endpc, this.handlerpc, this.type);
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public ClassName type() {
        return this.type;
    }
}

