/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.UnmodifiableIterator;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.ExceptionHandler;
import net.multiphasicapps.classfile.InstructionAddressRange;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.Pool;

public final class ExceptionHandlerTable
implements Contexual,
Iterable<ExceptionHandler> {
    private final ExceptionHandler[] _table;
    private Reference<String> _string;

    ExceptionHandlerTable(ExceptionHandler ... __t) throws NullPointerException {
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        for (ExceptionHandler e2 : __t = (ExceptionHandler[])__t.clone()) {
            if (e2 != null) continue;
            throw new NullPointerException("NARG");
        }
        this._table = __t;
    }

    ExceptionHandlerTable(Collection<ExceptionHandler> __t) throws NullPointerException {
        ExceptionHandler[] t2;
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        for (ExceptionHandler e2 : t2 = __t.toArray(new ExceptionHandler[__t.size()])) {
            if (e2 != null) continue;
            throw new NullPointerException("NARG");
        }
        this._table = t2;
    }

    public final ExceptionHandler[] at(int __pc) {
        ArrayList<ExceptionHandler> rv = new ArrayList<ExceptionHandler>();
        for (ExceptionHandler e2 : this._table) {
            if (!e2.inRange(__pc)) continue;
            rv.add(e2);
        }
        return rv.toArray(new ExceptionHandler[rv.size()]);
    }

    public final boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof ExceptionHandlerTable)) {
            return false;
        }
        return Arrays.equals(this._table, ((ExceptionHandlerTable)__o)._table);
    }

    public final ExceptionHandler get(int __i) {
        return this._table[__i];
    }

    public final int hashCode() {
        int rv = 0;
        for (ExceptionHandler e2 : this._table) {
            rv += e2.hashCode();
        }
        return rv;
    }

    public final boolean isEmpty() {
        return this._table.length == 0;
    }

    @Override
    public final Iterator<ExceptionHandler> iterator() {
        return UnmodifiableIterator.of(this._table);
    }

    public final Map<InstructionAddressRange, ExceptionHandlerTable> mappedUniqueRanges() {
        LinkedHashMap<InstructionAddressRange, ExceptionHandlerTable> rv = new LinkedHashMap<InstructionAddressRange, ExceptionHandlerTable>();
        int rangestart = 0;
        ExceptionHandlerTable current = this.tableAt(0);
        int ma = this.maximumEndAddress();
        for (int i2 = 1; i2 <= ma; ++i2) {
            ExceptionHandlerTable now = this.tableAt(i2);
            if (current.equals(now)) continue;
            rv.put(new InstructionAddressRange(rangestart, i2), current);
            rangestart = i2;
            current = now;
        }
        rv.put(new InstructionAddressRange(rangestart, ma), current);
        return rv;
    }

    public final int maximumEndAddress() {
        int rv = 0;
        for (ExceptionHandler e2 : this._table) {
            int epc = e2.endpc;
            if (epc <= rv) continue;
            rv = epc;
        }
        return rv;
    }

    public final int maximumStartAddress() {
        int rv = 0;
        for (ExceptionHandler e2 : this._table) {
            int spc = e2.startpc;
            if (spc <= rv) continue;
            rv = spc;
        }
        return rv;
    }

    public final InstructionAddressRange range() {
        throw Debugging.todo();
    }

    public final int size() {
        return this._table.length;
    }

    public final ExceptionHandlerTable tableAt(int __pc) {
        return new ExceptionHandlerTable(this.at(__pc));
    }

    public final String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = Arrays.asList(this._table).toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public static ExceptionHandlerTable decode(DataInputStream __is, Pool __pool, int __len) throws InvalidClassFormatException, IOException, NullPointerException {
        if (__is == null || __pool == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __is.readUnsignedShort();
        ExceptionHandler[] table = new ExceptionHandler[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int spc = __is.readUnsignedShort();
            int epc = __is.readUnsignedShort();
            int hpc = __is.readUnsignedShort();
            ClassName type = __pool.get(ClassName.class, __is.readUnsignedShort());
            if (spc >= __len || epc > __len || hpc >= __len) {
                throw new InvalidClassFormatException(String.format("JC2n %d %d %d %d", spc, epc, hpc, __len));
            }
            table[i2] = new ExceptionHandler(spc, epc, hpc, type);
        }
        return new ExceptionHandlerTable(table);
    }
}

