/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import net.multiphasicapps.classfile.Annotated;
import net.multiphasicapps.classfile.Annotation;
import net.multiphasicapps.classfile.AnnotationTable;
import net.multiphasicapps.classfile.Attribute;
import net.multiphasicapps.classfile.AttributeTable;
import net.multiphasicapps.classfile.ClassFlags;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.ClassVersion;
import net.multiphasicapps.classfile.ConstantValue;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.FieldFlags;
import net.multiphasicapps.classfile.FieldName;
import net.multiphasicapps.classfile.FieldNameAndType;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.Member;
import net.multiphasicapps.classfile.NameAndType;
import net.multiphasicapps.classfile.Pool;
import net.multiphasicapps.classfile.UTFConstantEntry;

public final class Field
extends Member
implements Annotated {
    protected final FieldFlags flags;
    protected final FieldName name;
    protected final FieldDescriptor type;
    protected final ConstantValue constval;
    protected final AnnotationTable annotations;
    private Reference<FieldNameAndType> _nameandtype;

    public Field(FieldFlags __f, FieldName __n, FieldDescriptor __t, ConstantValue __cv, AnnotationTable __avs) throws InvalidClassFormatException, NullPointerException {
        if (__f == null || __n == null || __t == null) {
            throw new NullPointerException("NARG");
        }
        if (__cv != null && !__cv.type().isCompatibleWith(__t)) {
            throw new InvalidClassFormatException(String.format("JC2o %s %s %s", new Object[]{__cv, __cv.type(), __t}), this);
        }
        this.flags = __f;
        this.name = __n;
        this.type = __t;
        this.constval = __cv;
        this.annotations = __avs == null ? new AnnotationTable(new Annotation[0]) : __avs;
    }

    @Override
    public final AnnotationTable annotationTable() {
        return this.annotations;
    }

    public final ConstantValue constantValue() {
        return this.constval;
    }

    @Override
    public final FieldFlags flags() {
        return this.flags;
    }

    public final FieldName name() {
        return this.name;
    }

    @Override
    public final FieldNameAndType nameAndType() {
        FieldNameAndType rv;
        Reference<FieldNameAndType> ref = this._nameandtype;
        if (ref == null || null == (rv = ref.get())) {
            rv = new FieldNameAndType(this.name, this.type);
            this._nameandtype = new WeakReference<FieldNameAndType>(rv);
        }
        return rv;
    }

    public final FieldDescriptor type() {
        return this.type;
    }

    public static Field[] decode(ClassVersion __ver, ClassName __tn, ClassFlags __cf, Pool __pool, DataInputStream __in) throws InvalidClassFormatException, IOException, NullPointerException {
        if (__ver == null || __tn == null || __cf == null || __pool == null || __in == null) {
            throw new NullPointerException("NARG");
        }
        int nf = __in.readUnsignedShort();
        Field[] rv = new Field[nf];
        HashSet<NameAndType> dup = new HashSet<NameAndType>();
        for (int i2 = 0; i2 < nf; ++i2) {
            FieldFlags flags = new FieldFlags(__cf, __in.readUnsignedShort());
            FieldName name = new FieldName(__pool.require(UTFConstantEntry.class, __in.readUnsignedShort()).toString());
            FieldDescriptor type = new FieldDescriptor(__pool.require(UTFConstantEntry.class, __in.readUnsignedShort()).toString());
            if (!dup.add(new NameAndType(name.toString(), type.toString()))) {
                throw new InvalidClassFormatException(String.format("JC2p %s %s", name, type));
            }
            AttributeTable attrs = AttributeTable.parse(__pool, __in);
            AnnotationTable annotations = AnnotationTable.parse(__pool, attrs);
            ConstantValue constval = null;
            Attribute cvalattr = attrs.get("ConstantValue");
            if (cvalattr != null) {
                try (DataInputStream ai2 = cvalattr.open();){
                    constval = __pool.require(ConstantValue.class, ai2.readUnsignedShort());
                }
            }
            rv[i2] = new Field(flags, name, type, constval, annotations);
        }
        return rv;
    }
}

