/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.MemberDescriptor;
import net.multiphasicapps.classfile.PrimitiveType;
import net.multiphasicapps.classfile.SimpleStorageType;

public final class FieldDescriptor
implements Comparable<FieldDescriptor>,
MemberDescriptor {
    public static final FieldDescriptor SHORT = new FieldDescriptor("S");
    public static final FieldDescriptor INTEGER = new FieldDescriptor("I");
    protected final String string;
    protected final boolean primitive;
    protected final int dimensions;
    protected final FieldDescriptor component;
    protected final ClassName classname;

    public FieldDescriptor(String __n) throws InvalidClassFormatException, NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        this.string = __n;
        int n2 = __n.length();
        if (n2 <= 0) {
            throw new InvalidClassFormatException(String.format("JC2q %s", __n), this);
        }
        char c2 = __n.charAt(0);
        switch (c2) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                this.primitive = true;
                this.dimensions = 0;
                this.component = null;
                this.classname = null;
                break;
            }
            case '[': {
                this.primitive = false;
                this.classname = null;
                int dims = 0;
                for (int i2 = 0; i2 < n2 && __n.charAt(i2) == '['; ++i2) {
                    ++dims;
                }
                this.dimensions = dims;
                this.component = new FieldDescriptor(__n.substring(1));
                break;
            }
            case 'L': {
                this.primitive = false;
                this.dimensions = 0;
                this.component = null;
                if (';' != __n.charAt(n2 - 1)) {
                    throw new InvalidClassFormatException(String.format("JC2r %s", __n), this);
                }
                this.classname = new ClassName(__n.substring(1, n2 - 1));
                break;
            }
            default: {
                throw new InvalidClassFormatException(String.format("JC2s %s", __n), this);
            }
        }
    }

    public final FieldDescriptor addDimensions(int __d) throws IllegalArgumentException {
        if (__d == 0) {
            return this;
        }
        if (__d < 0) {
            throw new IllegalArgumentException("JC2t");
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < __d; ++i2) {
            sb.append('[');
        }
        sb.append(this.toString());
        return new FieldDescriptor(sb.toString());
    }

    public final ClassName className() {
        if (this.dimensions > 0) {
            return new ClassName(this.toString());
        }
        if (this.primitive) {
            return ClassName.fromPrimitiveType(this.primitiveType());
        }
        return this.classname;
    }

    @Override
    public int compareTo(FieldDescriptor __o) {
        return this.string.compareTo(__o.string);
    }

    public final FieldDescriptor componentType() {
        return this.component;
    }

    public final int dimensions() {
        return this.dimensions;
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof FieldDescriptor)) {
            return false;
        }
        return this.string.equals(((FieldDescriptor)__o).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean isArray() {
        return this.component != null;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isObject() {
        return !this.isPrimitive();
    }

    public final boolean isWide() {
        if (this.isObject()) {
            return false;
        }
        switch (this.primitiveType()) {
            case LONG: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public PrimitiveType primitiveType() {
        if (!this.primitive) {
            return null;
        }
        switch (this.toString()) {
            case "B": {
                return PrimitiveType.BYTE;
            }
            case "C": {
                return PrimitiveType.CHARACTER;
            }
            case "D": {
                return PrimitiveType.DOUBLE;
            }
            case "F": {
                return PrimitiveType.FLOAT;
            }
            case "I": {
                return PrimitiveType.INTEGER;
            }
            case "J": {
                return PrimitiveType.LONG;
            }
            case "S": {
                return PrimitiveType.SHORT;
            }
            case "Z": {
                return PrimitiveType.BOOLEAN;
            }
        }
        return null;
    }

    public final FieldDescriptor rootComponentType() {
        if (this.isArray()) {
            return this.componentType().rootComponentType();
        }
        return null;
    }

    public final SimpleStorageType simpleStorageType() {
        if (this.isObject()) {
            return SimpleStorageType.OBJECT;
        }
        switch (this.primitiveType()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case CHARACTER: 
            case INTEGER: {
                return SimpleStorageType.INTEGER;
            }
            case LONG: {
                return SimpleStorageType.LONG;
            }
            case FLOAT: {
                return SimpleStorageType.FLOAT;
            }
            case DOUBLE: {
                return SimpleStorageType.DOUBLE;
            }
        }
        throw Debugging.oops();
    }

    public final int stackWidth() {
        return this.isWide() ? 2 : 1;
    }

    public String toString() {
        return this.string;
    }
}

