/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.multiphasicapps.classfile.AccessibleFlags;
import net.multiphasicapps.classfile.ClassFlag;
import net.multiphasicapps.classfile.ClassFlags;
import net.multiphasicapps.classfile.Flag;
import net.multiphasicapps.classfile.Flags;
import net.multiphasicapps.classfile.InnerClassFlag;
import net.multiphasicapps.classfile.InvalidClassFormatException;

public final class InnerClassFlags
extends Flags<InnerClassFlag>
implements AccessibleFlags {
    private Reference<ClassFlags> _cflags;

    public InnerClassFlags(int __i) {
        this(Flags.__decode((int)__i, (Flag[])InnerClassFlag.values()));
    }

    public InnerClassFlags(InnerClassFlag ... __fl) {
        super(InnerClassFlag.class, (Flag[])__fl);
        this.__checkFlags();
    }

    public InnerClassFlags(Iterable<InnerClassFlag> __fl) {
        super(InnerClassFlag.class, __fl);
        this.__checkFlags();
    }

    public final ClassFlags asClassFlags() {
        ClassFlags rv;
        Reference<ClassFlags> ref = this._cflags;
        if (ref == null || null == (rv = ref.get())) {
            int mask = 0;
            block9: for (InnerClassFlag i2 : this) {
                ClassFlag v2;
                switch (i2) {
                    case PUBLIC: {
                        v2 = ClassFlag.PUBLIC;
                        break;
                    }
                    case FINAL: {
                        v2 = ClassFlag.FINAL;
                        break;
                    }
                    case INTERFACE: {
                        v2 = ClassFlag.INTERFACE;
                        break;
                    }
                    case ABSTRACT: {
                        v2 = ClassFlag.ABSTRACT;
                        break;
                    }
                    case SYNTHETIC: {
                        v2 = ClassFlag.SYNTHETIC;
                        break;
                    }
                    case ANNOTATION: {
                        v2 = ClassFlag.ANNOTATION;
                        break;
                    }
                    case ENUM: {
                        v2 = ClassFlag.ENUM;
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                if (v2 == null) continue;
                mask |= v2.javaBitMask();
            }
            rv = new ClassFlags(mask);
            this._cflags = new WeakReference<ClassFlags>(rv);
        }
        return rv;
    }

    @Override
    public final boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    @Override
    public final boolean isPrivate() {
        return this.contains(InnerClassFlag.PRIVATE);
    }

    @Override
    public final boolean isProtected() {
        return this.contains(InnerClassFlag.PROTECTED);
    }

    @Override
    public final boolean isPublic() {
        return this.contains(InnerClassFlag.PUBLIC);
    }

    private void __checkFlags() throws InvalidClassFormatException {
        try {
            this.asClassFlags();
        }
        catch (InvalidClassFormatException e2) {
            throw new InvalidClassFormatException(String.format("JC2y %s", this), e2, this);
        }
        int count = (this.isPublic() ? 1 : 0) + (this.isProtected() ? 1 : 0) + (this.isPrivate() ? 1 : 0);
        if (count > 1) {
            throw new InvalidClassFormatException(String.format("JC2z %s", this), this);
        }
    }
}

