/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import net.multiphasicapps.classfile.ByteCodeUtils;
import net.multiphasicapps.classfile.ConstantValueDouble;
import net.multiphasicapps.classfile.ConstantValueFloat;
import net.multiphasicapps.classfile.ConstantValueInteger;
import net.multiphasicapps.classfile.ConstantValueLong;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.ExceptionHandler;
import net.multiphasicapps.classfile.ExceptionHandlerTable;
import net.multiphasicapps.classfile.InstructionJumpTarget;
import net.multiphasicapps.classfile.InstructionJumpTargets;
import net.multiphasicapps.classfile.InstructionMnemonics;
import net.multiphasicapps.classfile.IntMatchingJumpTable;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.Pool;
import net.multiphasicapps.classfile.StackMapTable;
import net.multiphasicapps.classfile.StackMapTableState;

public final class Instruction
implements Contexual {
    protected final int address;
    protected final int op;
    protected final boolean naturalFlow;
    protected final StackMapTableState smtstate;
    protected final InstructionJumpTargets jumptargets;
    protected final int logicalAddress;
    protected final int length;
    protected final int addressFollowing;
    private final Object[] _args;
    private final int[] _rawArgs;
    private Reference<String> _string;
    private Reference<Instruction> _normalized;

    private Instruction(int __address, int __op, boolean __naturalflow, StackMapTableState __smtstate, InstructionJumpTargets __jumptargets, Object[] __args, int[] __rawArgs, int __logicalAddr, int __length, int __addressFollowing) {
        this.address = __address;
        this.op = __op;
        this.naturalFlow = __naturalflow;
        this.smtstate = __smtstate;
        this.jumptargets = __jumptargets;
        this._args = __args;
        this._rawArgs = __rawArgs;
        this.logicalAddress = __logicalAddr;
        this.length = __length;
        this.addressFollowing = __addressFollowing;
    }

    Instruction(byte[] __code, Pool __pool, int __a, ExceptionHandlerTable __eh, StackMapTable __smt, int __af, int __logicalAddr) throws InvalidClassFormatException, NullPointerException {
        int op;
        if (__code == null || __pool == null || __smt == null) {
            throw new NullPointerException("NARG");
        }
        this.smtstate = __smt.get(__a);
        this.op = op = ByteCodeUtils.instructionOpCode(__code, 8, __a);
        this.address = __a;
        this.addressFollowing = __af;
        this.logicalAddress = __logicalAddr;
        this.length = __af - __a;
        int[] rawArgs = ByteCodeUtils.readRawArguments(__code, 8, __a);
        Object[] args = ByteCodeUtils.processArguments(__pool, op, __a, rawArgs);
        boolean naturalFlow = ByteCodeUtils.naturallyFlows(op);
        this._args = args;
        this._rawArgs = rawArgs;
        this.naturalFlow = naturalFlow;
        LinkedHashSet<InstructionJumpTarget> normal = new LinkedHashSet<InstructionJumpTarget>();
        if (naturalFlow) {
            normal.add(new InstructionJumpTarget(__af));
        }
        for (Object v2 : args) {
            if (v2 instanceof InstructionJumpTarget) {
                normal.add((InstructionJumpTarget)v2);
                continue;
            }
            if (!(v2 instanceof IntMatchingJumpTable)) continue;
            for (InstructionJumpTarget j2 : ((IntMatchingJumpTable)v2).targets()) {
                normal.add(j2);
            }
        }
        LinkedHashSet<InstructionJumpTarget> exception = new LinkedHashSet<InstructionJumpTarget>();
        for (ExceptionHandler eh : __eh) {
            if (!eh.inRange(__a)) continue;
            exception.add(new InstructionJumpTarget(eh.handlerAddress()));
        }
        this.jumptargets = new InstructionJumpTargets(normal.toArray(new InstructionJumpTarget[normal.size()]), exception.toArray(new InstructionJumpTarget[exception.size()]));
    }

    public int address() {
        return this.address;
    }

    public int addressFollowing() {
        return this.addressFollowing;
    }

    public <T> T argument(int __i, Class<T> __cl) throws ClassCastException, IndexOutOfBoundsException, NullPointerException {
        if (__cl == null) {
            throw new NullPointerException("NARG");
        }
        return __cl.cast(this._args[__i]);
    }

    public final Object[] arguments() {
        return (Object[])this._args.clone();
    }

    public byte byteArgument(int __i) throws ClassCastException, IndexOutOfBoundsException {
        return this.argument(__i, Number.class).byteValue();
    }

    public int count() {
        return this._args.length;
    }

    public boolean hasNaturalFlow() {
        return this.naturalFlow;
    }

    public int intArgument(int __i) throws ClassCastException, IndexOutOfBoundsException {
        return this.argument(__i, Integer.class);
    }

    public final InstructionJumpTargets jumpTargets() {
        return this.jumptargets;
    }

    public int length() {
        return this.length;
    }

    public final String mnemonic() {
        return InstructionMnemonics.toString(this.op);
    }

    public Instruction normalize() {
        Instruction rv;
        Reference<Instruction> ref = this._normalized;
        if (ref == null || (rv = ref.get()) == null) {
            int logAddr = this.logicalAddress;
            int normalizeTo = -1;
            Object[] normalizeArgs = this._args;
            int[] normalizeRaw = this._rawArgs;
            int op = this.op;
            switch (op) {
                case 167: {
                    normalizeTo = 200;
                    break;
                }
                case 21: {
                    normalizeTo = 50197;
                    break;
                }
                case 22: {
                    normalizeTo = 50198;
                    break;
                }
                case 23: {
                    normalizeTo = 50199;
                    break;
                }
                case 24: {
                    normalizeTo = 50200;
                    break;
                }
                case 25: {
                    normalizeTo = 50201;
                    break;
                }
                case 54: {
                    normalizeTo = 50230;
                    break;
                }
                case 55: {
                    normalizeTo = 50231;
                    break;
                }
                case 56: {
                    normalizeTo = 50232;
                    break;
                }
                case 57: {
                    normalizeTo = 50233;
                    break;
                }
                case 58: {
                    normalizeTo = 50234;
                    break;
                }
                case 132: {
                    normalizeTo = 50308;
                    break;
                }
                case 18: {
                    normalizeTo = 19;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    normalizeTo = 19;
                    normalizeArgs = new Object[]{new ConstantValueInteger(-1 + (op - 2))};
                    normalizeRaw = new int[]{Instruction.__specialRaw(3, logAddr)};
                    break;
                }
                case 16: 
                case 17: {
                    normalizeTo = 19;
                    normalizeArgs = new Object[]{new ConstantValueInteger((Integer)normalizeArgs[0])};
                    normalizeRaw = new int[]{Instruction.__specialRaw(3, logAddr)};
                    break;
                }
                case 9: 
                case 10: {
                    normalizeTo = 20;
                    normalizeArgs = new Object[]{new ConstantValueLong(op - 9)};
                    normalizeRaw = new int[]{Instruction.__specialRaw(5, logAddr)};
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    normalizeTo = 19;
                    normalizeArgs = new Object[]{new ConstantValueFloat(op - 11)};
                    normalizeRaw = new int[]{Instruction.__specialRaw(4, logAddr)};
                    break;
                }
                case 14: 
                case 15: {
                    normalizeTo = 20;
                    normalizeArgs = new Object[]{new ConstantValueDouble(op - 14)};
                    normalizeRaw = new int[]{Instruction.__specialRaw(6, logAddr)};
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    normalizeTo = 50197;
                    normalizeArgs = new Object[]{op - 26};
                    normalizeRaw = new int[]{op - 26};
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    normalizeTo = 50198;
                    normalizeArgs = new Object[]{op - 30};
                    normalizeRaw = new int[]{op - 30};
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    normalizeTo = 50199;
                    normalizeArgs = new Object[]{op - 34};
                    normalizeRaw = new int[]{op - 34};
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    normalizeTo = 50200;
                    normalizeArgs = new Object[]{op - 38};
                    normalizeRaw = new int[]{op - 38};
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    normalizeTo = 50201;
                    normalizeArgs = new Object[]{op - 42};
                    normalizeRaw = new int[]{op - 42};
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    normalizeTo = 50230;
                    normalizeArgs = new Object[]{op - 59};
                    normalizeRaw = new int[]{op - 59};
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    normalizeTo = 50231;
                    normalizeArgs = new Object[]{op - 63};
                    normalizeRaw = new int[]{op - 63};
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    normalizeTo = 50232;
                    normalizeArgs = new Object[]{op - 67};
                    normalizeRaw = new int[]{op - 67};
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    normalizeTo = 50233;
                    normalizeArgs = new Object[]{op - 71};
                    normalizeRaw = new int[]{op - 71};
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    normalizeTo = 50234;
                    normalizeArgs = new Object[]{op - 75};
                    normalizeRaw = new int[]{op - 75};
                }
            }
            rv = normalizeTo >= 0 ? new Instruction(this.address, normalizeTo, this.naturalFlow, this.smtstate, this.jumptargets, normalizeArgs, normalizeRaw, this.logicalAddress, this.length, this.addressFollowing) : this;
            this._normalized = new WeakReference<Instruction>(rv);
        }
        return rv;
    }

    public int operation() {
        return this.op;
    }

    public int[] rawArguments() {
        return (int[])this._rawArgs.clone();
    }

    public final short shortArgument(int __i) throws ClassCastException, IndexOutOfBoundsException {
        return this.argument(__i, Number.class).shortValue();
    }

    public StackMapTableState stackMapTableState() {
        return this.smtstate;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            StringBuilder sb = new StringBuilder("@");
            sb.append(this.address);
            sb.append('#');
            sb.append(InstructionMnemonics.toString(this.op));
            sb.append("(l");
            sb.append(this.length);
            sb.append(')');
            if (this.naturalFlow) {
                sb.append('~');
            }
            sb.append(":[");
            Object[] args = this._args;
            int n2 = args.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(args[i2]);
            }
            sb.append(']');
            sb.append("(~>@");
            sb.append(this.addressFollowing);
            sb.append(")");
            rv = sb.toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    static int __readByte(byte[] __a, int __o) throws InvalidClassFormatException, NullPointerException {
        return (byte)Instruction.__readUnsignedByte(__a, __o);
    }

    static int __readInt(byte[] __a, int __o) throws InvalidClassFormatException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __o + 3 >= __a.length) {
            throw new InvalidClassFormatException(String.format("JC38 %d %d", __o, __a.length));
        }
        return (__a[__o] & 0xFF) << 24 | (__a[__o + 1] & 0xFF) << 16 | (__a[__o + 2] & 0xFF) << 8 | __a[__o + 3] & 0xFF;
    }

    static int __readShort(byte[] __a, int __o) throws InvalidClassFormatException, NullPointerException {
        return (short)Instruction.__readUnsignedShort(__a, __o);
    }

    static int __readUnsignedByte(byte[] __a, int __o) throws InvalidClassFormatException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __o >= __a.length) {
            throw new InvalidClassFormatException(String.format("JC39 %d %d", __o, __a.length));
        }
        return __a[__o] & 0xFF;
    }

    static int __readUnsignedShort(byte[] __a, int __o) throws InvalidClassFormatException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __o + 1 >= __a.length) {
            throw new InvalidClassFormatException(String.format("JC3a %d %d", __o, __a.length));
        }
        return (__a[__o] & 0xFF) << 8 | __a[__o + 1] & 0xFF;
    }

    private static int __specialRaw(int __tag, int __logAddr) {
        return Integer.MIN_VALUE | (__tag & 0xF) << 23 | __logAddr;
    }
}

