/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.JavaType;
import net.multiphasicapps.classfile.StackMapTableEntry;
import net.multiphasicapps.classfile.StackMapTableState;

public enum JavaStackShuffleType {
    DUP("a:aa"),
    DUP_X1("ab:bab"),
    DUP_X2("abc:cabc", "Ab:bAb"),
    DUP2("ab:abab", "A:AA"),
    DUP2_X1("abc:bcabc", "aB:BaB"),
    DUP2_X2("abcd:cdabcd", "abC:CabC", "Abc:bcAbc", "AB:BAB"),
    POP("a:"),
    POP2("ab:", "A:"),
    SWAP("ab:ba");

    final Function[] _functions;

    private JavaStackShuffleType(String ... __fs) {
        int n3 = __fs.length;
        Function[] functions = new Function[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            functions[i2] = Function.__of(__fs[i2]);
        }
        this._functions = functions;
    }

    public final Function findShuffleFunction(StackMapTableState __state) throws InvalidClassFormatException, NullPointerException {
        return JavaStackShuffleType.findShuffleFunction(__state, this);
    }

    public static final Function findShuffleFunction(StackMapTableState __state, JavaStackShuffleType __t) throws InvalidClassFormatException, NullPointerException {
        if (__state == null || __t == null) {
            throw new NullPointerException("NARG");
        }
        List<StackMapTableEntry> stack = __state.getStack();
        int stacktop = __state.depth();
        for (Function tryf : __t._functions) {
            StackMapTableEntry i2;
            JavaType it;
            int at2;
            Slots sls = tryf.in;
            int maxpop = sls.max;
            int basetop = stacktop - maxpop;
            if (basetop < 0) continue;
            int ldx = 0;
            for (at2 = basetop; at2 < stacktop && (it = (i2 = stack.get(at2)).type()).isTop() == sls._var[ldx] < 0 && it.isWide() == sls._wide[ldx]; ++at2) {
                ++ldx;
            }
            if (at2 != stacktop) continue;
            return tryf;
        }
        throw new InvalidClassFormatException("JC1q");
    }

    public static JavaStackShuffleType ofOperation(int __op) throws NoSuchElementException {
        switch (__op) {
            case 87: {
                return POP;
            }
            case 88: {
                return POP2;
            }
            case 89: {
                return DUP;
            }
            case 90: {
                return DUP_X1;
            }
            case 91: {
                return DUP_X2;
            }
            case 92: {
                return DUP2;
            }
            case 93: {
                return DUP2_X1;
            }
            case 94: {
                return DUP2_X2;
            }
            case 95: {
                return SWAP;
            }
        }
        throw new NoSuchElementException("JC91");
    }

    public static final class Slots {
        public final int max;
        public final int logicalMax;
        final byte[] _indexToLogicalSlot;
        final byte[] _var;
        final boolean[] _wide;
        private Reference<String> _string;

        Slots(String __s) throws IllegalArgumentException, NullPointerException {
            if (__s == null) {
                throw new NullPointerException("NARG");
            }
            int n2 = __s.length();
            int max = 0;
            this.logicalMax = n2;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Character.isUpperCase(__s.charAt(i2))) {
                    max += 2;
                    continue;
                }
                ++max;
            }
            byte[] var2 = new byte[max];
            boolean[] wide = new boolean[max];
            int o2 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                char c2 = __s.charAt(i3);
                boolean iswide = Character.isUpperCase(c2);
                var2[o2] = (byte)(Character.toLowerCase(c2) - 97);
                wide[o2++] = iswide;
                if (!iswide) continue;
                var2[o2++] = -1;
            }
            this.max = max;
            this._var = var2;
            this._wide = wide;
            byte[] indexToLogicalSlot = new byte[max];
            int at2 = 0;
            for (int i4 = 0; i4 < n2; ++i4) {
                char c3 = __s.charAt(i4);
                if (c3 >= 'A' && c3 <= 'Z') {
                    indexToLogicalSlot[at2++] = (byte)(c3 - 65);
                    indexToLogicalSlot[at2++] = (byte)(c3 - 65);
                    continue;
                }
                indexToLogicalSlot[at2++] = (byte)(c3 - 97);
            }
            this._indexToLogicalSlot = indexToLogicalSlot;
        }

        public final int findVariableSlot(int __var) {
            if (__var < 0) {
                throw new IllegalArgumentException("JC52");
            }
            int n2 = this.max;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.variable(i2) != __var) continue;
                return i2;
            }
            throw new IllegalArgumentException("JC51 " + __var);
        }

        public JavaType[] javaTypes(StackMapTableState __stackMap) throws NullPointerException {
            if (__stackMap == null) {
                throw new NullPointerException("NARG");
            }
            int logicalMax = this.logicalMax;
            JavaType[] result = new JavaType[logicalMax];
            for (int i2 = 0; i2 < logicalMax; ++i2) {
                result[logicalMax - 1 - i2] = __stackMap.getStackFromLogicalTop((int)i2).type;
            }
            return result;
        }

        public final int logicalSlot(int __dx) {
            return this._indexToLogicalSlot[__dx];
        }

        public int logicalVariable(int __dx) {
            byte[] var2 = this._var;
            int at2 = 0;
            for (byte res : var2) {
                if (res < 0) continue;
                if (at2 == __dx) {
                    return res;
                }
                ++at2;
            }
            throw new IllegalArgumentException("JC53 " + __dx);
        }

        public final String toString() {
            String rv;
            Reference<String> ref = this._string;
            if (ref == null || null == (rv = ref.get())) {
                StringBuilder sb = new StringBuilder("[");
                byte[] var2 = this._var;
                boolean[] wide = this._wide;
                int n2 = this.max;
                for (int i2 = 0; i2 < n2; ++i2) {
                    byte v2 = var2[i2];
                    boolean w2 = wide[i2];
                    if (v2 < 0) {
                        sb.append('+');
                        continue;
                    }
                    char c2 = (char)(97 + v2);
                    sb.append(w2 ? Character.toUpperCase(c2) : c2);
                }
                sb.append(']');
                rv = sb.toString();
                this._string = new WeakReference<String>(rv);
            }
            return rv;
        }

        public final int variable(int __i) {
            return this._var[__i];
        }
    }

    public static final class Function {
        public final Slots in;
        public final Slots out;
        private Reference<String> _string;

        Function(Slots __in, Slots __out) throws NullPointerException {
            if (__in == null || __out == null) {
                throw new NullPointerException("NARG");
            }
            this.in = __in;
            this.out = __out;
        }

        public JavaType[] layerTypes(JavaType ... __inTypes) {
            int outLen = this.out.max;
            JavaType[] rv = new JavaType[outLen];
            Debugging.debugNote("@@layerIn: %s", Arrays.asList(__inTypes));
            int at2 = 0;
            for (int i2 = 0; i2 < outLen; ++i2) {
                int outVar = this.out.variable(i2);
                if (outVar < 0) continue;
                rv[at2++] = __inTypes[this.in.logicalSlot(this.in.findVariableSlot(outVar))];
            }
            return at2 == outLen ? rv : Arrays.copyOf(rv, at2);
        }

        public final String toString() {
            String rv;
            Reference<String> ref = this._string;
            if (ref == null || null == (rv = ref.get())) {
                rv = "[" + this.in + " -> " + this.out + "]";
                this._string = new WeakReference<String>(rv);
            }
            return rv;
        }

        static Function __of(String __s) throws IllegalArgumentException, NullPointerException {
            if (__s == null) {
                throw new NullPointerException("NARG");
            }
            int col = __s.indexOf(58);
            if (col < 0) {
                throw new IllegalArgumentException("JC1d");
            }
            return new Function(new Slots(__s.substring(0, col)), new Slots(__s.substring(col + 1)));
        }
    }
}

