/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.PrimitiveType;
import net.multiphasicapps.classfile.SimpleStorageType;

public final class JavaType
implements Contexual {
    public static final JavaType TOP_LONG = new JavaType(1);
    public static final JavaType TOP_DOUBLE = new JavaType(2);
    public static final JavaType TOP_UNDEFINED = new JavaType(3);
    public static final JavaType NOTHING = new JavaType(4);
    public static final JavaType INTEGER = new JavaType(new FieldDescriptor("I"));
    public static final JavaType LONG = new JavaType(new FieldDescriptor("J"));
    public static final JavaType FLOAT = new JavaType(new FieldDescriptor("F"));
    public static final JavaType DOUBLE = new JavaType(new FieldDescriptor("D"));
    public static final JavaType OBJECT = new JavaType(new FieldDescriptor("Ljava/lang/Object;"));
    public static final JavaType THROWABLE = new JavaType(new FieldDescriptor("Ljava/lang/Throwable;"));
    protected final FieldDescriptor type;
    private final int _internal;
    private Reference<String> _string;

    public JavaType(ClassName __cn) throws NullPointerException {
        this(new FieldDescriptor(__cn.isArray() ? __cn.toString() : "L" + __cn + ";"));
    }

    public JavaType(FieldDescriptor __f) throws IllegalStateException, NullPointerException {
        if (__f == null) {
            throw new NullPointerException("NARG");
        }
        PrimitiveType p2 = __f.primitiveType();
        if (p2 != null && p2.promotesToInt()) {
            __f = new FieldDescriptor("I");
        }
        this._internal = 0;
        this.type = __f;
    }

    private JavaType(int __i) throws RuntimeException {
        if (__i == 0) {
            throw Debugging.oops();
        }
        this._internal = __i;
        this.type = null;
    }

    public final ClassName className() {
        FieldDescriptor type = this.type;
        if (type == null) {
            return null;
        }
        return type.className();
    }

    public boolean equals(Object __o) {
        if (!(__o instanceof JavaType)) {
            return false;
        }
        JavaType o2 = (JavaType)__o;
        return this._internal == o2._internal && Objects.equals(this.type, o2.type);
    }

    public int hashCode() {
        return this._internal ^ Objects.hashCode(this.type);
    }

    public final boolean isArray() {
        FieldDescriptor type = this.type;
        return type != null && type.isObject() && type.isArray();
    }

    public boolean isObject() {
        FieldDescriptor type = this.type;
        return type != null && type.isObject();
    }

    public boolean isPrimitive() {
        FieldDescriptor type = this.type;
        return type != null && type.isPrimitive();
    }

    public boolean isNothing() {
        return this.equals(NOTHING);
    }

    public boolean isTop() {
        return this.equals(TOP_LONG) || this.equals(TOP_DOUBLE) || this.equals(TOP_UNDEFINED);
    }

    public boolean isWide() {
        FieldDescriptor type = this.type;
        if (type == null) {
            return false;
        }
        PrimitiveType pt = type.primitiveType();
        return pt != null && pt.isWide();
    }

    public final SimpleStorageType simpleStorageType() {
        return this.type.simpleStorageType();
    }

    public JavaType topType() {
        PrimitiveType pt = this.type.primitiveType();
        if (pt == null) {
            return null;
        }
        switch (pt) {
            case LONG: {
                return TOP_LONG;
            }
            case DOUBLE: {
                return TOP_DOUBLE;
            }
        }
        return null;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = this.equals(TOP_LONG) ? "top-long" : (this.equals(TOP_DOUBLE) ? "top-double" : (this.equals(TOP_UNDEFINED) ? "top-undefined" : (this.equals(NOTHING) ? "nothing" : this.type.toString())));
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public FieldDescriptor type() {
        return this.type;
    }

    public int width() {
        return this.isWide() ? 2 : 1;
    }
}

