/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import net.multiphasicapps.classfile.InstructionJumpTarget;
import net.multiphasicapps.classfile.IntMatchingJumpTable;
import net.multiphasicapps.classfile.InvalidClassFormatException;

public final class LookupSwitch
implements IntMatchingJumpTable {
    protected final InstructionJumpTarget defaultjump;
    private final int[] _keys;
    private final InstructionJumpTarget[] _jumps;
    private Reference<String> _string;

    public LookupSwitch(InstructionJumpTarget __def, int[] __keys, InstructionJumpTarget[] __jumps) throws IllegalArgumentException, InvalidClassFormatException, NullPointerException {
        if (__def == null || __keys == null || __jumps == null) {
            throw new NullPointerException("NARG");
        }
        if (__keys.length != __jumps.length) {
            throw new IllegalArgumentException("JC3c");
        }
        __keys = (int[])__keys.clone();
        __jumps = (InstructionJumpTarget[])__jumps.clone();
        long last = -2147483649L;
        int n2 = __keys.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int k2 = __keys[i2];
            if ((long)k2 < last) {
                throw new InvalidClassFormatException(String.format("JC3d %d %d %d", i2, k2, last), this);
            }
            last = k2;
            if (__jumps[i2] != null) continue;
            throw new NullPointerException("NARG");
        }
        this.defaultjump = __def;
        this._keys = __keys;
        this._jumps = __jumps;
    }

    public final InstructionJumpTarget defaultJump() {
        return this.defaultjump;
    }

    public final InstructionJumpTarget[] jumps() {
        return (InstructionJumpTarget[])this._jumps.clone();
    }

    public final int[] keys() {
        return (int[])this._keys.clone();
    }

    @Override
    public final InstructionJumpTarget match(int __k) {
        int dx = Arrays.binarySearch(this._keys, __k);
        if (dx >= 0) {
            return this._jumps[dx];
        }
        return this.defaultjump;
    }

    public final int size() {
        return this._jumps.length;
    }

    @Override
    public final InstructionJumpTarget[] targets() {
        InstructionJumpTarget[] jumps = this._jumps;
        int n2 = jumps.length;
        InstructionJumpTarget[] rv = new InstructionJumpTarget[n2 + 1];
        rv[0] = this.defaultjump;
        int i2 = 0;
        int o2 = 1;
        while (i2 < n2) {
            rv[o2] = jumps[i2];
            ++i2;
            ++o2;
        }
        return rv;
    }

    public final String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            StringBuilder sb = new StringBuilder("{default=");
            sb.append(this.defaultjump);
            int[] keys = this._keys;
            InstructionJumpTarget[] jumps = this._jumps;
            int n2 = keys.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                sb.append(", ");
                sb.append(keys[i2]);
                sb.append('=');
                sb.append(jumps[i2]);
            }
            sb.append('}');
            rv = sb.toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }
}

