/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import net.multiphasicapps.classfile.Annotated;
import net.multiphasicapps.classfile.AnnotationTable;
import net.multiphasicapps.classfile.Attribute;
import net.multiphasicapps.classfile.AttributeTable;
import net.multiphasicapps.classfile.ByteCode;
import net.multiphasicapps.classfile.ClassFlags;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.ClassVersion;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.Member;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodFlags;
import net.multiphasicapps.classfile.MethodHandle;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.MethodNameAndType;
import net.multiphasicapps.classfile.NameAndType;
import net.multiphasicapps.classfile.Pool;
import net.multiphasicapps.classfile.UTFConstantEntry;

public final class Method
extends Member
implements Annotated {
    protected final ClassVersion version;
    protected final ClassFlags classflags;
    protected final ClassName classname;
    protected final Pool pool;
    protected final MethodFlags methodflags;
    protected final MethodName methodname;
    protected final MethodDescriptor methodtype;
    protected final boolean hascode;
    protected final int methodIndex;
    protected final AnnotationTable annotations;
    private final byte[] _rawcodeattr;
    private Reference<ByteCode> _bytecode;
    private Reference<MethodNameAndType> _nameandtype;
    private Reference<MethodHandle> _index;

    Method(ClassVersion __ver, ClassFlags __cf, ClassName __tn, Pool __pool, MethodFlags __mf, MethodName __mn, MethodDescriptor __mt, byte[] __mc, AnnotationTable __avs, int __index) throws NullPointerException {
        if (__ver == null || __cf == null || __tn == null || __pool == null || __mf == null || __mn == null || __mt == null || __avs == null) {
            throw new NullPointerException("NARG");
        }
        this.version = __ver;
        this.classflags = __cf;
        this.classname = __tn;
        this.pool = __pool;
        this.methodflags = __mf;
        this.methodname = __mn;
        this.methodtype = __mt;
        this.annotations = __avs;
        this._rawcodeattr = __mc;
        this.hascode = !__mf.isNative() && !__mf.isAbstract();
        this.methodIndex = __index;
    }

    @Override
    public final AnnotationTable annotationTable() {
        return this.annotations;
    }

    public int argumentSlotCount() {
        return (this.methodflags.isStatic() ? 0 : 1) + this.methodtype.argumentSlotCount();
    }

    public final ByteCode byteCode() throws InvalidClassFormatException {
        ByteCode rv;
        byte[] rawcodeattr = this._rawcodeattr;
        if (!this.hascode) {
            return null;
        }
        Reference<ByteCode> ref = this._bytecode;
        if (ref == null || null == (rv = ref.get())) {
            rv = new ByteCode(new WeakReference<Method>(this), this._rawcodeattr, this.classname, this.methodflags);
            this._bytecode = new WeakReference<ByteCode>(rv);
        }
        return rv;
    }

    @Override
    public final MethodFlags flags() {
        return this.methodflags;
    }

    public final MethodHandle handle() {
        MethodHandle rv;
        Reference<MethodHandle> ref = this._index;
        if (ref == null || null == (rv = ref.get())) {
            rv = new MethodHandle(this.classname, this.methodname, this.methodtype);
            this._index = new WeakReference<MethodHandle>(rv);
        }
        return rv;
    }

    public ClassName inClass() {
        return this.classname;
    }

    public boolean isEffectivelyFinal() {
        return this.methodflags.isFinal() || this.classflags.isFinal();
    }

    public final boolean isInstanceInitializer() {
        return this.methodname.isInstanceInitializer();
    }

    public final boolean isStaticInitializer() {
        return this.methodname.isStaticInitializer();
    }

    public final int methodIndex() {
        return this.methodIndex;
    }

    public final MethodName name() {
        return this.methodname;
    }

    @Override
    public final MethodNameAndType nameAndType() {
        MethodNameAndType rv;
        Reference<MethodNameAndType> ref = this._nameandtype;
        if (ref == null || null == (rv = ref.get())) {
            rv = new MethodNameAndType(this.methodname, this.methodtype);
            this._nameandtype = new WeakReference<MethodNameAndType>(rv);
        }
        return rv;
    }

    public final Pool pool() {
        return this.pool;
    }

    public final MethodDescriptor type() {
        return this.methodtype;
    }

    public static Method[] decode(ClassVersion __ver, ClassName __tn, ClassFlags __cf, Pool __pool, DataInputStream __in) throws InvalidClassFormatException, IOException, NullPointerException {
        if (__ver == null || __tn == null || __cf == null || __pool == null || __in == null) {
            throw new NullPointerException("NARG");
        }
        int nm = __in.readUnsignedShort();
        Method[] rv = new Method[nm];
        HashSet<NameAndType> dup = new HashSet<NameAndType>();
        for (int i2 = 0; i2 < nm; ++i2) {
            MethodName name;
            int rawflags = __in.readUnsignedShort();
            int nameDx = __in.readUnsignedShort();
            try {
                name = new MethodName(__pool.require(UTFConstantEntry.class, nameDx).toString());
            }
            catch (InvalidClassFormatException __e) {
                throw new InvalidClassFormatException(String.format("JC5a %d %d %s", nm, nameDx, __pool.get(Object.class, nameDx)), __e);
            }
            MethodFlags flags = new MethodFlags(__cf, name, rawflags);
            MethodDescriptor type = new MethodDescriptor(__pool.require(UTFConstantEntry.class, __in.readUnsignedShort()).toString());
            if (!dup.add(new NameAndType(name.toString(), type.toString()))) {
                throw new InvalidClassFormatException(String.format("JC3f %s %s", name, type));
            }
            AttributeTable attrs = AttributeTable.parse(__pool, __in);
            AnnotationTable annotations = AnnotationTable.parse(__pool, attrs);
            Attribute maybecode = attrs.get("Code");
            byte[] code = maybecode == null ? null : maybecode.bytes();
            if (code == null != (flags.isAbstract() | flags.isNative())) {
                throw new InvalidClassFormatException(String.format("JC3g %s %s %s %s", __tn, name, type, flags));
            }
            rv[i2] = new Method(__ver, __cf, __tn, __pool, flags, name, type, code, annotations, i2);
        }
        return rv;
    }
}

