/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.util.ArrayList;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.JavaType;
import net.multiphasicapps.classfile.MemberDescriptor;

public final class MethodDescriptor
implements Comparable<MethodDescriptor>,
MemberDescriptor {
    protected final String string;
    protected final FieldDescriptor rvalue;
    private final FieldDescriptor[] _args;

    public MethodDescriptor(FieldDescriptor __rv, FieldDescriptor ... __args) throws InvalidClassFormatException, NullPointerException {
        if (__args == null) {
            throw new NullPointerException("NARG");
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (FieldDescriptor f2 : __args = (FieldDescriptor[])__args.clone()) {
            if (f2 == null) {
                throw new NullPointerException("NARG");
            }
            sb.append(f2.toString());
        }
        sb.append(')');
        sb.append(__rv == null ? "V" : __rv.toString());
        this.rvalue = __rv;
        this._args = __args;
        this.string = sb.toString();
    }

    public MethodDescriptor(String __n) throws InvalidClassFormatException, NullPointerException {
        char c2;
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        this.string = __n;
        if (!__n.startsWith("(")) {
            throw new InvalidClassFormatException(String.format("JC3h %s", __n), this);
        }
        ArrayList<FieldDescriptor> args = new ArrayList<FieldDescriptor>();
        int i2 = 1;
        int n2 = __n.length();
        while (i2 < n2 && (c2 = __n.charAt(i2)) != ')') {
            int at2;
            for (at2 = i2; at2 < n2 && '[' == __n.charAt(at2); ++at2) {
            }
            if (at2 >= n2) {
                throw new InvalidClassFormatException(String.format("JC3i %s", __n), this);
            }
            switch (__n.charAt(at2)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    break;
                }
                case 'L': {
                    while (at2 < n2 && ';' != __n.charAt(at2)) {
                        ++at2;
                    }
                    break;
                }
                default: {
                    throw new InvalidClassFormatException(String.format("JC3j %s", __n), this);
                }
            }
            args.add(new FieldDescriptor(__n.substring(i2, at2 + 1)));
            i2 = at2 + 1;
        }
        this._args = args.toArray(new FieldDescriptor[args.size()]);
        if (++i2 >= n2) {
            throw new InvalidClassFormatException(String.format("JC3k %s", __n), this);
        }
        c2 = __n.charAt(i2);
        this.rvalue = c2 == 'V' && i2 + 1 == n2 ? null : new FieldDescriptor(__n.substring(i2));
    }

    public FieldDescriptor argument(int __i) throws IndexOutOfBoundsException {
        return this._args[__i];
    }

    public int argumentSlotCount() {
        int total = 0;
        for (FieldDescriptor desc : this._args) {
            total += desc.isWide() ? 2 : 1;
        }
        return total;
    }

    public FieldDescriptor[] arguments() {
        return (FieldDescriptor[])this._args.clone();
    }

    public int argumentCount() {
        return this._args.length;
    }

    @Override
    public int compareTo(MethodDescriptor __other) {
        FieldDescriptor bReturn;
        if (__other == null) {
            throw new NullPointerException("NARG");
        }
        if (__other == this) {
            return 0;
        }
        FieldDescriptor[] aList = this._args;
        FieldDescriptor[] bList = __other._args;
        int aLen = aList.length;
        int bLen = bList.length;
        int n2 = Math.min(aLen, bLen);
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldDescriptor a2 = aList[i2];
            FieldDescriptor b2 = bList[i2];
            int compare = a2.compareTo(b2);
            if (compare == 0) continue;
            return compare;
        }
        if (aLen != bLen) {
            return bLen - aLen;
        }
        FieldDescriptor aReturn = this.rvalue;
        if (aReturn == null != ((bReturn = __other.rvalue) == null)) {
            if (aReturn == null) {
                return -1;
            }
            return 1;
        }
        if (aReturn != null) {
            return aReturn.compareTo(bReturn);
        }
        return 0;
    }

    public boolean equals(Object __o) {
        if (__o == this) {
            return true;
        }
        if (!(__o instanceof MethodDescriptor)) {
            return false;
        }
        return this.string.equals(((MethodDescriptor)__o).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public final boolean hasReturnValue() {
        return null != this.rvalue;
    }

    public JavaType[] javaStack() {
        int n2 = this.argumentCount();
        ArrayList<JavaType> rv = new ArrayList<JavaType>(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType j2 = new JavaType(this.argument(i2));
            rv.add(j2);
            if (!j2.isWide()) continue;
            rv.add(j2.topType());
        }
        return rv.toArray(new JavaType[rv.size()]);
    }

    public FieldDescriptor returnValue() {
        return this.rvalue;
    }

    public String toString() {
        return this.string;
    }

    public static MethodDescriptor ofArguments(String __rv, String ... __args) throws NullPointerException {
        if (__args == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __args.length;
        FieldDescriptor[] args = new FieldDescriptor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            args[i2] = new FieldDescriptor(__args[i2]);
        }
        return new MethodDescriptor(__rv == null ? null : new FieldDescriptor(__rv), args);
    }

    public static MethodDescriptor ofArguments(FieldDescriptor __rv, FieldDescriptor ... __args) throws NullPointerException {
        if (__args == null) {
            throw new NullPointerException("NARG");
        }
        return new MethodDescriptor(__rv, (FieldDescriptor[])__args.clone());
    }
}

