/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import net.multiphasicapps.classfile.ClassFlags;
import net.multiphasicapps.classfile.Flag;
import net.multiphasicapps.classfile.Flags;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.MemberFlag;
import net.multiphasicapps.classfile.MemberFlags;
import net.multiphasicapps.classfile.MethodFlag;
import net.multiphasicapps.classfile.MethodName;

public final class MethodFlags
extends MemberFlags<MethodFlag> {
    public MethodFlags(int __i) {
        super(MethodFlag.class, Flags.__decode((int)__i, (Flag[])MethodFlag.values()));
    }

    public MethodFlags(ClassFlags __oc, MethodName __mn, MethodFlag ... __fl) {
        super(MethodFlag.class, (MemberFlag[])__fl);
        this.__checkFlags(__oc, __mn);
    }

    public MethodFlags(ClassFlags __oc, MethodName __mn, Iterable<MethodFlag> __fl) {
        super(MethodFlag.class, __fl);
        this.__checkFlags(__oc, __mn);
    }

    public MethodFlags(ClassFlags __oc, MethodName __mn, int __i) {
        this(__oc, __mn, Flags.__decode((int)__i, (Flag[])MethodFlag.values()));
    }

    public boolean isAbstract() {
        return this.contains(MethodFlag.ABSTRACT);
    }

    public boolean isBridge() {
        return this.contains(MethodFlag.BRIDGE);
    }

    @Override
    public boolean isFinal() {
        return this.contains(MethodFlag.FINAL);
    }

    public boolean isNative() {
        return this.contains(MethodFlag.NATIVE);
    }

    @Override
    public boolean isPrivate() {
        return this.contains(MethodFlag.PRIVATE);
    }

    @Override
    public boolean isProtected() {
        return this.contains(MethodFlag.PROTECTED);
    }

    @Override
    public boolean isPublic() {
        return this.contains(MethodFlag.PUBLIC);
    }

    @Override
    public boolean isStatic() {
        return this.contains(MethodFlag.STATIC);
    }

    public boolean isStrict() {
        return this.contains(MethodFlag.STRICT);
    }

    public boolean isSynchronized() {
        return this.contains(MethodFlag.SYNCHRONIZED);
    }

    @Override
    public boolean isSynthetic() {
        return this.contains(MethodFlag.SYNTHETIC);
    }

    public boolean isVarArgs() {
        return this.contains(MethodFlag.VARARGS);
    }

    private void __checkFlags(ClassFlags __oc, MethodName __mn) throws InvalidClassFormatException {
        if (__oc == null || __mn == null) {
            throw new NullPointerException("NARG");
        }
        if (this.isAbstract() && (this.isPrivate() || this.isStatic() || this.isFinal() || this.isSynchronized() || this.isNative() || this.isStrict())) {
            throw new InvalidClassFormatException(String.format("JC3l %s", this), this);
        }
        if (__oc.isInterface() && !__mn.isStaticInitializer()) {
            for (MethodFlag f2 : MethodFlag.values()) {
                boolean must = f2 == MethodFlag.PUBLIC || f2 == MethodFlag.ABSTRACT;
                boolean maybe = f2 == MethodFlag.SYNTHETIC || f2 == MethodFlag.VARARGS || f2 == MethodFlag.BRIDGE;
                boolean has = this.contains(f2);
                if (must == has || maybe) continue;
                throw new InvalidClassFormatException(String.format("JC3m %s", this), this);
            }
        }
    }
}

