/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.JavaType;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.MethodNameAndType;

public final class MethodHandle
implements Comparable<MethodHandle> {
    protected final ClassName outerclass;
    protected final MethodName name;
    protected final MethodDescriptor descriptor;
    private Reference<MethodNameAndType> _nat;
    private Reference<String> _string;

    public MethodHandle(ClassName __cl, MethodName __n, MethodDescriptor __d) throws NullPointerException {
        if (__cl == null || __n == null || __d == null) {
            throw new NullPointerException("NARG");
        }
        this.outerclass = __cl;
        this.name = __n;
        this.descriptor = __d;
    }

    @Override
    public int compareTo(MethodHandle __o) {
        int rv = this.outerclass.compareTo(__o.outerclass);
        if (rv != 0) {
            return rv;
        }
        rv = this.name.compareTo(__o.name);
        if (rv != 0) {
            return rv;
        }
        return this.descriptor.toString().compareTo(__o.descriptor.toString());
    }

    public MethodDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean equals(Object __o) {
        if (this == __o) {
            return true;
        }
        if (!(__o instanceof MethodHandle)) {
            return false;
        }
        MethodHandle o2 = (MethodHandle)__o;
        return this.outerclass.equals(o2.outerclass) && this.name.equals(o2.name) && this.descriptor.equals(o2.descriptor);
    }

    public int hashCode() {
        return this.outerclass.hashCode() ^ this.name.hashCode() ^ this.descriptor.hashCode();
    }

    public boolean isInstanceInitializer() {
        return this.name.isInstanceInitializer();
    }

    public JavaType[] javaStack(boolean __i) {
        JavaType[] djs = this.descriptor.javaStack();
        if (!__i) {
            return djs;
        }
        int dn2 = djs.length;
        JavaType[] rv = new JavaType[dn2 + 1];
        rv[0] = new JavaType(this.outerclass);
        int i2 = 0;
        int o2 = 1;
        while (i2 < dn2) {
            rv[o2] = djs[i2];
            ++i2;
            ++o2;
        }
        return rv;
    }

    public MethodName name() {
        return this.name;
    }

    public final MethodNameAndType nameAndType() {
        MethodNameAndType rv;
        Reference<MethodNameAndType> ref = this._nat;
        if (ref == null || null == (rv = ref.get())) {
            rv = new MethodNameAndType(this.name, this.descriptor);
            this._nat = new WeakReference<MethodNameAndType>(rv);
        }
        return rv;
    }

    public ClassName outerClass() {
        return this.outerclass;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = String.format("%s::%s%s", this.outerclass, this.name, this.descriptor);
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }
}

