/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Arrays;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.ConstantValueDouble;
import net.multiphasicapps.classfile.ConstantValueFloat;
import net.multiphasicapps.classfile.ConstantValueInteger;
import net.multiphasicapps.classfile.ConstantValueLong;
import net.multiphasicapps.classfile.ConstantValueString;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.FieldName;
import net.multiphasicapps.classfile.FieldReference;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.MethodReference;
import net.multiphasicapps.classfile.NameAndType;
import net.multiphasicapps.classfile.UTFConstantEntry;
import net.multiphasicapps.classfile.UnsupportedInvokeDynamic;
import net.multiphasicapps.classfile.WideConstantTopEntry;

public final class Pool
implements Contexual {
    public static final int TAG_UTF8 = 1;
    public static final int TAG_INTEGER = 3;
    public static final int TAG_FLOAT = 4;
    public static final int TAG_LONG = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_CLASS = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_FIELDREF = 9;
    public static final int TAG_METHODREF = 10;
    public static final int TAG_INTERFACEMETHODREF = 11;
    public static final int TAG_NAMEANDTYPE = 12;
    public static final int TAG_METHODHANDLE = 15;
    public static final int TAG_METHODTYPE = 16;
    public static final int TAG_INVOKEDYNAMIC = 18;
    public static final int TAG_WIDETOP = -1;
    private final Object[] _combined;
    private final Object[] _entries;
    private final int[] _tags;
    private final byte[] _rawBytes;

    Pool(byte[] __rawBytes, Object[] __combined, int[] __tags, Object ... __e) {
        this._rawBytes = __rawBytes;
        this._combined = __combined;
        this._tags = __tags;
        this._entries = __e == null ? new Object[]{} : __e;
    }

    public <C> C get(Class<C> __cl, int __i) throws InvalidClassFormatException, NullPointerException {
        if (__cl == null) {
            throw new NullPointerException("NARG");
        }
        if (__i == 0) {
            return null;
        }
        Object[] entries = this._entries;
        if (__i < 0 || __i >= entries.length) {
            throw new InvalidClassFormatException(String.format("JC3o %d", __i), this);
        }
        Object val2 = entries[__i];
        if (val2 != null && !__cl.isInstance(val2)) {
            throw new InvalidClassFormatException(String.format("JC3p %d %s %s", __i, val2.getClass(), __cl), this);
        }
        return __cl.cast(val2);
    }

    public byte[] rawData() {
        return this._rawBytes;
    }

    public Object rawData(int __i) {
        Object[] combined = this._combined;
        if (__i < 0 || __i >= combined.length) {
            throw new InvalidClassFormatException(String.format("JC3o %d", __i), this);
        }
        return combined[__i];
    }

    public <C> C require(Class<C> __cl, int __i) throws InvalidClassFormatException, NullPointerException {
        C rv = this.get(__cl, __i);
        if (rv == null) {
            throw new InvalidClassFormatException(String.format("JC3q %d %s", __i, __cl), this);
        }
        return rv;
    }

    public int size() {
        return this._entries.length;
    }

    public int[] tags() {
        return (int[])this._tags.clone();
    }

    public static Pool decode(DataInputStream __in) throws InvalidClassFormatException, IOException, NullPointerException {
        return Pool.decode(__in, -1);
    }

    public static Pool decode(DataInputStream __in, int __count) throws InvalidClassFormatException, IOException, NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        ByteArrayOutputStream rawBytes = new ByteArrayOutputStream();
        DataOutputStream raw = new DataOutputStream(rawBytes);
        int count = __count < 0 ? __in.readUnsignedShort() : __count;
        Object[] combinedData = new Object[count];
        int[] tags = new int[count];
        Object[] rawdata = new Object[count];
        for (int i2 = 1; i2 < count; ++i2) {
            Object data;
            int tag;
            tags[i2] = tag = __in.readUnsignedByte();
            raw.writeByte(tag);
            switch (tag) {
                case 1: {
                    try {
                        data = new UTFConstantEntry(__in.readUTF());
                        raw.writeUTF(data.toString());
                        break;
                    }
                    catch (UTFDataFormatException e2) {
                        throw new InvalidClassFormatException("JC3r", e2);
                    }
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    data = new int[]{__in.readUnsignedShort(), __in.readUnsignedShort()};
                    raw.writeShort(((int[])data)[0]);
                    raw.writeShort(((int[])data)[1]);
                    break;
                }
                case 7: 
                case 8: {
                    data = new int[]{__in.readUnsignedShort()};
                    raw.writeShort(((int[])data)[0]);
                    break;
                }
                case 3: {
                    data = new ConstantValueInteger(__in.readInt());
                    raw.writeInt(((ConstantValueInteger)data).intValue());
                    break;
                }
                case 5: {
                    data = new ConstantValueLong(__in.readLong());
                    raw.writeLong(((ConstantValueLong)data).longValue());
                    break;
                }
                case 4: {
                    data = new ConstantValueFloat(Float.valueOf(__in.readFloat()).floatValue());
                    raw.writeFloat(((ConstantValueFloat)data).floatValue());
                    break;
                }
                case 6: {
                    data = new ConstantValueDouble(__in.readDouble());
                    raw.writeDouble(((ConstantValueDouble)data).doubleValue());
                    break;
                }
                case 15: {
                    __in.readByte();
                    __in.readShort();
                    data = new UnsupportedInvokeDynamic();
                    break;
                }
                case 16: {
                    __in.readShort();
                    data = new UnsupportedInvokeDynamic();
                    break;
                }
                case 18: {
                    __in.readShort();
                    __in.readShort();
                    data = new UnsupportedInvokeDynamic();
                    break;
                }
                default: {
                    throw new InvalidClassFormatException(String.format("JC3t %d", tag));
                }
            }
            rawdata[i2] = data;
            combinedData[i2] = data;
            if (tag != 5 && tag != 6) continue;
            rawdata[++i2] = new WideConstantTopEntry();
            tags[i2] = -1;
        }
        Object[] entries = new Object[count];
        try {
            Pool.__initializeEntries(entries, tags, rawdata);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e3) {
            throw new InvalidClassFormatException("JC3u", e3);
        }
        return new Pool(rawBytes.toByteArray(), combinedData, tags, entries);
    }

    private static void __initializeEntries(Object[] __entries, int[] __tags, Object[] __rawdata) throws InvalidClassFormatException, NullPointerException {
        if (__entries == null || __tags == null || __rawdata == null) {
            throw new NullPointerException("NARG");
        }
        int count = __entries.length;
        int[] order = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            int sequence;
            int tag = __tags[i2];
            switch (tag) {
                case -1: 
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    sequence = 0;
                    break;
                }
                case 7: 
                case 8: {
                    sequence = 1;
                    break;
                }
                case 12: {
                    sequence = 2;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    sequence = 3;
                    break;
                }
                case 15: 
                case 16: 
                case 18: {
                    sequence = 3;
                    break;
                }
                default: {
                    throw Debugging.oops();
                }
            }
            order[i2] = sequence << 16 | i2;
        }
        Arrays.sort(order);
        for (int j2 = 0; j2 < count; ++j2) {
            Object out;
            int i3 = order[j2] & 0xFFFF;
            int tag = __tags[i3];
            Object in = __rawdata[i3];
            switch (tag) {
                case -1: 
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    out = in;
                    break;
                }
                case 7: {
                    out = new ClassName(__entries[((int[])in)[0]].toString());
                    break;
                }
                case 8: {
                    out = new ConstantValueString(__entries[((int[])in)[0]].toString());
                    break;
                }
                case 12: {
                    int[] ina = (int[])in;
                    out = new NameAndType(__entries[ina[0]].toString(), __entries[ina[1]].toString());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    int[] ina = (int[])in;
                    ClassName cn2 = (ClassName)__entries[ina[0]];
                    NameAndType nat = (NameAndType)__entries[ina[1]];
                    if (tag == 9) {
                        out = new FieldReference(cn2, new FieldName(nat.name()), new FieldDescriptor(nat.type()));
                        break;
                    }
                    out = new MethodReference(cn2, new MethodName(nat.name()), new MethodDescriptor(nat.type()), tag == 11);
                    break;
                }
                case 15: 
                case 16: 
                case 18: {
                    out = in;
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("OOPS %d", tag));
                }
            }
            __entries[i3] = out;
        }
    }
}

