/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.JavaType;

public final class StackMapTableEntry
implements Contexual {
    public static final StackMapTableEntry TOP_LONG = new StackMapTableEntry(JavaType.TOP_LONG, true);
    public static final StackMapTableEntry TOP_DOUBLE = new StackMapTableEntry(JavaType.TOP_DOUBLE, true);
    public static final StackMapTableEntry TOP_UNDEFINED = new StackMapTableEntry(JavaType.TOP_UNDEFINED, true);
    public static final StackMapTableEntry NOTHING = new StackMapTableEntry(JavaType.NOTHING, false);
    public static final StackMapTableEntry INTEGER = new StackMapTableEntry(JavaType.INTEGER, true);
    public static final StackMapTableEntry LONG = new StackMapTableEntry(JavaType.LONG, true);
    public static final StackMapTableEntry FLOAT = new StackMapTableEntry(JavaType.FLOAT, true);
    public static final StackMapTableEntry DOUBLE = new StackMapTableEntry(JavaType.DOUBLE, true);
    public static final StackMapTableEntry INITIALIZED_OBJECT = new StackMapTableEntry(JavaType.OBJECT, true);
    protected final JavaType type;
    protected final boolean isinitialized;
    private Reference<String> _string;

    public StackMapTableEntry(FieldDescriptor __t, boolean __init) throws InvalidClassFormatException, NullPointerException {
        this(new JavaType(__t), __init);
    }

    public StackMapTableEntry(JavaType __t, boolean __init) throws InvalidClassFormatException, NullPointerException {
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        if (__t.equals(JavaType.NOTHING)) {
            if (__init && __t.equals(JavaType.NOTHING)) {
                throw new InvalidClassFormatException(String.format("JI3w %s", __t), this);
            }
        } else if (!__init && !__t.isObject()) {
            throw new InvalidClassFormatException(String.format("JC3w %s", __t), this);
        }
        this.type = __t;
        this.isinitialized = __init;
    }

    public boolean equals(Object __o) {
        if (!(__o instanceof StackMapTableEntry)) {
            return false;
        }
        StackMapTableEntry o2 = (StackMapTableEntry)__o;
        return this.type.equals(o2.type) && this.isinitialized == o2.isinitialized;
    }

    public int hashCode() {
        return this.type.hashCode() ^ (this.isinitialized ? 1 : 0);
    }

    public boolean isInitialized() {
        return this.isinitialized;
    }

    public boolean isNothing() {
        return this.type.isNothing();
    }

    public final boolean isTop() {
        JavaType type = this.type;
        return type != null && type.isTop();
    }

    public boolean isWide() {
        JavaType t2 = this.type;
        return t2 != null && t2.isWide();
    }

    public final StackMapTableEntry topType() {
        if (this.equals(LONG)) {
            return TOP_LONG;
        }
        if (this.equals(DOUBLE)) {
            return TOP_DOUBLE;
        }
        return null;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = String.format("%s%s", this.isinitialized ? "" : "!", this.type);
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    public JavaType type() {
        return this.type;
    }
}

