/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.JavaStackShuffleType;
import net.multiphasicapps.classfile.JavaType;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodReference;
import net.multiphasicapps.classfile.StackMapTableEntry;
import net.multiphasicapps.collections.UnmodifiableList;

public final class StackMapTableState
implements Contexual {
    protected final int depth;
    private final StackMapTableEntry[] _locals;
    private final StackMapTableEntry[] _stack;
    private Reference<String> _string;

    public StackMapTableState(StackMapTableEntry[] __l, StackMapTableEntry[] __s, int __d) throws InvalidClassFormatException, NullPointerException {
        this(__l, __s, __d, true);
    }

    StackMapTableState(StackMapTableEntry[] __l, StackMapTableEntry[] __s, int __d, boolean __copyDefensive) throws InvalidClassFormatException, NullPointerException {
        if (__l == null || __s == null) {
            throw new NullPointerException("NARG");
        }
        int ns = __s.length;
        if (__d < 0 || __d > ns) {
            throw new InvalidClassFormatException(String.format("JC3x %d %d", __d, ns), this);
        }
        if (__copyDefensive) {
            __l = (StackMapTableEntry[])__l.clone();
            __s = (StackMapTableEntry[])__s.clone();
        }
        for (int i2 = __d; i2 < ns; ++i2) {
            __s[i2] = null;
        }
        StackMapTableState.__verify(__l);
        StackMapTableState.__verify(__s);
        this._locals = __l;
        this._stack = __s;
        this.depth = __d;
    }

    public int depth() {
        return this.depth;
    }

    public StackMapTableState deriveLocalLoad(int __dx) {
        return this.deriveStackPush(this.getLocal(__dx));
    }

    public StackMapTableState deriveLocalSet(int __dx, StackMapTableEntry __entry) throws InvalidClassFormatException, NullPointerException {
        if (__entry == null) {
            throw new NullPointerException("NARG");
        }
        if (__dx < 0 || __dx >= this.maxLocals() || __entry.isWide() && __dx >= this.maxLocals() - 1) {
            throw new InvalidClassFormatException("JC02", this);
        }
        StackMapTableEntry[] newLocals = (StackMapTableEntry[])this._locals.clone();
        newLocals[__dx] = __entry;
        if (__entry.isWide()) {
            newLocals[__dx + 1] = __entry.topType();
        }
        return new StackMapTableState(newLocals, this._stack, this.depth, false);
    }

    public StackMapTableState deriveLocalStore(int __dx) {
        ArrayList<StackMapTableEntry> popped = new ArrayList<StackMapTableEntry>();
        StackMapTableState result = this.deriveStackPop(popped);
        return result.deriveLocalSet(__dx, (StackMapTableEntry)popped.get(0));
    }

    public StackMapTableState deriveMethodCall(boolean __isStatic, MethodReference __method) throws NullPointerException {
        if (__method == null) {
            throw new NullPointerException("NARG");
        }
        MethodDescriptor type = __method.memberType();
        int popCount = type.argumentCount() + (__isStatic ? 0 : 1);
        StackMapTableState result = popCount > 0 ? this.deriveStackPop(null, popCount) : this;
        if (type.hasReturnValue()) {
            return result.deriveStackPush(type.returnValue());
        }
        return result;
    }

    public StackMapTableState deriveStackPop(List<StackMapTableEntry> __popped) throws InvalidClassFormatException {
        int depth = this.depth;
        if (depth < 0) {
            throw new InvalidClassFormatException("JC03", this);
        }
        StackMapTableEntry top = this.getStackFromLogicalTop(0);
        if (__popped != null) {
            __popped.add(0, top);
        }
        return new StackMapTableState(this._locals, (StackMapTableEntry[])this._stack.clone(), depth - (top.isWide() ? 2 : 1), false);
    }

    public StackMapTableState deriveStackPop(List<StackMapTableEntry> __popped, int __count) throws InvalidClassFormatException {
        if (__count <= 0) {
            throw new IllegalArgumentException("JC05");
        }
        StackMapTableState result = this;
        for (int i2 = 0; i2 < __count; ++i2) {
            result = result.deriveStackPop(__popped);
        }
        return result;
    }

    public StackMapTableState deriveStackPopThenPush(List<StackMapTableEntry> __popped, int __count, StackMapTableEntry ... __entries) throws InvalidClassFormatException {
        return this.deriveStackPop(__popped, __count).deriveStackPush(__entries);
    }

    public StackMapTableState deriveStackPush(FieldDescriptor ... __entries) {
        int count = __entries == null ? 0 : __entries.length;
        StackMapTableEntry[] mapped = new StackMapTableEntry[count];
        for (int i2 = 0; i2 < count; ++i2) {
            mapped[i2] = new StackMapTableEntry(__entries[i2], true);
        }
        return this.deriveStackPush(mapped);
    }

    public StackMapTableState deriveStackPush(StackMapTableEntry ... __entries) throws InvalidClassFormatException, NullPointerException {
        StackMapTableEntry[] newStack = (StackMapTableEntry[])this._stack.clone();
        int newDepth = this.depth;
        for (StackMapTableEntry entry : __entries) {
            if (newDepth + (entry.isWide() ? 2 : 1) > newStack.length) {
                throw new InvalidClassFormatException("JC04", this);
            }
            newStack[newDepth++] = entry;
            if (!entry.isWide()) continue;
            newStack[newDepth++] = entry.topType();
        }
        return new StackMapTableState(this._locals, newStack, newDepth, false);
    }

    public StackMapTableState deriveStackShuffle(JavaStackShuffleType __shuffle) throws NullPointerException {
        if (__shuffle == null) {
            throw new NullPointerException("NARG");
        }
        JavaStackShuffleType.Function function = JavaStackShuffleType.findShuffleFunction(this, __shuffle);
        ArrayList<StackMapTableEntry> popped = new ArrayList<StackMapTableEntry>();
        StackMapTableState result = this.deriveStackPop(popped, function.in.logicalMax);
        int pushCount = function.out.logicalMax;
        StackMapTableEntry[] pushed = new StackMapTableEntry[pushCount];
        for (int i2 = 0; i2 < pushCount; ++i2) {
            pushed[i2] = (StackMapTableEntry)popped.get(function.out.logicalSlot(i2));
        }
        result = result.deriveStackPush(pushed);
        return result;
    }

    public StackMapTableEntry getLocal(int __i) throws InvalidClassFormatException {
        StackMapTableEntry[] locals = this._locals;
        if (__i < 0 || __i >= locals.length) {
            throw new InvalidClassFormatException(String.format("JC3y %d", __i), this);
        }
        return locals[__i];
    }

    public List<StackMapTableEntry> getStack() {
        return UnmodifiableList.of(Arrays.asList(this._stack));
    }

    public StackMapTableEntry getStack(int __i) throws InvalidClassFormatException {
        if (__i < 0 || __i >= this.depth) {
            throw new InvalidClassFormatException(String.format("JC3z %d", __i), this);
        }
        return this._stack[__i];
    }

    public StackMapTableEntry getStackFromLogicalTop(int __i) throws InvalidClassFormatException {
        int logical = 0;
        int actual = 0;
        while (true) {
            StackMapTableEntry entry;
            if ((entry = this.getStackFromTop(actual)).isTop()) {
                ++actual;
                continue;
            }
            if (logical == __i) {
                return entry;
            }
            ++logical;
            ++actual;
        }
    }

    public StackMapTableEntry getStackFromTop(int __i) throws InvalidClassFormatException {
        if (__i < 0 || __i >= this.depth) {
            throw new InvalidClassFormatException(String.format("JC79 %d %d", __i, this.depth), this);
        }
        return this.getStack(this.depth - 1 - __i);
    }

    public final int maxLocals() {
        return this._locals.length;
    }

    public final int maxStack() {
        return this._stack.length;
    }

    public String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            StringBuilder sb = new StringBuilder("{locals=");
            StackMapTableState.__stringize(this._locals, sb);
            sb.append(", stack(");
            sb.append(this.depth);
            sb.append(")=");
            StackMapTableState.__stringize(this._stack, sb);
            sb.append("}");
            rv = sb.toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    private static void __stringize(StackMapTableEntry[] __jt, StringBuilder __sb) throws NullPointerException {
        if (__jt == null || __sb == null) {
            throw new NullPointerException("NARG");
        }
        __sb.append('[');
        int n2 = __jt.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                __sb.append(", ");
            }
            __sb.append(__jt[i2]);
        }
        __sb.append(']');
    }

    private static void __verify(StackMapTableEntry[] __t) throws InvalidClassFormatException, NullPointerException {
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        JavaType w2 = null;
        int n2 = __t.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType a2;
            StackMapTableEntry ea = __t[i2];
            JavaType javaType = a2 = ea != null ? ea.type() : null;
            if (w2 != null) {
                JavaType t2 = w2.topType();
                if (!t2.equals(a2)) {
                    throw new InvalidClassFormatException(String.format("JC40 %s %s %s %s", w2, t2, a2, Arrays.asList(__t)));
                }
                w2 = null;
                continue;
            }
            if (a2 == null || !a2.isWide()) continue;
            w2 = a2;
        }
        if (w2 != null) {
            throw new InvalidClassFormatException("JC41");
        }
    }
}

