/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.multiphasicapps.classfile.InstructionJumpTarget;
import net.multiphasicapps.classfile.IntMatchingJumpTable;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.LookupSwitch;

public final class TableSwitch
implements IntMatchingJumpTable {
    protected final InstructionJumpTarget defaultjump;
    protected final int low;
    protected final int high;
    private final InstructionJumpTarget[] _jumps;
    private Reference<String> _string;

    public TableSwitch(InstructionJumpTarget __def, int __lo, int __hi, InstructionJumpTarget[] __jumps) throws InvalidClassFormatException, NullPointerException {
        if (__def == null || __jumps == null) {
            throw new NullPointerException("NARG");
        }
        if (__lo > __hi) {
            throw new InvalidClassFormatException(String.format("JC42 %d %d", __lo, __hi), this);
        }
        for (InstructionJumpTarget j2 : __jumps = (InstructionJumpTarget[])__jumps.clone()) {
            if (j2 != null) continue;
            throw new NullPointerException("NARG");
        }
        this.low = __lo;
        this.high = __hi;
        this.defaultjump = __def;
        this._jumps = __jumps;
    }

    public final LookupSwitch asLookupSwitch() {
        InstructionJumpTarget[] jumps = this._jumps;
        int low = this.low;
        int high = this.high;
        int n2 = jumps.length;
        int[] newkeys = new int[n2];
        int o2 = 0;
        int k2 = low;
        while (k2 <= high) {
            newkeys[o2] = k2++;
            ++o2;
        }
        return new LookupSwitch(this.defaultjump, newkeys, jumps);
    }

    public final InstructionJumpTarget[] jumps() {
        return (InstructionJumpTarget[])this._jumps.clone();
    }

    @Override
    public final InstructionJumpTarget match(int __k) {
        int low = this.low;
        int high = this.high;
        if (__k < low || __k > high) {
            return this.defaultjump;
        }
        return this._jumps[__k - low];
    }

    public final int size() {
        return this._jumps.length;
    }

    @Override
    public final InstructionJumpTarget[] targets() {
        InstructionJumpTarget[] jumps = this._jumps;
        int n2 = jumps.length;
        InstructionJumpTarget[] rv = new InstructionJumpTarget[n2 + 1];
        rv[0] = this.defaultjump;
        int i2 = 0;
        int o2 = 1;
        while (i2 < n2) {
            rv[o2] = jumps[i2];
            ++i2;
            ++o2;
        }
        return rv;
    }

    public final String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            StringBuilder sb = new StringBuilder("{default=");
            sb.append(this.defaultjump);
            InstructionJumpTarget[] jumps = this._jumps;
            int i2 = 0;
            int n2 = jumps.length;
            int v2 = this.low;
            while (i2 < n2) {
                sb.append(", ");
                sb.append(v2);
                sb.append('=');
                sb.append(jumps[i2]);
                ++i2;
                ++v2;
            }
            sb.append('}');
            rv = sb.toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }
}

