/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.multiphasicapps.classfile.ByteCode;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.Contexual;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.JavaType;
import net.multiphasicapps.classfile.Method;
import net.multiphasicapps.classfile.MethodHandle;
import net.multiphasicapps.classfile.Pool;
import net.multiphasicapps.classfile.StackMapTable;
import net.multiphasicapps.classfile.StackMapTableEntry;
import net.multiphasicapps.classfile.StackMapTableState;

final class __StackMapParser__
implements Contexual {
    protected final DataInputStream in;
    protected final int maxstack;
    protected final int maxlocals;
    protected final ByteCode code;
    protected final Pool pool;
    protected final JavaType thistype;
    private final Map<Integer, StackMapTableState> _targets;
    private final StackMapTableEntry[] _nextstack;
    private final StackMapTableEntry[] _nextlocals;
    private int _placeaddr;
    private int _stacktop;

    __StackMapParser__(Pool __p, Method __m, boolean __new, byte[] __in, ByteCode __bc, JavaType __tt) throws InvalidClassFormatException, NullPointerException {
        int i2;
        boolean isinstance;
        DataInputStream xin;
        if (__p == null || __m == null || __in == null || __bc == null || __tt == null) {
            throw new NullPointerException("NARG");
        }
        this.in = xin = new DataInputStream(new ByteArrayInputStream(__in));
        int maxstack = __bc.maxStack();
        int maxlocals = __bc.maxLocals();
        this.maxstack = maxstack;
        this.maxlocals = maxlocals;
        this.code = __bc;
        this.pool = __p;
        this.thistype = __tt;
        StackMapTableEntry[] nextstack = new StackMapTableEntry[maxstack];
        this._nextstack = nextstack;
        StackMapTableEntry[] nextlocals = new StackMapTableEntry[maxlocals];
        this._nextlocals = nextlocals;
        MethodHandle handle = __m.handle();
        JavaType[] jis = handle.javaStack(isinstance = !__m.flags().isStatic());
        int jn = jis.length;
        if (jn > maxlocals) {
            throw new InvalidClassFormatException(String.format("JC43 %s %d %d", handle, jn, maxlocals), this);
        }
        boolean isiinit = isinstance && __m.name().isInstanceInitializer();
        for (i2 = 0; i2 < jn; ++i2) {
            nextlocals[i2] = new StackMapTableEntry(jis[i2], !isiinit || i2 != 0);
        }
        int n2 = nextstack.length;
        for (i2 = 0; i2 < n2; ++i2) {
            if (nextstack[i2] != null) continue;
            nextstack[i2] = StackMapTableEntry.NOTHING;
        }
        n2 = nextlocals.length;
        for (i2 = 0; i2 < n2; ++i2) {
            if (nextlocals[i2] != null) continue;
            nextlocals[i2] = StackMapTableEntry.NOTHING;
        }
        LinkedHashMap<Integer, StackMapTableState> targets = new LinkedHashMap<Integer, StackMapTableState>();
        this._targets = targets;
        this.__next(0, true, -1, -1);
        try (DataInputStream in = xin;){
            int ne;
            if (!__new) {
                ne = xin.readUnsignedShort();
                for (int i3 = 0; i3 < ne; ++i3) {
                    this.__next(this.__oldStyle(), true, -1, i3);
                }
            } else {
                ne = xin.readUnsignedShort();
                for (int i4 = 0; i4 < ne; ++i4) {
                    int addr;
                    int type = xin.readUnsignedByte();
                    if (type == 255) {
                        addr = this.__fullFrame();
                    } else if (type >= 0 && type <= 63) {
                        addr = this.__sameFrame(type);
                    } else if (type >= 64 && type <= 127) {
                        addr = this.__sameLocalsSingleStack(type - 64);
                    } else if (type == 247) {
                        addr = this.__sameLocalsSingleStackExplicit();
                    } else if (type >= 248 && type <= 250) {
                        addr = this.__choppedFrame(251 - type);
                    } else if (type == 251) {
                        addr = this.__sameFrameDelta();
                    } else if (type >= 252 && type <= 254) {
                        addr = this.__appendFrame(type - 251);
                    } else {
                        throw new InvalidClassFormatException(String.format("JC44 %d", type), this);
                    }
                    this.__next(addr, false, type, i4);
                }
            }
        }
        catch (IOException e2) {
            throw new InvalidClassFormatException("JC45", e2, this);
        }
    }

    public StackMapTable get() {
        return new StackMapTable(this._targets);
    }

    private int __appendFrame(int __addlocs) throws IOException {
        DataInputStream in = this.in;
        int rv = in.readUnsignedShort();
        this._stacktop = 0;
        StackMapTableEntry[] nextlocals = this._nextlocals;
        int n2 = this.maxlocals;
        for (int i2 = 0; __addlocs > 0 && i2 < n2; ++i2) {
            StackMapTableEntry aa2;
            StackMapTableEntry s2 = nextlocals[i2];
            if (!s2.equals(StackMapTableEntry.NOTHING)) continue;
            nextlocals[i2] = aa2 = this.__loadInfo();
            --__addlocs;
            if (!aa2.isWide()) continue;
            nextlocals[++i2] = aa2.topType();
        }
        if (__addlocs != 0) {
            throw new InvalidClassFormatException(String.format("JC46 %d", __addlocs), this);
        }
        return rv;
    }

    private int __choppedFrame(int __chops) throws IOException {
        DataInputStream in = this.in;
        int rv = in.readUnsignedShort();
        this._stacktop = 0;
        StackMapTableEntry[] nextlocals = this._nextlocals;
        int n2 = this.maxlocals;
        for (int i2 = n2 - 1; __chops > 0 && i2 >= 0; --i2) {
            StackMapTableEntry s2 = nextlocals[i2];
            if (s2.equals(StackMapTableEntry.NOTHING)) continue;
            if (s2.isTop() && !s2.equals(StackMapTableEntry.TOP_UNDEFINED)) {
                nextlocals[i2--] = StackMapTableEntry.NOTHING;
            }
            nextlocals[i2] = StackMapTableEntry.NOTHING;
            --__chops;
        }
        if (__chops != 0) {
            throw new InvalidClassFormatException(String.format("JC47 %d", __chops), this);
        }
        return rv;
    }

    private int __fullFrame() throws IOException {
        int i2;
        DataInputStream in = this.in;
        int rv = in.readUnsignedShort();
        int nl = in.readUnsignedShort();
        int maxlocals = this.maxlocals;
        int maxstack = this.maxstack;
        if (nl > maxlocals) {
            throw new InvalidClassFormatException(String.format("JC48 %d %d", nl, maxlocals), this);
        }
        StackMapTableEntry[] nextlocals = this._nextlocals;
        int o2 = 0;
        for (i2 = 0; i2 < nl; ++i2) {
            StackMapTableEntry e2;
            nextlocals[o2++] = e2 = this.__loadInfo();
            if (!e2.isWide()) continue;
            nextlocals[o2++] = e2.topType();
        }
        while (o2 < maxlocals) {
            nextlocals[o2] = StackMapTableEntry.NOTHING;
            ++o2;
        }
        StackMapTableEntry[] nextstack = this._nextstack;
        int ns = in.readUnsignedShort();
        o2 = 0;
        for (i2 = 0; i2 < ns; ++i2) {
            StackMapTableEntry e3;
            nextstack[o2++] = e3 = this.__loadInfo();
            if (!e3.isWide()) continue;
            nextstack[o2++] = e3.topType();
        }
        this._stacktop = o2;
        return rv;
    }

    private StackMapTableEntry __loadInfo() throws IOException {
        DataInputStream in = this.in;
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 0: {
                return StackMapTableEntry.TOP_UNDEFINED;
            }
            case 1: {
                return StackMapTableEntry.INTEGER;
            }
            case 2: {
                return StackMapTableEntry.FLOAT;
            }
            case 3: {
                return StackMapTableEntry.DOUBLE;
            }
            case 4: {
                return StackMapTableEntry.LONG;
            }
            case 5: {
                return StackMapTableEntry.NOTHING;
            }
            case 6: {
                return new StackMapTableEntry(this.thistype, false);
            }
            case 7: {
                return new StackMapTableEntry(new JavaType(this.pool.get(ClassName.class, in.readUnsignedShort()).field()), true);
            }
            case 8: {
                return new StackMapTableEntry(new JavaType(this.pool.get(ClassName.class, this.code.readRawCodeUnsignedShort(in.readUnsignedShort() + 1))), false);
            }
        }
        throw new InvalidClassFormatException(String.format("JC49 %d", tag), this);
    }

    StackMapTableState __next(int __au, boolean __abs, int __type, int __ne) {
        int pp;
        StackMapTableState rv;
        int naddr = this._placeaddr;
        try {
            rv = new StackMapTableState(this._nextlocals, this._nextstack, this._stacktop);
        }
        catch (InvalidClassFormatException e2) {
            throw new InvalidClassFormatException(String.format("JC4a %d %b %d %d", __au, __abs, naddr, __type), e2, this);
        }
        this._placeaddr = pp = __abs ? __au : naddr + (__au + (__ne == 0 ? 0 : 1));
        Map<Integer, StackMapTableState> targets = this._targets;
        if (pp != 0 && targets.containsKey(pp)) {
            throw new IllegalStateException(String.format("JC4b %d %s %s %b %d %d %d", pp, targets.get(pp), rv, __abs, naddr, __au, __type));
        }
        targets.put(pp, rv);
        return rv;
    }

    private int __oldStyle() throws IOException {
        DataInputStream in = this.in;
        int rv = in.readUnsignedShort();
        int nl = in.readUnsignedShort();
        StackMapTableEntry[] inlocals = new StackMapTableEntry[nl];
        for (int i2 = 0; i2 < nl; ++i2) {
            inlocals[i2] = this.__loadInfo();
        }
        int ns = in.readUnsignedShort();
        StackMapTableEntry[] instack = new StackMapTableEntry[ns];
        for (int i3 = 0; i3 < ns; ++i3) {
            instack[i3] = this.__loadInfo();
        }
        int lat = 0;
        StackMapTableEntry[] nextlocals = this._nextlocals;
        for (int i4 = 0; i4 < nl; ++i4) {
            StackMapTableEntry e2 = inlocals[i4];
            nextlocals[lat++] = e2;
            if (!e2.isWide()) continue;
            nextlocals[lat++] = e2.topType();
            if (i4 + 1 >= nl || !inlocals[i4 + 1].isTop()) continue;
            ++i4;
        }
        int sat = 0;
        StackMapTableEntry[] nextstack = this._nextstack;
        for (int i5 = 0; i5 < ns; ++i5) {
            StackMapTableEntry e3 = instack[i5];
            nextstack[sat++] = e3;
            if (!e3.isWide()) continue;
            nextstack[sat++] = e3.topType();
            if (i5 + 1 >= ns || !instack[i5 + 1].isTop()) continue;
            ++i5;
        }
        this._stacktop = sat;
        return rv;
    }

    private int __sameFrame(int __delta) {
        return __delta;
    }

    private int __sameFrameDelta() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int __sameLocalsSingleStack(int __delta) throws IOException {
        StackMapTableEntry ent;
        this._nextstack[0] = ent = this.__loadInfo();
        if (ent.isWide()) {
            this._nextstack[1] = ent.topType();
            this._stacktop = 2;
        } else {
            this._stacktop = 1;
        }
        return __delta;
    }

    private int __sameLocalsSingleStackExplicit() throws IOException {
        return this.__sameLocalsSingleStack(this.in.readUnsignedShort());
    }
}

